/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt;

import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeGuidedDecisionTable
implements PortableObject {
    private static final long serialVersionUID = 510L;
    public static final int INTERNAL_ELEMENTS = 2;
    public static final String NEGATE_RULE_ATTR = "negate";
    private String tableName;
    private String parentName;
    private RowNumberCol rowNumberCol = new RowNumberCol();
    private DescriptionCol descriptionCol = new DescriptionCol();
    private List<MetadataCol> metadataCols = new ArrayList<MetadataCol>();
    private List<AttributeCol> attributeCols = new ArrayList<AttributeCol>();
    private List<ConditionCol> conditionCols = new ArrayList<ConditionCol>();
    private List<ActionCol> actionCols = new ArrayList<ActionCol>();
    private List<List<DTCellValue>> data = new ArrayList<List<DTCellValue>>();

    public List<ActionCol> getActionCols() {
        return this.actionCols;
    }

    public List<AttributeCol> getAttributeCols() {
        return this.attributeCols;
    }

    public List<ConditionCol> getConditionCols() {
        return this.conditionCols;
    }

    public List<List<DTCellValue>> getData() {
        return this.data;
    }

    public List<DTColumnConfig> getAllColumns() {
        ArrayList<DTColumnConfig> columns = new ArrayList<DTColumnConfig>();
        columns.add(this.rowNumberCol);
        columns.add(this.descriptionCol);
        columns.addAll(this.metadataCols);
        columns.addAll(this.attributeCols);
        columns.addAll(this.conditionCols);
        columns.addAll(this.actionCols);
        return columns;
    }

    public DescriptionCol getDescriptionCol() {
        if (this.descriptionCol == null) {
            this.descriptionCol = new DescriptionCol();
        }
        return this.descriptionCol;
    }

    public List<MetadataCol> getMetadataCols() {
        if (null == this.metadataCols) {
            this.metadataCols = new ArrayList<MetadataCol>();
        }
        return this.metadataCols;
    }

    public String getParentName() {
        return this.parentName;
    }

    public RowNumberCol getRowNumberCol() {
        if (this.rowNumberCol == null) {
            this.rowNumberCol = new RowNumberCol();
        }
        return this.rowNumberCol;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType(DTColumnConfig col, SuggestionCompletionEngine sce) {
        String type = null;
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            type = at.getAttribute();
        } else if (col instanceof ConditionCol) {
            ConditionCol c = (ConditionCol)col;
            type = sce.getFieldType(c.getFactType(), c.getFactField());
        } else if (col instanceof ActionSetFieldCol) {
            ActionSetFieldCol c = (ActionSetFieldCol)col;
            type = sce.getFieldType(this.getBoundFactType(c.getBoundName()), c.getFactField());
        } else if (col instanceof ActionInsertFactCol) {
            ActionInsertFactCol c = (ActionInsertFactCol)col;
            type = sce.getFieldType(c.getFactType(), c.getFactField());
        }
        return type;
    }

    public String[] getValueList(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            if ("no-loop".equals(at.getAttribute()) || "enabled".equals(at.getAttribute())) {
                return new String[]{"true", "false"};
            }
        } else {
            if (col instanceof ConditionCol) {
                ConditionCol c = (ConditionCol)col;
                if (c.getConstraintValueType() == 3 || c.getConstraintValueType() == 5) {
                    return new String[0];
                }
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(c.getFactType(), c.getFactField());
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionSetFieldCol) {
                ActionSetFieldCol c = (ActionSetFieldCol)col;
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(this.getBoundFactType(c.getBoundName()), c.getFactField());
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionInsertFactCol) {
                ActionInsertFactCol c = (ActionInsertFactCol)col;
                if (c.getValueList() != null && !"".equals(c.getValueList())) {
                    return c.getValueList().split(",");
                }
                String[] r = sce.getEnumValues(c.getFactType(), c.getFactField());
                return r != null ? r : new String[]{};
            }
        }
        return new String[0];
    }

    public boolean isBoolean(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            return "enabled".equals(at.getAttribute()) || "no-loop".equals(at.getAttribute()) || "auto-focus".equals(at.getAttribute()) || "lock-on-active".equals(at.getAttribute());
        }
        return this.isDataType(col, sce, "Boolean");
    }

    public boolean isConstraintValid(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof RowNumberCol) {
            return true;
        }
        if (col instanceof DescriptionCol) {
            return true;
        }
        if (col instanceof MetadataCol) {
            return true;
        }
        if (col instanceof AttributeCol) {
            return true;
        }
        if (col instanceof ConditionCol) {
            ConditionCol c = (ConditionCol)col;
            if (c.getConstraintValueType() == 1) {
                if (c.getFactField() == null || c.getFactField().equals("")) {
                    return false;
                }
                return c.getOperator() != null && !c.getOperator().equals("");
            }
            return true;
        }
        return col instanceof ActionCol;
    }

    public boolean isDate(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            return "date-effective".equals(at.getAttribute()) || "date-expires".equals(at.getAttribute());
        }
        return this.isDataType(col, sce, "Date");
    }

    public boolean isNumeric(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            return "salience".equals(at.getAttribute()) || "duration".equals(at.getAttribute());
        }
        return this.isDataType(col, sce, "Numeric");
    }

    public void setData(List<List<DTCellValue>> data) {
        this.data = data;
    }

    public void setDescriptionCol(DescriptionCol descriptionCol) {
        this.descriptionCol = descriptionCol;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setRowNumberCol(RowNumberCol rowNumberCol) {
        this.rowNumberCol = rowNumberCol;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getBoundFactType(String boundName) {
        for (ConditionCol c : this.getConditionCols()) {
            if (!c.getBoundName().equals(boundName)) continue;
            return c.getFactType();
        }
        return null;
    }

    private boolean isDataType(DTColumnConfig col, SuggestionCompletionEngine sce, String dataType) {
        ActionSetFieldCol c;
        String ft;
        if (col instanceof RowNumberCol) {
            throw new IllegalArgumentException("Only ConditionCol and Actions permitted. Consider using one of the public is<DataType> methods.");
        }
        if (col instanceof DescriptionCol) {
            throw new IllegalArgumentException("Only ConditionCol and Actions permitted. Consider using one of the public is<DataType> methods.");
        }
        if (col instanceof MetadataCol) {
            throw new IllegalArgumentException("Only ConditionCol and Actions permitted. Consider using one of the public is<DataType> methods.");
        }
        if (col instanceof AttributeCol) {
            throw new IllegalArgumentException("Only ConditionCol and Actions permitted. Consider using one of the public is<DataType> methods.");
        }
        if (col instanceof ConditionCol) {
            ConditionCol c2 = (ConditionCol)col;
            if (c2.getConstraintValueType() == 1) {
                if (c2.getOperator() == null || "".equals(c2.getOperator())) {
                    return false;
                }
                String ft2 = sce.getFieldType(c2.getFactType(), c2.getFactField());
                if (ft2 != null && ft2.equals(dataType)) {
                    return true;
                }
            }
        } else if (col instanceof ActionSetFieldCol ? (ft = sce.getFieldType(this.getBoundFactType((c = (ActionSetFieldCol)col).getBoundName()), c.getFactField())) != null && ft.equals(dataType) : col instanceof ActionInsertFactCol && (ft = sce.getFieldType((c = (ActionInsertFactCol)col).getFactType(), c.getFactField())) != null && ft.equals(dataType)) {
            return true;
        }
        return false;
    }
}

