/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUpgradeHelper {
    public static TypeSafeGuidedDecisionTable convertGuidedDTModel(GuidedDecisionTable legacyDTModel) {
        TypeSafeGuidedDecisionTable newDTModel = new TypeSafeGuidedDecisionTable();
        newDTModel.setTableName(legacyDTModel.getTableName());
        newDTModel.setParentName(legacyDTModel.getParentName());
        newDTModel.setRowNumberCol(legacyDTModel.getRowNumberCol());
        newDTModel.setDescriptionCol(legacyDTModel.getDescriptionCol());
        newDTModel.getMetadataCols().addAll(legacyDTModel.getMetadataCols());
        newDTModel.getAttributeCols().addAll(legacyDTModel.getAttributeCols());
        newDTModel.getConditionCols().addAll(legacyDTModel.getConditionCols());
        newDTModel.getActionCols().addAll(legacyDTModel.getActionCols());
        newDTModel.setData(RepositoryUpgradeHelper.makeDataLists(legacyDTModel.getData()));
        return newDTModel;
    }

    public static List<List<DTCellValue>> makeDataLists(String[][] oldData) {
        ArrayList<List<DTCellValue>> newData = new ArrayList<List<DTCellValue>>();
        for (int iRow = 0; iRow < oldData.length; ++iRow) {
            String[] oldRow = oldData[iRow];
            List<DTCellValue> newRow = RepositoryUpgradeHelper.makeDataRowList(oldRow);
            newData.add(newRow);
        }
        return newData;
    }

    public static List<DTCellValue> makeDataRowList(String[] oldRow) {
        ArrayList<DTCellValue> row = new ArrayList<DTCellValue>();
        DTCellValue rowDcv = new DTCellValue(new BigDecimal(oldRow[0]));
        row.add(rowDcv);
        for (int iCol = 1; iCol < oldRow.length; ++iCol) {
            DTCellValue dcv = new DTCellValue(oldRow[iCol]);
            row.add(dcv);
        }
        return row;
    }
}

