/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.ModelAnnotation;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.junit.Assert;
import org.junit.Test;

public class SuggestionCompletionEngineTest {
    @Test
    public void testNestedImports() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
    }

    @Test
    public void testStringNonNumeric() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.Alert";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("Alert", "message"));
    }

    @Test
    public void testDataEnums() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Person.age' : [42, 43] \n 'Person.sex' : ['M', 'F']");
        enums.add("'Driver.sex' : ['M', 'F']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
        Assert.assertEquals((long)3L, (long)engine.getDataEnumListsSize());
        String[] items = engine.getDataEnumList("Person.age");
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"42", (Object)items[0]);
        Assert.assertEquals((Object)"43", (Object)items[1]);
        items = engine.getEnums((FactPattern)new FactPattern((String)"Person"), (String)"age").fixedList;
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"42", (Object)items[0]);
        Assert.assertEquals((Object)"43", (Object)items[1]);
        Assert.assertNull((Object)engine.getEnums(new FactPattern("Nothing"), "age"));
        Assert.assertEquals(null, (Object)engine.getEnums(new FactPattern("Something"), "else"));
    }

    @Test
    public void testDataEnums3() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Fact.f1' : ['a1', 'a2'] \n 'Fact.f2' : ['def1', 'def2', 'def3'] \n 'Fact.f2[f1=a2]' : ['c1', 'c2']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint f1 = new SingleFieldConstraint("f1");
        f1.setValue("a1");
        pat.addConstraint((FieldConstraint)f1);
        pat.addConstraint((FieldConstraint)new SingleFieldConstraint("f2"));
        DropDownData data = engine.getEnums(pat, "f2");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)3L, (long)data.fixedList.length);
    }

    @Test
    public void testDataEnums2() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.Fact";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Fact.field1' : ['val1', 'val2'], 'Fact.field2' : ['val3', 'val4'], 'Fact.field2[field1=val1]' : ['f1val1a', 'f1val1b'], 'Fact.field2[field1=val2]' : ['f1val2a', 'f1val2b']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("SuggestionCompletionEngineTest$Fact", "field1"));
        Assert.assertEquals((Object)"String", (Object)engine.getFieldType("SuggestionCompletionEngineTest$Fact", "field2"));
        Assert.assertEquals((long)4L, (long)engine.getDataEnumListsSize());
        String[] items = engine.getDataEnumList("Fact.field2");
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"val3", (Object)items[0]);
        Assert.assertEquals((Object)"val4", (Object)items[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field2");
        pat.addConstraint((FieldConstraint)sfc);
        items = engine.getEnums((FactPattern)pat, (String)"field2").fixedList;
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"val3", (Object)items[0]);
        Assert.assertEquals((Object)"val4", (Object)items[1]);
        items = engine.getDataEnumList("Fact.field1");
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"val1", (Object)items[0]);
        Assert.assertEquals((Object)"val2", (Object)items[1]);
        items = engine.getEnums((FactPattern)new FactPattern((String)"Fact"), (String)"field1").fixedList;
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"val1", (Object)items[0]);
        Assert.assertEquals((Object)"val2", (Object)items[1]);
    }

    @Test
    public void testCompletions() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"Person", "Vehicle"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Person", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("rank", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Comparable"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
                this.put("Vehicle", new ModelField[]{new ModelField("make", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("type", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        com.setGlobalVariables((Map)new HashMap<String, String>(){
            {
                this.put("bar", "Person");
                this.put("baz", "Vehicle");
            }
        });
        String[] c = com.getConditionalElements();
        Assert.assertEquals((Object)"not", (Object)c[0]);
        Assert.assertEquals((Object)"exists", (Object)c[1]);
        Assert.assertEquals((Object)"or", (Object)c[2]);
        c = com.getFactTypes();
        Assert.assertEquals((long)2L, (long)c.length);
        this.assertContains("Person", c);
        this.assertContains("Vehicle", c);
        c = com.getFieldCompletions("Person");
        Assert.assertEquals((Object)"age", (Object)c[0]);
        Assert.assertEquals((Object)"rank", (Object)c[1]);
        Assert.assertEquals((Object)"name", (Object)c[2]);
        c = com.getFieldCompletions("Vehicle");
        Assert.assertEquals((Object)"type", (Object)c[1]);
        Assert.assertEquals((Object)"make", (Object)c[0]);
        c = com.getOperatorCompletions("Person", "name");
        Assert.assertEquals((long)6L, (long)c.length);
        Assert.assertEquals((Object)"==", (Object)c[0]);
        Assert.assertEquals((Object)"!=", (Object)c[1]);
        Assert.assertEquals((Object)"matches", (Object)c[2]);
        c = com.getOperatorCompletions("Person", "age");
        Assert.assertEquals((long)8L, (long)c.length);
        Assert.assertEquals((Object)c[0], (Object)"==");
        Assert.assertEquals((Object)c[1], (Object)"!=");
        Assert.assertEquals((Object)c[2], (Object)"<");
        Assert.assertEquals((Object)c[3], (Object)">");
        c = com.getOperatorCompletions("Person", "rank");
        Assert.assertEquals((long)8L, (long)c.length);
        Assert.assertEquals((Object)c[0], (Object)"==");
        Assert.assertEquals((Object)c[1], (Object)"!=");
        Assert.assertEquals((Object)c[2], (Object)"<");
        Assert.assertEquals((Object)c[3], (Object)">");
        c = com.getConnectiveOperatorCompletions("Vehicle", "make");
        Assert.assertEquals((long)5L, (long)c.length);
        Assert.assertEquals((Object)"|| ==", (Object)c[0]);
        c = com.getGlobalVariables();
        Assert.assertEquals((long)2L, (long)c.length);
        Assert.assertEquals((Object)"baz", (Object)c[0]);
        Assert.assertEquals((Object)"bar", (Object)c[1]);
        c = com.getFieldCompletionsForGlobalVariable("bar");
        Assert.assertEquals((long)3L, (long)c.length);
        Assert.assertEquals((Object)"age", (Object)c[0]);
        Assert.assertEquals((Object)"rank", (Object)c[1]);
        Assert.assertEquals((Object)"name", (Object)c[2]);
        c = com.getFieldCompletionsForGlobalVariable("baz");
        Assert.assertEquals((long)2L, (long)c.length);
        Assert.assertEquals((Object)"make", (Object)c[0]);
        Assert.assertEquals((Object)"type", (Object)c[1]);
        c = com.getOperatorCompletions("Person", "wankle");
        Assert.assertEquals((long)4L, (long)c.length);
        Assert.assertEquals((Object)"Numeric", (Object)com.getFieldType("Person", "age"));
    }

    @Test
    public void testCEPCompletions() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"NotAnEvent", "AnEvent"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("NotAnEvent", new ModelField[]{new ModelField("dateField", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date")});
                this.put("AnEvent", new ModelField[]{new ModelField("this", Object.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "this"), new ModelField("dateField", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date")});
            }
        });
        HashMap annotations = new HashMap();
        ArrayList<ModelAnnotation> eventAnnotations = new ArrayList<ModelAnnotation>();
        ModelAnnotation ma = new ModelAnnotation();
        ma.setAnnotationName("role");
        HashMap<String, String> mav = new HashMap<String, String>();
        mav.put("value", "event");
        ma.setAnnotationValues(mav);
        eventAnnotations.add(ma);
        annotations.put("AnEvent", eventAnnotations);
        com.setAnnotationsForTypes(annotations);
        String[] c = com.getFactTypes();
        Assert.assertEquals((long)2L, (long)c.length);
        this.assertContains("NotAnEvent", c);
        this.assertContains("AnEvent", c);
        c = com.getOperatorCompletions("NotAnEvent", "dateField");
        Assert.assertEquals((long)11L, (long)c.length);
        Assert.assertEquals((Object)c[0], (Object)"==");
        Assert.assertEquals((Object)c[1], (Object)"!=");
        Assert.assertEquals((Object)c[2], (Object)"<");
        Assert.assertEquals((Object)c[3], (Object)">");
        Assert.assertEquals((Object)c[4], (Object)"<=");
        Assert.assertEquals((Object)c[5], (Object)">=");
        Assert.assertEquals((Object)c[6], (Object)"== null");
        Assert.assertEquals((Object)c[7], (Object)"!= null");
        Assert.assertEquals((Object)c[8], (Object)"after");
        Assert.assertEquals((Object)c[9], (Object)"before");
        Assert.assertEquals((Object)c[10], (Object)"coincides");
        c = com.getOperatorCompletions("AnEvent", "this");
        Assert.assertEquals((long)17L, (long)c.length);
        Assert.assertEquals((Object)c[0], (Object)"==");
        Assert.assertEquals((Object)c[1], (Object)"!=");
        Assert.assertEquals((Object)c[2], (Object)"== null");
        Assert.assertEquals((Object)c[3], (Object)"!= null");
        Assert.assertEquals((Object)c[4], (Object)"after");
        Assert.assertEquals((Object)c[5], (Object)"before");
        Assert.assertEquals((Object)c[6], (Object)"coincides");
        Assert.assertEquals((Object)c[7], (Object)"during");
        Assert.assertEquals((Object)c[8], (Object)"finishes");
        Assert.assertEquals((Object)c[9], (Object)"finishedby");
        Assert.assertEquals((Object)c[10], (Object)"includes");
        Assert.assertEquals((Object)c[11], (Object)"meets");
        Assert.assertEquals((Object)c[12], (Object)"metby");
        Assert.assertEquals((Object)c[13], (Object)"overlaps");
        Assert.assertEquals((Object)c[14], (Object)"overlappedby");
        Assert.assertEquals((Object)c[15], (Object)"starts");
        Assert.assertEquals((Object)c[16], (Object)"startedby");
    }

    @Test
    public void testCEPParameterCompletions() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"AnEvent"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("AnEvent", new ModelField[]{new ModelField("this", Object.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "this")});
            }
        });
        HashMap annotations = new HashMap();
        ArrayList<ModelAnnotation> eventAnnotations = new ArrayList<ModelAnnotation>();
        ModelAnnotation ma = new ModelAnnotation();
        ma.setAnnotationName("role");
        HashMap<String, String> mav = new HashMap<String, String>();
        mav.put("value", "event");
        ma.setAnnotationValues(mav);
        eventAnnotations.add(ma);
        annotations.put("AnEvent", eventAnnotations);
        com.setAnnotationsForTypes(annotations);
        List c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"after");
        Assert.assertEquals((long)3L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"before");
        Assert.assertEquals((long)3L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"coincides");
        Assert.assertEquals((long)3L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"during");
        Assert.assertEquals((long)4L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)c.get(3)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"finishes");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"finishedby");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"includes");
        Assert.assertEquals((long)4L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)c.get(3)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"meets");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"metby");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"overlaps");
        Assert.assertEquals((long)3L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"overlappedby");
        Assert.assertEquals((long)3L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)c.get(2)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"starts");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
        c = SuggestionCompletionEngine.getCEPOperatorParameterSets((String)"startedby");
        Assert.assertEquals((long)2L, (long)c.size());
        Assert.assertEquals((long)0L, (long)((Integer)c.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)c.get(1)).intValue());
    }

    @Test
    public void testCEPOperatorValidation() {
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"=="));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"!="));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"<"));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)">"));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"<="));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)">="));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"== null"));
        Assert.assertFalse((boolean)SuggestionCompletionEngine.isCEPOperator((String)"!= null"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"after"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"before"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"coincides"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"during"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"finishes"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"finishedby"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"includes"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"meets"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"metby"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"overlaps"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"overlappedby"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"starts"));
        Assert.assertTrue((boolean)SuggestionCompletionEngine.isCEPOperator((String)"startedby"));
    }

    @Test
    public void testCEPWindowOperators() {
        List operators = SuggestionCompletionEngine.getCEPWindowOperators();
        Assert.assertEquals((long)2L, (long)operators.size());
        Assert.assertEquals((Object)"over window:time", operators.get(0));
        Assert.assertEquals((Object)"over window:length", operators.get(1));
    }

    @Test
    public void testAdd() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"Foo"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Foo", new ModelField[]{new ModelField("a", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        Assert.assertEquals((long)1L, (long)com.getFactTypes().length);
        Assert.assertEquals((Object)"Foo", (Object)com.getFactTypes()[0]);
        Assert.assertEquals((long)1L, (long)com.getFieldCompletions("Foo").length);
        Assert.assertEquals((Object)"a", (Object)com.getFieldCompletions("Foo")[0]);
    }

    @Test
    public void testSmartEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[type=sex]", new String[]{"M", "F"});
        sce.putDataEnumList("Fact.value[type=colour]", new String[]{"RED", "WHITE", "BLUE"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("type");
        sfc.setValue("sex");
        pat.addConstraint((FieldConstraint)sfc);
        String[] result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"M", (Object)result[0]);
        Assert.assertEquals((Object)"F", (Object)result[1]);
        pat = new FactPattern("Fact");
        sfc = new SingleFieldConstraint("type");
        sfc.setValue("colour");
        pat.addConstraint((FieldConstraint)sfc);
        result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"RED", (Object)result[0]);
        Assert.assertEquals((Object)"WHITE", (Object)result[1]);
        Assert.assertEquals((Object)"BLUE", (Object)result[2]);
        result = sce.getEnums((FactPattern)pat, (String)"type").fixedList;
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"sex", (Object)result[0]);
        Assert.assertEquals((Object)"colour", (Object)result[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("type", "sex", "blah"), new ActionFieldValue("value", null, "blah")};
        result = sce.getEnums((String)"Fact", (String)"value", (FieldNature[])vals).fixedList;
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"M", (Object)result[0]);
        Assert.assertEquals((Object)"F", (Object)result[1]);
        Assert.assertNull((Object)sce.getEnums("Nothing", "value", (FieldNature[])vals));
    }

    @Test
    public void testSmartEnumsDependingOfSeveralFieldsTwo() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.field1", new String[]{"a1", "a2"});
        sce.putDataEnumList("Fact.field2", new String[]{"b1", "b2"});
        sce.putDataEnumList("Fact.field3[field1=a1,field2=b1]", new String[]{"c1", "c2", "c3"});
        sce.putDataEnumList("Fact.field4[field1=a1]", new String[]{"d1", "d2"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setValue("a1");
        pat.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("field2");
        sfc2.setValue("b1");
        pat.addConstraint((FieldConstraint)sfc2);
        String[] result = sce.getEnums((FactPattern)pat, (String)"field3").fixedList;
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"c1", (Object)result[0]);
        Assert.assertEquals((Object)"c2", (Object)result[1]);
        Assert.assertEquals((Object)"c3", (Object)result[2]);
    }

    @Test
    public void testSmartEnumsDependingOfSeveralFieldsFive() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.field1", new String[]{"a1", "a2"});
        sce.putDataEnumList("Fact.field2", new String[]{"b1", "b2"});
        sce.putDataEnumList("Fact.field3", new String[]{"c1", "c2", "c3"});
        sce.putDataEnumList("Fact.longerField4", new String[]{"d1", "d2"});
        sce.putDataEnumList("Fact.field5", new String[]{"e1", "e2"});
        sce.putDataEnumList("Fact.field6[field1=a1, field2=b2, field3=c3,longerField4=d1,field5=e2]", new String[]{"f1", "f2"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setValue("a1");
        pat.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("field2");
        sfc2.setValue("b2");
        pat.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint("field3");
        sfc3.setValue("c3");
        pat.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint("longerField4");
        sfc4.setValue("d1");
        pat.addConstraint((FieldConstraint)sfc4);
        Assert.assertNull((Object)sce.getEnums(pat, "field6"));
        SingleFieldConstraint sfc5 = new SingleFieldConstraint("field5");
        sfc5.setValue("e2");
        pat.addConstraint((FieldConstraint)sfc5);
        String[] result2 = sce.getEnums((FactPattern)pat, (String)"field6").fixedList;
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertEquals((Object)"f1", (Object)result2[0]);
        Assert.assertEquals((Object)"f2", (Object)result2[1]);
    }

    @Test
    public void testSmarterLookupEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[f1, f2]", new String[]{"select something from database where x=@{f1} and y=@{f2}"});
        FactPattern fp = new FactPattern("Fact");
        String[] drops = sce.getEnums((FactPattern)fp, (String)"type").fixedList;
        Assert.assertEquals((long)2L, (long)drops.length);
        Assert.assertEquals((Object)"sex", (Object)drops[0]);
        Assert.assertEquals((Object)"colour", (Object)drops[1]);
        Map lookupFields = sce.loadDataEnumLookupFields();
        Assert.assertEquals((long)1L, (long)lookupFields.size());
        String[] flds = (String[])lookupFields.get("Fact.value");
        Assert.assertEquals((long)2L, (long)flds.length);
        Assert.assertEquals((Object)"f1", (Object)flds[0]);
        Assert.assertEquals((Object)"f2", (Object)flds[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("f1");
        sfc.setValue("f1val");
        pat.addConstraint((FieldConstraint)sfc);
        sfc = new SingleFieldConstraint("f2");
        sfc.setValue("f2val");
        pat.addConstraint((FieldConstraint)sfc);
        DropDownData dd = sce.getEnums(pat, "value");
        Assert.assertNull((Object)dd.fixedList);
        Assert.assertNotNull((Object)dd.queryExpression);
        Assert.assertNotNull((Object)dd.valuePairs);
        Assert.assertEquals((long)2L, (long)dd.valuePairs.length);
        Assert.assertEquals((Object)"select something from database where x=@{f1} and y=@{f2}", (Object)dd.queryExpression);
        Assert.assertEquals((Object)"f1=f1val", (Object)dd.valuePairs[0]);
        Assert.assertEquals((Object)"f2=f2val", (Object)dd.valuePairs[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("f1", "f1val", "blah"), new ActionFieldValue("f2", "f2val", "blah")};
        dd = sce.getEnums("Fact", "value", (FieldNature[])vals);
        Assert.assertNull((Object)dd.fixedList);
        Assert.assertNotNull((Object)dd.queryExpression);
        Assert.assertNotNull((Object)dd.valuePairs);
        Assert.assertEquals((long)2L, (long)dd.valuePairs.length);
        Assert.assertEquals((Object)"select something from database where x=@{f1} and y=@{f2}", (Object)dd.queryExpression);
        Assert.assertEquals((Object)"f1=f1val", (Object)dd.valuePairs[0]);
        Assert.assertEquals((Object)"f2=f2val", (Object)dd.valuePairs[1]);
    }

    @Test
    public void testSmarterLookupEnumsDifferentOrder() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[e1, e2]", new String[]{"select something from database where x=@{e1} and y=@{e2}"});
        sce.putDataEnumList("Fact.value[f1, f2]", new String[]{"select something from database where x=@{f1} and y=@{f2}"});
        FactPattern fp = new FactPattern("Fact");
        String[] drops = sce.getEnums((FactPattern)fp, (String)"type").fixedList;
        Assert.assertEquals((long)2L, (long)drops.length);
        Assert.assertEquals((Object)"sex", (Object)drops[0]);
        Assert.assertEquals((Object)"colour", (Object)drops[1]);
        Map lookupFields = sce.loadDataEnumLookupFields();
        Assert.assertEquals((long)1L, (long)lookupFields.size());
        String[] flds = (String[])lookupFields.get("Fact.value");
        Assert.assertEquals((long)2L, (long)flds.length);
        Assert.assertEquals((Object)"f1", (Object)flds[0]);
        Assert.assertEquals((Object)"f2", (Object)flds[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("f1");
        sfc.setValue("f1val");
        pat.addConstraint((FieldConstraint)sfc);
        sfc = new SingleFieldConstraint("f2");
        sfc.setValue("f2val");
        pat.addConstraint((FieldConstraint)sfc);
        DropDownData dd = sce.getEnums(pat, "value");
        Assert.assertNull((Object)dd.fixedList);
        Assert.assertNotNull((Object)dd.queryExpression);
        Assert.assertNotNull((Object)dd.valuePairs);
        Assert.assertEquals((long)2L, (long)dd.valuePairs.length);
        Assert.assertEquals((Object)"select something from database where x=@{f1} and y=@{f2}", (Object)dd.queryExpression);
        Assert.assertEquals((Object)"f1=f1val", (Object)dd.valuePairs[0]);
        Assert.assertEquals((Object)"f2=f2val", (Object)dd.valuePairs[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("f1", "f1val", "blah"), new ActionFieldValue("f2", "f2val", "blah")};
        dd = sce.getEnums("Fact", "value", (FieldNature[])vals);
        Assert.assertNull((Object)dd.fixedList);
        Assert.assertNotNull((Object)dd.queryExpression);
        Assert.assertNotNull((Object)dd.valuePairs);
        Assert.assertEquals((long)2L, (long)dd.valuePairs.length);
        Assert.assertEquals((Object)"select something from database where x=@{f1} and y=@{f2}", (Object)dd.queryExpression);
        Assert.assertEquals((Object)"f1=f1val", (Object)dd.valuePairs[0]);
        Assert.assertEquals((Object)"f2=f2val", (Object)dd.valuePairs[1]);
    }

    @Test
    public void testSimpleEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        Assert.assertEquals((long)2L, (long)sce.getEnumValues("Fact", "type").length);
        Assert.assertEquals((Object)"sex", (Object)sce.getEnumValues("Fact", "type")[0]);
        Assert.assertEquals((Object)"colour", (Object)sce.getEnumValues("Fact", "type")[1]);
    }

    private void assertContains(String string, String[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (!string.equals(c[i])) continue;
            return;
        }
        Assert.fail((String)("String array did not contain: " + string));
    }

    @Test
    public void testGlobalAndFacts() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setGlobalVariables((Map)new HashMap<String, String>(){
            {
                this.put("y", "Foo");
            }
        });
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Foo", new ModelField[]{new ModelField("a", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        Assert.assertFalse((boolean)com.isGlobalVariable("x"));
        Assert.assertTrue((boolean)com.isGlobalVariable("y"));
    }

    @Test
    public void testDataDropDown() {
        Assert.assertNull((Object)DropDownData.create(null));
        Assert.assertNull((Object)DropDownData.create(null, null));
        Assert.assertNotNull((Object)DropDownData.create((String[])new String[]{"hey"}));
        Assert.assertNotNull((Object)DropDownData.create((String)"abc", (String[])new String[]{"hey"}));
    }

    @Test
    public void testFilter() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFactTypes(new String[]{"Person", "Vehicle"});
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Person", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric")});
                this.put("Vehicle", new ModelField[]{new ModelField("make", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        Assert.assertEquals((long)2L, (long)sce.getFactTypes().length);
        sce.setFactTypeFilter(new FactTypeFilter(){

            public boolean filter(String originalFact) {
                return "Person".equals(originalFact);
            }
        });
        Assert.assertEquals((long)1L, (long)sce.getFactTypes().length);
        sce.setFilteringFacts(false);
        Assert.assertEquals((long)2L, (long)sce.getFactTypes().length);
        sce.setFilteringFacts(true);
        Assert.assertEquals((long)1L, (long)sce.getFactTypes().length);
        sce.setFactTypeFilter(null);
        Assert.assertEquals((long)2L, (long)sce.getFactTypes().length);
    }

    public static class Fact {
        private String field1;
        private String field2;

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }
    }

    public static class NestedClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

