/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import java.util.HashMap;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollection;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionGlobalVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionUnboundFact;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVisitor;

public class CopyExpressionVisitor
implements ExpressionVisitor {
    private ExpressionPart root;
    private ExpressionPart curr;

    public ExpressionPart copy(ExpressionPart part) {
        this.root = null;
        this.curr = null;
        part.accept(this);
        return this.root;
    }

    public void visit(ExpressionPart part) {
        throw new RuntimeException("can't copy an abstract class: " + ExpressionPart.class.getName());
    }

    public void visit(ExpressionField part) {
        this.add(new ExpressionField(part.getName(), part.getClassType(), part.getGenericType(), part.getParametricType()));
        this.moveNext(part);
    }

    public void visit(ExpressionMethod part) {
        ExpressionMethod method = new ExpressionMethod(part.getName(), part.getClassType(), part.getGenericType(), part.getParametricType());
        this.copyMethodParams(part, method);
        this.add(method);
        this.moveNext(part);
    }

    public void visit(ExpressionVariable part) {
        this.add(new ExpressionVariable(part.getFact()));
        this.moveNext(part);
    }

    public void visit(ExpressionUnboundFact part) {
        this.add(new ExpressionUnboundFact(part.getFact()));
        this.moveNext(part);
    }

    public void visit(ExpressionCollection part) {
        this.add(new ExpressionCollection(part.getName(), part.getClassType(), part.getGenericType(), part.getParametricType()));
        this.moveNext(part);
    }

    public void visit(ExpressionCollectionIndex part) {
        ExpressionCollectionIndex method = new ExpressionCollectionIndex(part.getName(), part.getClassType(), part.getGenericType(), part.getParametricType());
        this.copyMethodParams(part, method);
        this.add(method);
        this.moveNext(part);
    }

    public void visit(ExpressionText part) {
        this.add(new ExpressionText(part.getName(), part.getClassType(), part.getGenericType()));
        this.moveNext(part);
    }

    public void visit(ExpressionGlobalVariable part) {
        this.add(new ExpressionGlobalVariable(part.getName(), part.getClassType(), part.getGenericType(), part.getParametricType()));
        this.moveNext(part);
    }

    private void copyMethodParams(ExpressionMethod part, ExpressionMethod method) {
        HashMap<String, ExpressionFormLine> params = new HashMap<String, ExpressionFormLine>();
        for (Map.Entry<String, ExpressionFormLine> entry : part.getParams().entrySet()) {
            params.put(entry.getKey(), new ExpressionFormLine(entry.getValue()));
        }
        method.setParams(params);
    }

    private void moveNext(ExpressionPart ep) {
        if (ep.getNext() != null) {
            ep.getNext().accept(this);
        }
    }

    private void add(ExpressionPart p) {
        if (this.root == null) {
            this.root = p;
            this.curr = p;
        } else {
            this.curr.setNext(p);
            this.curr = p;
        }
    }
}

