/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

public class DRLConstraintValueBuilder {
    public static void buildLHSFieldValue(StringBuilder buf, int constraintType, String fieldType, String fieldValue) {
        if (fieldType == null || fieldType.length() == 0) {
            if (fieldValue == null) {
                return;
            }
            if (!fieldValue.startsWith("\"")) {
                buf.append("\"");
            }
            buf.append(fieldValue);
            if (!fieldValue.endsWith("\"")) {
                buf.append("\"");
            }
            return;
        }
        if (fieldType.equals("Boolean")) {
            buf.append(fieldValue);
        } else if (fieldType.equals("Date")) {
            buf.append("\"");
            buf.append(fieldValue);
            buf.append("\"");
        } else if (fieldType.equals("Numeric")) {
            buf.append(fieldValue);
        } else if (fieldType.equals("String")) {
            buf.append("\"");
            buf.append(fieldValue);
            buf.append("\"");
        } else if (fieldType.equals("Comparable")) {
            buf.append(fieldValue);
        } else {
            DRLConstraintValueBuilder.addQuote(constraintType, buf);
            buf.append(fieldValue);
            DRLConstraintValueBuilder.addQuote(constraintType, buf);
        }
    }

    public static void buildRHSFieldValue(StringBuilder buf, String fieldType, String fieldValue) {
        if (fieldType == null || fieldType.length() == 0) {
            if (fieldValue == null) {
                return;
            }
            if (!fieldValue.startsWith("\"")) {
                buf.append("\"");
            }
            buf.append(fieldValue);
            if (!fieldValue.endsWith("\"")) {
                buf.append("\"");
            }
            return;
        }
        if (fieldType.equals("Boolean")) {
            buf.append(fieldValue);
        } else if (fieldType.equals("Date")) {
            buf.append("sdf.parse(\"");
            buf.append(fieldValue);
            buf.append("\")");
        } else if (fieldType.equals("Numeric")) {
            buf.append(fieldValue);
        } else if (fieldType.equals("String")) {
            buf.append("\"");
            buf.append(fieldValue);
            buf.append("\"");
        } else if (fieldType.equals("Comparable")) {
            buf.append(fieldValue);
        } else {
            buf.append(fieldValue);
        }
    }

    private static void addQuote(int constraintType, StringBuilder buf) {
        if (constraintType == 1) {
            buf.append("\"");
        }
    }
}

