/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.ide.common.server.rules.ClassToGenericClassConverter;
import org.drools.ide.common.server.util.ClassMethodInspector;
import org.junit.Assert;
import org.junit.Test;

public class ClassMethodInspectorTest {
    @Test
    public void testSimpleMethods() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(SimpleMethods.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testMoreThanOneMethodWithTheSameName() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(MoreThanOneMethodWithTheSameName.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testCollection() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(Collection.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testArrayList() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(ArrayList.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testList() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(List.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testSet() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(Set.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testMap() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(Map.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    @Test
    public void testMyMap() throws Exception {
        ClassMethodInspector ext = new ClassMethodInspector(MyMap.class, (ClassToGenericClassConverter)new Converter());
        for (String s : ext.getMethodNames()) {
            Assert.assertFalse((String)("Method " + s + " is not allowed."), (boolean)this.allowedMethod(s));
        }
    }

    private boolean allowedMethod(String methodName) {
        return "hashCode".equals(methodName) || "equals".equals(methodName) || "listIterator".equals(methodName) || "lastIndexOf".equals(methodName) || "indexOf".equals(methodName) || "subList".equals(methodName) || "get".equals(methodName) || "isEmpty".equals(methodName) || "containsKey".equals(methodName) || "values".equals(methodName) || "entrySet".equals(methodName) || "containsValue".equals(methodName) || "keySet".equals(methodName) || "size".equals(methodName) || "toArray".equals(methodName) || "iterator".equals(methodName) || "contains".equals(methodName) || "isEmpty".equals(methodName) || "containsAll".equals(methodName) || "size".equals(methodName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Converter
    implements ClassToGenericClassConverter {
        private Converter() {
        }

        public String translateClassToGenericType(Class<?> type) {
            return null;
        }
    }

    public static class MyMap
    implements Map {
        public void magicMethod() {
        }

        public void clear() {
        }

        public boolean containsKey(Object arg0) {
            return false;
        }

        public boolean containsValue(Object arg0) {
            return false;
        }

        public Set entrySet() {
            return null;
        }

        public Object get(Object arg0) {
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public Set keySet() {
            return null;
        }

        public Object put(Object arg0, Object arg1) {
            return null;
        }

        public void putAll(Map arg0) {
        }

        public Object remove(Object arg0) {
            return null;
        }

        public int size() {
            return 0;
        }

        public Collection values() {
            return null;
        }
    }

    public static class MoreThanOneMethodWithTheSameName {
        public void justAMethod() {
        }

        public void justAMethod(int x) {
        }

        public void justAMethod(Object x) {
        }

        public void justAMethod(int x, Object y) {
        }

        public Object justAMethod(int x, int y) {
            return null;
        }
    }

    public static class SimpleMethods {
        public void cleanOrSimilar() {
        }

        public void addOrSimilar(int i) {
        }

        public boolean methodThatReturnsIfItWasSuccesful() {
            return true;
        }
    }
}

