/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.assistant;

import org.drools.ide.common.assistant.engine.DRLParserEngine;
import org.drools.ide.common.assistant.info.drl.DRLContentTypeEnum;
import org.drools.ide.common.assistant.info.drl.DRLRuleRefactorInfo;
import org.drools.ide.common.assistant.info.drl.RuleBasicContentInfo;
import org.drools.ide.common.assistant.info.drl.RuleLineContentInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DRLParserEngineTest {
    private String rule;
    private DRLParserEngine engine;
    private DRLRuleRefactorInfo info;

    @Before
    public void setUp() throws Exception {
        this.rule = "package org.drools.assistant.test;\n\n";
        this.rule = this.rule + "import org.drools.assistant.test.model.Company;\n";
        this.rule = this.rule + "import org.drools.assistant.test.model.Employee;\n\n";
        this.rule = this.rule + "import function org.drools.assistant.model.Class1.anotherFunction \n";
        this.rule = this.rule + "import        function org.drools.assistant.model.Class1.mathFunction \n";
        this.rule = this.rule + "global     org.drools.assistant.test.model.Class2    results \n";
        this.rule = this.rule + "global org.drools.assistant.test.model.Class3 current\n";
        this.rule = this.rule + "expander help-expander.dsl\n";
        this.rule = this.rule + "query \"all clients\"\n";
        this.rule = this.rule + "    result : Clients()\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "query \"new query\"\n";
        this.rule = this.rule + "    objects : Clients()\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "function String hello(String name) {\n";
        this.rule = this.rule + "    return \"Hello \"+name+\"!\";\n";
        this.rule = this.rule + "}\n";
        this.rule = this.rule + "function String helloWithAge(String name, Integer age) {\n";
        this.rule = this.rule + "    return \"Hello2 \"+name+\"! \" + age;\n";
        this.rule = this.rule + "}\n";
        this.rule = this.rule + "rule   \"My Test Rule\"\n";
        this.rule = this.rule + "when\n";
        this.rule = this.rule + "    $employee : Employee($company : company, $age : age > 80, salary > 400)\n";
        this.rule = this.rule + "    $result : Company(company == $company, retireAge <= $age)\n";
        this.rule = this.rule + "then\n";
        this.rule = this.rule + "    System.out.println(\"can retire\")\n";
        this.rule = this.rule + "end\n";
        this.engine = new DRLParserEngine(this.rule);
    }

    @Test
    public void testExecuteEngine() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(123);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
    }

    @Test
    public void testImport() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(9);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
    }

    @Test
    public void testNothingInteresting() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(199);
        Assert.assertEquals((Object)true, (Object)(content == null ? 1 : 0));
    }

    @Test
    public void testInsideTheRuleName() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(670);
        Assert.assertEquals((Object)true, (Object)(content == null ? 1 : 0));
    }

    @Test
    public void testInsideLHSRule() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(790);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
    }

    @Test
    public void testInsideRHSRule() {
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(830);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
    }

    @Test
    public void testSampleDRL() {
        this.rule = "package com.sample\n\n";
        this.rule = this.rule + "import com.sample.DroolsTest.Message;\n";
        this.rule = this.rule + "import com.sample.Prueba;\n\n";
        this.rule = this.rule + "\trule \"Hello World\"\n";
        this.rule = this.rule + "\twhen\n";
        this.rule = this.rule + "\t\tm : Message( status == Message.HELLO, myMessage : message )\n";
        this.rule = this.rule + "\t\tPrueba()\n";
        this.rule = this.rule + "\tthen\n";
        this.rule = this.rule + "\t\tSystem.out.println( myMessage );\n";
        this.rule = this.rule + "\t\tm.setMessage( \"Goodbye cruel world\" );\n";
        this.rule = this.rule + "\t\tm.setStatus( Message.GOODBYE );\n";
        this.rule = this.rule + "\t\tupdate( m );\n";
        this.rule = this.rule + "end\n";
        this.rule = this.rule + "rule \"GoodBye World\"\n";
        this.rule = this.rule + "\twhen\n";
        this.rule = this.rule + "\t\tm : Message( status == Message.GOODBYE, myMessage : message )\n";
        this.rule = this.rule + "\t\tPrueba()\n";
        this.rule = this.rule + "\tthen\n";
        this.rule = this.rule + "\t\tSystem.out.println( myMessage );\n";
        this.rule = this.rule + "\t\tm.setMessage( \"Bon Giorno\" );\n";
        this.rule = this.rule + "end";
        this.engine = new DRLParserEngine(this.rule);
        this.info = (DRLRuleRefactorInfo)this.engine.parse();
        RuleBasicContentInfo content = this.info.getContentAt(173);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
        Assert.assertEquals((Object)DRLContentTypeEnum.RULE_LHS_LINE, (Object)content.getType());
        Assert.assertEquals((Object)"rule \"Hello World\"", (Object)((RuleLineContentInfo)content).getRule().getRuleName());
        Assert.assertEquals((Object)"\t\tPrueba()", (Object)content.getContent());
        content = this.info.getContentAt(343);
        Assert.assertEquals((Object)true, (Object)(content != null ? 1 : 0));
        Assert.assertEquals((Object)DRLContentTypeEnum.RULE_LHS_LINE, (Object)content.getType());
        Assert.assertEquals((Object)"rule \"GoodBye World\"", (Object)((RuleLineContentInfo)content).getRule().getRuleName());
        Assert.assertEquals((Object)"\twhen", (Object)content.getContent());
    }
}

