/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.factconstraints.predefined;

import java.util.Collection;
import org.drools.builder.ResourceType;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.config.SimpleConstraintConfigurationImpl;
import org.drools.ide.common.server.factconstraints.predefined.InvalidFieldConstraint;
import org.drools.io.ResourceFactory;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierConfigurationImpl;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.VerifierBuilder;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvalidFieldConstraintTest {
    private ConstraintConfiguration conf;

    @Before
    public void setup() {
        this.conf = new SimpleConstraintConfigurationImpl();
        this.conf.setFactType("Person");
        this.conf.setFieldName("age");
    }

    @Test
    public void testUsingVerifier() {
        String ruleToVerify = "";
        int fail = 0;
        ruleToVerify = ruleToVerify + "package org.drools.factconstraint.test\n\n";
        ruleToVerify = ruleToVerify + "import org.drools.factconstraint.model.*\n";
        ruleToVerify = ruleToVerify + "global Number globalAge;\n";
        ruleToVerify = ruleToVerify + "rule \"rule1\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(age == 20)\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n\n";
        ++fail;
        ruleToVerify = ruleToVerify + "rule \"rule2\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(name == \"Peter\")\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n\n";
        ruleToVerify = ruleToVerify + "rule \"rule3\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(name == \"Peter\")\n";
        ruleToVerify = ruleToVerify + "       Person(age == 20)\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n";
        ++fail;
        ruleToVerify = ruleToVerify + "rule \"rule4\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Number() from collect(Person(age == 20))\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n";
        ++fail;
        ruleToVerify = ruleToVerify + "rule \"rule5\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person($age: age)\n";
        ruleToVerify = ruleToVerify + "       Person(age == $age)\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n";
        ++fail;
        ruleToVerify = ruleToVerify + "rule \"rule6\"\n";
        ruleToVerify = ruleToVerify + "   when\n";
        ruleToVerify = ruleToVerify + "       Person(age == globalAge)\n";
        ruleToVerify = ruleToVerify + "   then\n";
        ruleToVerify = ruleToVerify + "       System.out.println(\"Rule fired\");\n";
        ruleToVerify = ruleToVerify + "end\n";
        ++fail;
        VerifierBuilder vBuilder = VerifierBuilderFactory.newVerifierBuilder();
        VerifierConfigurationImpl vconf = new VerifierConfigurationImpl();
        InvalidFieldConstraint cons = new InvalidFieldConstraint();
        System.out.println("\n\n\n" + cons.getVerifierRule(this.conf) + "\n\n\n");
        vconf.getVerifyingResources().put(ResourceFactory.newByteArrayResource((byte[])cons.getVerifierRule(this.conf).getBytes()), ResourceType.DRL);
        Verifier verifier = vBuilder.newVerifier((VerifierConfiguration)vconf);
        verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])ruleToVerify.getBytes()), ResourceType.DRL);
        if (verifier.hasErrors()) {
            for (VerifierError error : verifier.getErrors()) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Error building verifier");
        }
        Assert.assertFalse((boolean)verifier.hasErrors());
        boolean noProblems = verifier.fireAnalysis();
        Assert.assertTrue((boolean)noProblems);
        VerifierReport result = verifier.getResult();
        Collection warnings = result.getBySeverity(Severity.ERROR);
        int counter = 0;
        for (VerifierMessageBase message : warnings) {
            System.out.println(message);
            ++counter;
        }
        Assert.assertEquals((long)fail, (long)counter);
        verifier.dispose();
    }
}

