/*
 * Copyright 2012 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.drools.ide.common.client.modeldriven.dt52.auditlog;

import org.drools.ide.common.client.modeldriven.auditlog.AuditLogEntry;
import org.drools.ide.common.client.modeldriven.dt52.auditlog.DecisionTableAuditLogFilter.DecisionTableAuditEvents;

/**
 * An Audit Event when a row is deleted
 */
public class DeleteRowAuditLogEntry extends AuditLogEntry {

    private static final long   serialVersionUID = 8049692773593046770L;

    private static final String TYPE             = DecisionTableAuditEvents.DELETE_ROW.name();

    public int                  rowIndex;

    public DeleteRowAuditLogEntry() {
    }

    public DeleteRowAuditLogEntry(final String userName) {
        super( userName );
    }

    public DeleteRowAuditLogEntry(final String userName,
                                  final int rowIndex) {
        super( userName );
        this.rowIndex = rowIndex;
    }

    @Override
    public String getGenericType() {
        return TYPE;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

}
