/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.populators;

import org.drools.base.TypeResolver;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.FactAssignmentField;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.server.testscenarios.Cheese;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulator;
import org.drools.ide.common.server.testscenarios.populators.FieldPopulatorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FieldPopulatorFactoryTest {
    private FieldPopulatorFactory fieldPopulatorFactory;
    private TypeResolver typeResolver;
    private ClassLoader classLoader;

    @Before
    public void setUp() throws Exception {
        Object factObject = Mockito.mock(Object.class);
        this.typeResolver = (TypeResolver)Mockito.mock(TypeResolver.class);
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.fieldPopulatorFactory = new FieldPopulatorFactory(factObject, this.typeResolver, this.classLoader);
    }

    @Test
    public void testFactAssignmentField() throws Exception {
        FactAssignmentField field = new FactAssignmentField();
        field.setFact(new Fact());
        Mockito.when((Object)this.typeResolver.resolveType((String)Matchers.any())).thenReturn(Cheese.class);
        FieldPopulator fieldPopulator = this.fieldPopulatorFactory.getFieldPopulator((Field)field);
        Assert.assertNotNull((Object)fieldPopulator);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownFieldType() throws Exception {
        this.fieldPopulatorFactory.getFieldPopulator((Field)new WhoAmIField());
    }

    class WhoAmIField
    implements Field {
        WhoAmIField() {
        }

        public String getName() {
            return "?";
        }
    }
}

