/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionExecuteWorkItem;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.ActionWorkItemFieldValue;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionUnboundFact;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.shared.workitems.PortableBooleanParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableFloatParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableIntegerParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableStringParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableWorkDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BRDRLPersistenceTest {
    private BRLPersistence brlPersistence;

    @Before
    public void setUp() throws Exception {
        this.brlPersistence = BRDRLPersistence.getInstance();
    }

    @Test
    public void testGenerateEmptyDRL() {
        String expected = "rule \"null\"\n\tdialect \"mvel\"\n\twhen\n\tthen\nend\n";
        String drl = this.brlPersistence.marshal(new RuleModel());
        Assert.assertNotNull((Object)drl);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFreeForm() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        m.lhs = new IPattern[1];
        m.rhs = new IAction[1];
        FreeFormLine fl = new FreeFormLine();
        fl.text = "Person()";
        m.lhs[0] = fl;
        FreeFormLine fr = new FreeFormLine();
        fr.text = "fun()";
        m.rhs[0] = fr;
        String drl = this.brlPersistence.marshal(m);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("Person()") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("fun()") > drl.indexOf("Person()") ? 1 : 0) != 0);
    }

    @Test
    public void testBasics() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testInsertLogical() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsertLogical( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertLogicalFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testAttr() {
        RuleModel m = new RuleModel();
        m.attributes = new RuleAttribute[1];
        m.attributes[0] = new RuleAttribute("enabled", "true");
        String drl = this.brlPersistence.marshal(m);
        Assert.assertTrue((drl.indexOf("enabled true") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnumNoType() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CheeseType.CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CheeseType.CHEDDAR");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeString() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == \"CHEDDAR\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("CHEDDAR");
        con.setFieldType("String");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeStringInOperator() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type in ( \"CHEDDAR\", \"STILTON\" ) )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("in");
        con.setValue("( \"CHEDDAR\",\"STILTON\" )");
        con.setFieldType("String");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeNumeric() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( age == 100 )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("==");
        con.setValue("100");
        con.setFieldType("Integer");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeBoolean() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( smelly == true )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("smelly");
        con.setOperator("==");
        con.setValue("true");
        con.setFieldType("Boolean");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeDate() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( dateMade == \"31-Jan-2010\" )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("dateMade");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setFieldType("Date");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testEnumTypeComparable() {
        String expected = "rule \"my rule\"\n\tdialect \"mvel\"\n\twhen\n\t\tCheese( type == Cheese.CHEDDAR )\n\tthen\n\t\tinsert( new Report() );\nend\n";
        RuleModel m = new RuleModel();
        FactPattern pat = new FactPattern("Cheese");
        m.addLhsItem((IPattern)pat);
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("type");
        con.setOperator("==");
        con.setValue("Cheese.CHEDDAR");
        con.setFieldType("Comparable");
        con.setConstraintValueType(4);
        pat.addConstraint((FieldConstraint)con);
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testMoreComplexRendering() {
        RuleModel m = this.getComplexModel();
        String expected = "rule \"Complex Rule\"\n\tno-loop true\n\tsalience -10\n\tagenda-group \"aGroup\"\n\tdialect \"mvel\"\n\twhen\n\t\t>p1 : Person( f1 : age < 42 )\n\t\t>not (Cancel( )) \n\tthen\n\t\t>p1.setStatus( \"rejected\" );\n\t\t>update( p1 );\n\t\t>retract( p1 );\n\t\tSend an email to administrator\nend\n";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testFieldBindingWithNoConstraints() {
        RuleModel m = this.getModelWithNoConstraints();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( f1 : age)") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void textIsNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("== null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age == null )") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void textIsNotNullOperator() {
        RuleModel m = new RuleModel();
        m.name = "IsNotNullOperator";
        FactPattern pat = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("age");
        con.setOperator("!= null");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("Person( age != null )") != -1 ? 1 : 0) != 0);
    }

    private RuleModel getModelWithNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        return m;
    }

    private RuleModel getComplexModel() {
        RuleModel m = new RuleModel();
        m.name = "Complex Rule";
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addAttribute(new RuleAttribute("salience", "-10"));
        m.addAttribute(new RuleAttribute("agenda-group", "aGroup"));
        FactPattern pat = new FactPattern("Person");
        pat.setBoundName("p1");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldBinding("f1");
        con.setFieldName("age");
        con.setOperator("<");
        con.setValue("42");
        pat.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)pat);
        CompositeFactPattern comp = new CompositeFactPattern("not");
        comp.addFactPattern((IFactPattern)new FactPattern("Cancel"));
        m.addLhsItem((IPattern)comp);
        ActionUpdateField set = new ActionUpdateField();
        set.variable = "p1";
        set.addFieldValue(new ActionFieldValue("status", "rejected", "String"));
        m.addRhsItem((IAction)set);
        ActionRetractFact ret = new ActionRetractFact("p1");
        m.addRhsItem((IAction)ret);
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("Send an email to {administrator}");
        m.addRhsItem((IAction)sen);
        return m;
    }

    @Test
    public void testOrComposite() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("or");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("( Person( age == 42 ) or Person( age == 43 ) )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExistsMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("exists");
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNotMultiPatterns() throws Exception {
        String result = this.getCompositeFOL("not");
        Assert.assertTrue((result.indexOf("not (Person( age == 42 ) and Person( age == 43 ))") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSingleExists() throws Exception {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern("exists");
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("exists (Person( age == 42 )) ") > 0 ? 1 : 0) != 0);
    }

    private String getCompositeFOL(String type) {
        RuleModel m = new RuleModel();
        m.name = "or";
        CompositeFactPattern cp = new CompositeFactPattern(type);
        FactPattern p1 = new FactPattern("Person");
        SingleFieldConstraint sf1 = new SingleFieldConstraint("age");
        sf1.setOperator("==");
        sf1.setValue("42");
        p1.addConstraint((FieldConstraint)sf1);
        cp.addFactPattern((IFactPattern)p1);
        FactPattern p2 = new FactPattern("Person");
        SingleFieldConstraint sf2 = new SingleFieldConstraint("age");
        sf2.setOperator("==");
        sf2.setValue("43");
        p2.addConstraint((FieldConstraint)sf2);
        cp.addFactPattern((IFactPattern)p2);
        m.addLhsItem((IPattern)cp);
        String result = BRDRLPersistence.getInstance().marshal(m);
        return result;
    }

    @Test
    public void testCompositeConstraints() {
        RuleModel m = new RuleModel();
        m.name = "with composite";
        FactPattern p1 = new FactPattern("Person");
        p1.setBoundName("p1");
        m.addLhsItem((IPattern)p1);
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint X = new SingleFieldConstraint();
        X.setFieldName("goo");
        X.setFieldType("String");
        X.setConstraintValueType(1);
        X.setValue("foo");
        X.setOperator("==");
        X.connectives = new ConnectiveConstraint[1];
        X.connectives[0] = new ConnectiveConstraint();
        X.connectives[0].setConstraintValueType(1);
        X.connectives[0].setFieldType("String");
        X.connectives[0].setOperator("|| ==");
        X.connectives[0].setValue("bar");
        comp.addConstraint((FieldConstraint)X);
        SingleFieldConstraint Y = new SingleFieldConstraint();
        Y.setFieldName("goo2");
        Y.setFieldType("String");
        Y.setConstraintValueType(1);
        Y.setValue("foo");
        Y.setOperator("==");
        comp.addConstraint((FieldConstraint)Y);
        CompositeFieldConstraint comp2 = new CompositeFieldConstraint();
        comp2.compositeJunctionType = "&&";
        SingleFieldConstraint Q1 = new SingleFieldConstraint();
        Q1.setFieldType("String");
        Q1.setFieldName("goo");
        Q1.setOperator("==");
        Q1.setValue("whee");
        Q1.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q1);
        SingleFieldConstraint Q2 = new SingleFieldConstraint();
        Q2.setFieldType("String");
        Q2.setFieldName("gabba");
        Q2.setOperator("==");
        Q2.setValue("whee");
        Q2.setConstraintValueType(1);
        comp2.addConstraint((FieldConstraint)Q2);
        comp.addConstraint((FieldConstraint)comp2);
        SingleFieldConstraint Z = new SingleFieldConstraint();
        Z.setFieldName("goo3");
        Z.setConstraintValueType(1);
        Z.setFieldType("String");
        Z.setValue("foo");
        Z.setOperator("==");
        p.addConstraint((FieldConstraint)Z);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"with composite\"  \tdialect \"mvel\"\n when p1 : Person( ) Goober( goo == \"foo\"  || == \"bar\" || goo2 == \"foo\" || ( goo == \"whee\" && gabba == \"whee\" ), goo3 == \"foo\" ) then insert( new Whee() );end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testFieldsDeclaredButNoConstraints() {
        RuleModel m = new RuleModel();
        m.name = "boo";
        FactPattern p = new FactPattern("Person");
        p.addConstraint((FieldConstraint)new SingleFieldConstraint("field1"));
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"boo\" \tdialect \"mvel\"\n when Person() then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
        SingleFieldConstraint con = (SingleFieldConstraint)p.constraintList.constraints[0];
        con.setFieldBinding("q");
        actual = BRDRLPersistence.getInstance().marshal(m);
        expected = "rule \"boo\" dialect \"mvel\" when Person(q : field1) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testLiteralStrings() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal strings\"\tdialect \"mvel\"\n when      Person(field1 == \"goo\", field2 == variableHere) then end", result);
    }

    @Test
    public void testLHSExpressionString1() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString1";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionText("field1"));
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsString1\"\tdialect \"mvel\"\n when      Person( field1 == \"goo\" ) then end", result);
    }

    @Test
    public void testLHSExpressionString2() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsString2";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsString2\"\tdialect \"mvel\"\n when      Person( field1 == \"Cheddar\" ) then end", result);
    }

    @Test
    public void testLHSExpressionJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsJavaEnum\"\tdialect \"mvel\"\n when      Person( field1 == CHEESE.Cheddar ) then end", result);
    }

    @Test
    public void testLHSExpressionNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Integer", "Integer"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNumber\"\tdialect \"mvel\"\n when      Person( field1 == 55 ) then end", result);
    }

    @Test
    public void testLHSExpressionDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsDate\"\tdialect \"mvel\"\n when      Person( field1 == \"27-Jun-2011\" ) then end", result);
    }

    @Test
    public void testLHSExpressionBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("field1", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsBoolean\"\tdialect \"mvel\"\n when      Person( field1 == true ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedString() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedString";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("name", "java.lang.String", "String"));
        con.setOperator("==");
        con.setValue("Cheedar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedString\"\tdialect \"mvel\"\n when      Person( favouriteCheese.name == \"Cheedar\" ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedNumber() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedNumber";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("age", "java.lang.Integer", "Integer"));
        con.setOperator("==");
        con.setValue("55");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedNumber\"\tdialect \"mvel\"\n when      Person( favouriteCheese.age == 55 ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedDate() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedDate";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("dateBrought", "java.util.Date", "Date"));
        con.setOperator("==");
        con.setValue("27-Jun-2011");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedDate\"\tdialect \"mvel\"\n when      Person( favouriteCheese.dateBrought == \"27-Jun-2011\" ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedJavaEnum() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedJavaEnum";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("genericName", "CHEESE", "Comparable"));
        con.setOperator("==");
        con.setValue("CHEESE.Cheddar");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedJavaEnum\"\tdialect \"mvel\"\n when      Person( favouriteCheese.genericName == CHEESE.Cheddar ) then end", result);
    }

    @Test
    public void testLHSExpressionNestedBoolean() {
        RuleModel m = new RuleModel();
        m.name = "test expressionsNestedBoolean";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraintEBLeftSide con = new SingleFieldConstraintEBLeftSide();
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionUnboundFact(p));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("favouriteCheese", "Cheese", "Object"));
        con.getExpressionLeftSide().appendPart((ExpressionPart)new ExpressionField("smelly", "java.lang.Boolean", "Boolean"));
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test expressionsNestedBoolean\"\tdialect \"mvel\"\n when      Person( favouriteCheese.smelly == true ) then end", result);
    }

    @Test
    public void testLiteralNumerics() {
        RuleModel m = new RuleModel();
        m.name = "test literal numerics";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal numerics\"\tdialect \"mvel\"\n when      Person(field1 == 44, field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralBigDecimalMvel() {
        RuleModel m = new RuleModel();
        m.name = "test literal bigdecimal";
        m.addAttribute(new RuleAttribute("dialect", "mvel"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigDecimal");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigDecimal"));
        m.addRhsItem((IAction)ai);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal bigdecimal\" \n\tdialect \"mvel\"\n when \n     Person(field1 == 44B) \n then \nPerson fact0 = new Person(); \nfact0.setField1( 55B ); \ninsert( fact0 ); \nend", result);
    }

    @Test
    public void testLiteralBigIntegerMvel() {
        RuleModel m = new RuleModel();
        m.name = "test literal biginteger";
        m.addAttribute(new RuleAttribute("dialect", "mvel"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigInteger");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigInteger"));
        m.addRhsItem((IAction)ai);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal biginteger\" \n\tdialect \"mvel\"\n when \n     Person(field1 == 44I ) \n then \nPerson fact0 = new Person(); \nfact0.setField1( 55I ); \ninsert( fact0 ); \nend", result);
    }

    @Test
    public void testLiteralBigDecimalJava() {
        RuleModel m = new RuleModel();
        m.name = "test literal bigdecimal";
        m.addAttribute(new RuleAttribute("dialect", "java"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigDecimal");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigDecimal"));
        m.addRhsItem((IAction)ai);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal bigdecimal\" \n\tdialect \"java\"\n when \n     Person(field1 == 44B) \n then \nPerson fact0 = new Person(); \nfact0.setField1( new java.math.BigDecimal( \"55\" ) ); \ninsert( fact0 ); \nend", result);
    }

    @Test
    public void testLiteralBigIntegerJava() {
        RuleModel m = new RuleModel();
        m.name = "test literal biginteger";
        m.addAttribute(new RuleAttribute("dialect", "java"));
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("BigInteger");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("44");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionInsertFact ai = new ActionInsertFact("Person");
        ai.addFieldValue(new ActionFieldValue("field1", "55", "BigInteger"));
        m.addRhsItem((IAction)ai);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal biginteger\" \n\tdialect \"java\"\n when \n     Person(field1 == 44I ) \n then \nPerson fact0 = new Person(); \nfact0.setField1( new java.math.BigInteger( \"55\" ) ); \ninsert( fact0 ); \nend", result);
    }

    @Test
    public void testLiteralBooleans() {
        RuleModel m = new RuleModel();
        m.name = "test literal booleans";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Boolean");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("true");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal booleans\"\tdialect \"mvel\"\n when      Person(field1 == true, field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralDates() {
        RuleModel m = new RuleModel();
        m.name = "test literal dates";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Date");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("31-Jan-2010");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal dates\"\tdialect \"mvel\"\n when      Person(field1 == \"31-Jan-2010\", field2 == variableHere) then end", result);
    }

    @Test
    public void testLiteralNoType() {
        RuleModel m = new RuleModel();
        m.name = "test literal no type";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("bananna");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test literal no type\"\tdialect \"mvel\"\n when      Person(field1 == \"bananna\", field2 == variableHere) then end", result);
    }

    @Test
    public void testInOperatorString() {
        RuleModel m = new RuleModel();
        m.name = "in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("in");
        con.setValue("value1, value2");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"in\" \ndialect \"mvel\" \nwhen \n     Person(field1 in ( \"value1\", \"value2\" ) ) \n then \nend", result);
    }

    @Test
    public void testInOperatorNumber() {
        RuleModel m = new RuleModel();
        m.name = "in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("in");
        con.setValue("55, 66");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"in\" \ndialect \"mvel\" \nwhen \n     Person(field1 in ( 55, 66 ) ) \n then \nend", result);
    }

    @Test
    public void testNotInOperatorString() {
        RuleModel m = new RuleModel();
        m.name = "not in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("not in");
        con.setValue("value1, value2");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"not in\" \ndialect \"mvel\" \nwhen \n     Person(field1 not in ( \"value1\", \"value2\" ) ) \n then \nend", result);
    }

    @Test
    public void testNotInOperatorNumber() {
        RuleModel m = new RuleModel();
        m.name = "not in";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("Integer");
        con.setFieldName("field1");
        con.setOperator("not in");
        con.setValue("55, 66");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"not in\" \ndialect \"mvel\" \nwhen \n     Person(field1 not in ( 55, 66 ) ) \n then \nend", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateInsertAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionInsertFact ai = new ActionInsertFact("Birthday");
            ai.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)ai);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("fact0.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateModifyAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionUpdateField am = new ActionUpdateField("$p");
            am.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)am);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("update( $p );") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSDateUpdateAction() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS Date";
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            SingleFieldConstraint con = new SingleFieldConstraint();
            con.setFieldType("Date");
            con.setFieldName("dateOfBirth");
            con.setOperator("==");
            con.setValue("31-Jan-2000");
            con.setConstraintValueType(1);
            p.addConstraint((FieldConstraint)con);
            m.addLhsItem((IPattern)p);
            ActionSetField au = new ActionSetField("$p");
            au.addFieldValue(new ActionFieldValue("dob", "31-Jan-2000", "Date"));
            m.addRhsItem((IAction)au);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.setDob( sdf.parse(\"31-Jan-2000\"") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("update( $p );") == -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testRHSExecuteWorkItem1() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern p = new FactPattern("Person");
        p.setBoundName("$p");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("name");
        con.setOperator("==");
        con.setValue("Michael");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", Boolean.TRUE );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", 123.456f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", 123 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", \"hello\" );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSExecuteWorkItem2() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern p = new FactPattern("Person");
        p.setBoundName("$p");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("name");
        con.setOperator("==");
        con.setValue("Michael");
        con.setConstraintValueType(1);
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        p1.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        p2.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        p3.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        p4.setBinding("");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", Boolean.TRUE );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", 123.456f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", 123 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", \"hello\" );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSExecuteWorkItemWithBindings() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        FactPattern fp2 = new FactPattern("Boolean");
        fp2.setBoundName("$b");
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldType("Boolean");
        con2.setFieldName("this");
        con2.setOperator("==");
        con2.setValue("true");
        con2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)fp2);
        FactPattern fp3 = new FactPattern("Float");
        fp3.setBoundName("$f");
        SingleFieldConstraint con3 = new SingleFieldConstraint();
        con3.setFieldType("Float");
        con3.setFieldName("this");
        con3.setOperator("==");
        con3.setValue("123.456f");
        con3.setConstraintValueType(1);
        fp3.addConstraint((FieldConstraint)con3);
        m.addLhsItem((IPattern)fp3);
        FactPattern fp4 = new FactPattern("Integer");
        fp4.setBoundName("$i");
        SingleFieldConstraint con4 = new SingleFieldConstraint();
        con4.setFieldType("Integer");
        con4.setFieldName("this");
        con4.setOperator("==");
        con4.setValue("123");
        con4.setConstraintValueType(1);
        fp4.addConstraint((FieldConstraint)con4);
        m.addLhsItem((IPattern)fp4);
        FactPattern fp5 = new FactPattern("String");
        fp5.setBoundName("$s");
        SingleFieldConstraint con5 = new SingleFieldConstraint();
        con5.setFieldType("String");
        con5.setFieldName("this");
        con5.setOperator("==");
        con5.setValue("hello");
        con5.setConstraintValueType(1);
        fp5.addConstraint((FieldConstraint)con5);
        m.addLhsItem((IPattern)fp5);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSExecuteWorkItemWithMissingBindings1() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        FactPattern fp2 = new FactPattern("Boolean");
        fp2.setBoundName("$b1");
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldType("Boolean");
        con2.setFieldName("this");
        con2.setOperator("==");
        con2.setValue("true");
        con2.setConstraintValueType(1);
        fp2.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)fp2);
        FactPattern fp3 = new FactPattern("Float");
        fp3.setBoundName("$f1");
        SingleFieldConstraint con3 = new SingleFieldConstraint();
        con3.setFieldType("Float");
        con3.setFieldName("this");
        con3.setOperator("==");
        con3.setValue("123.456f");
        con3.setConstraintValueType(1);
        fp3.addConstraint((FieldConstraint)con3);
        m.addLhsItem((IPattern)fp3);
        FactPattern fp4 = new FactPattern("Integer");
        fp4.setBoundName("$i1");
        SingleFieldConstraint con4 = new SingleFieldConstraint();
        con4.setFieldType("Integer");
        con4.setFieldName("this");
        con4.setOperator("==");
        con4.setValue("123");
        con4.setConstraintValueType(1);
        fp4.addConstraint((FieldConstraint)con4);
        m.addLhsItem((IPattern)fp4);
        FactPattern fp5 = new FactPattern("String");
        fp5.setBoundName("$s1");
        SingleFieldConstraint con5 = new SingleFieldConstraint();
        con5.setFieldType("String");
        con5.setFieldName("this");
        con5.setOperator("==");
        con5.setValue("hello");
        con5.setConstraintValueType(1);
        fp5.addConstraint((FieldConstraint)con5);
        m.addLhsItem((IPattern)fp5);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s1 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i2 );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s2 );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSExecuteWorkItemWithMissingBindings2() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Person");
        fp1.setBoundName("$p");
        SingleFieldConstraint con1 = new SingleFieldConstraint();
        con1.setFieldType("String");
        con1.setFieldName("name");
        con1.setOperator("==");
        con1.setValue("Michael");
        con1.setConstraintValueType(1);
        fp1.addConstraint((FieldConstraint)con1);
        m.addLhsItem((IPattern)fp1);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setBinding("$b2");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setBinding("$f2");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setBinding("$i2");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setBinding("$s2");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"BooleanParameter\", $b );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"FloatParameter\", $f );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"IntegerParameter\", $i );") != -1 ? 1 : 0) != 0);
        Assert.assertFalse((result.indexOf("wiWorkItem.getParameters().put( \"StringParameter\", $s );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSActionWorkItemSetFields() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        FactPattern fp1 = new FactPattern("Results");
        fp1.setBoundName("$r");
        m.addLhsItem((IPattern)fp1);
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        ActionSetField asf = new ActionSetField();
        asf.variable = "$r";
        ActionWorkItemFieldValue fv1 = new ActionWorkItemFieldValue("ResultsBooleanResult", "Boolean", "WorkItem", "BooleanResult", Boolean.class.getName());
        asf.addFieldValue((ActionFieldValue)fv1);
        ActionWorkItemFieldValue fv2 = new ActionWorkItemFieldValue("ResultsFloatResult", "Float", "WorkItem", "FloatResult", Float.class.getName());
        asf.addFieldValue((ActionFieldValue)fv2);
        ActionWorkItemFieldValue fv3 = new ActionWorkItemFieldValue("ResultsIntegerResult", "Integer", "WorkItem", "IntegerResult", Integer.class.getName());
        asf.addFieldValue((ActionFieldValue)fv3);
        ActionWorkItemFieldValue fv4 = new ActionWorkItemFieldValue("ResultsStringResult", "String", "WorkItem", "StringResult", String.class.getName());
        asf.addFieldValue((ActionFieldValue)fv4);
        m.addRhsItem((IAction)asf);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsBooleanResult( (java.lang.Boolean) wiWorkItem.getResult( \"BooleanResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsFloatResult( (java.lang.Float) wiWorkItem.getResult( \"FloatResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsIntegerResult( (java.lang.Integer) wiWorkItem.getResult( \"IntegerResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsStringResult( (java.lang.String) wiWorkItem.getResult( \"StringResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("wim.internalExecuteWorkItem( wiWorkItem );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSActionWorkItemInsertFacts() {
        RuleModel m = new RuleModel();
        m.name = "WorkItem";
        ActionExecuteWorkItem awi = new ActionExecuteWorkItem();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        m.addRhsItem((IAction)awi);
        ActionInsertFact aif = new ActionInsertFact();
        aif.setBoundName("$r");
        aif.factType = "Results";
        ActionWorkItemFieldValue fv1 = new ActionWorkItemFieldValue("ResultsBooleanResult", "Boolean", "WorkItem", "BooleanResult", Boolean.class.getName());
        aif.addFieldValue((ActionFieldValue)fv1);
        ActionWorkItemFieldValue fv2 = new ActionWorkItemFieldValue("ResultsFloatResult", "Float", "WorkItem", "FloatResult", Float.class.getName());
        aif.addFieldValue((ActionFieldValue)fv2);
        ActionWorkItemFieldValue fv3 = new ActionWorkItemFieldValue("ResultsIntegerResult", "Integer", "WorkItem", "IntegerResult", Integer.class.getName());
        aif.addFieldValue((ActionFieldValue)fv3);
        ActionWorkItemFieldValue fv4 = new ActionWorkItemFieldValue("ResultsStringResult", "String", "WorkItem", "StringResult", String.class.getName());
        aif.addFieldValue((ActionFieldValue)fv4);
        m.addRhsItem((IAction)aif);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("org.drools.process.instance.impl.WorkItemImpl wiWorkItem = new org.drools.process.instance.impl.WorkItemImpl();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("Results $r = new Results();") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsBooleanResult( (java.lang.Boolean) wiWorkItem.getResult( \"BooleanResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsFloatResult( (java.lang.Float) wiWorkItem.getResult( \"FloatResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsIntegerResult( (java.lang.Integer) wiWorkItem.getResult( \"IntegerResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("$r.setResultsStringResult( (java.lang.String) wiWorkItem.getResult( \"StringResult\" ) );") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf("insert( $r );") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSubConstraints() {
        RuleModel m = new RuleModel();
        m.name = "test sub constraints";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldName("field1");
        p.addConstraint((FieldConstraint)con);
        SingleFieldConstraint con2 = new SingleFieldConstraint();
        con2.setFieldName("field2");
        con2.setOperator("==");
        con2.setValue("variableHere");
        con2.setConstraintValueType(2);
        con2.setParent((FieldConstraint)con);
        p.addConstraint((FieldConstraint)con2);
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        this.assertEqualsIgnoreWhitespace("rule \"test sub constraints\"\tdialect \"mvel\"\n when      Person(field1.field2 == variableHere) then end", result);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    @Test
    public void testReturnValueConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(3);
        con.setValue("someFunc(x)");
        con.setOperator("==");
        con.setFieldName("goo");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( goo == ( someFunc(x) ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testPredicateConstraint() {
        RuleModel m = new RuleModel();
        m.name = "yeah";
        FactPattern p = new FactPattern("Goober");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setConstraintValueType(5);
        con.setValue("field soundslike 'poo'");
        p.addConstraint((FieldConstraint)con);
        m.addLhsItem((IPattern)p);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"yeah\" \tdialect \"mvel\"\n when Goober( eval( field soundslike 'poo' ) ) then end";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testConnective() {
        RuleModel m = new RuleModel();
        m.name = "test literal strings";
        FactPattern p = new FactPattern("Person");
        SingleFieldConstraint con = new SingleFieldConstraint();
        con.setFieldType("String");
        con.setFieldName("field1");
        con.setOperator("==");
        con.setValue("goo");
        con.setConstraintValueType(2);
        p.addConstraint((FieldConstraint)con);
        ConnectiveConstraint connective = new ConnectiveConstraint();
        connective.setConstraintValueType(1);
        connective.setFieldType("String");
        connective.setOperator("|| ==");
        connective.setValue("blah");
        con.connectives = new ConnectiveConstraint[1];
        con.connectives[0] = connective;
        m.addLhsItem((IPattern)p);
        String result = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"test literal strings\" \tdialect \"mvel\"\n when Person( field1 == goo  || == \"blah\" ) then end";
        this.assertEqualsIgnoreWhitespace(expected, result);
    }

    @Test
    public void testInvalidComposite() throws Exception {
        RuleModel m = new RuleModel();
        CompositeFactPattern com = new CompositeFactPattern("not");
        m.addLhsItem((IPattern)com);
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
        m.addLhsItem((IPattern)new CompositeFactPattern("or"));
        m.addLhsItem((IPattern)new CompositeFactPattern("exists"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testAssertWithDSL() throws Exception {
        RuleModel m = new RuleModel();
        DSLSentence sen = new DSLSentence();
        sen.setDefinition("I CAN HAS DSL");
        m.addRhsItem((IAction)sen);
        ActionInsertFact ins = new ActionInsertFact("Shizzle");
        ActionFieldValue val = new ActionFieldValue("goo", "42", "Numeric");
        ins.fieldValues = new ActionFieldValue[1];
        ins.fieldValues[0] = val;
        m.addRhsItem((IAction)ins);
        ActionInsertLogicalFact insL = new ActionInsertLogicalFact("Shizzle");
        ActionFieldValue valL = new ActionFieldValue("goo", "42", "Numeric");
        insL.fieldValues = new ActionFieldValue[1];
        insL.fieldValues[0] = valL;
        m.addRhsItem((IAction)insL);
        String result = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((result.indexOf(">insert") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((result.indexOf(">insertLogical") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultMVEL() {
        RuleModel m = new RuleModel();
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        m.addAttribute(new RuleAttribute("dialect", "goober"));
        s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertFalse((s.indexOf("mvel") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("goober") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLockOnActive() {
        RuleModel m = new RuleModel();
        m.addAttribute(new RuleAttribute("lock-on-active", "true"));
        m.addAttribute(new RuleAttribute("auto-focus", "true"));
        m.addAttribute(new RuleAttribute("duration", "42"));
        String s = BRDRLPersistence.getInstance().marshal(m);
        Assert.assertTrue((s.indexOf("lock-on-active true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("auto-focus true") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((s.indexOf("duration 42") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddGlobal() {
        String expected = "rule \"my rule\"\n\tno-loop true\n\tdialect \"mvel\"\n\twhen\n\t\tPerson( )\n\t\tAccident( )\n\tthen\n\t\tinsert( new Report() );\n\t\tresults.add(f);\nend\n";
        RuleModel m = new RuleModel();
        m.addLhsItem((IPattern)new FactPattern("Person"));
        m.addLhsItem((IPattern)new FactPattern("Accident"));
        m.addAttribute(new RuleAttribute("no-loop", "true"));
        m.addRhsItem((IAction)new ActionInsertFact("Report"));
        ActionGlobalCollectionAdd add = new ActionGlobalCollectionAdd();
        add.globalName = "results";
        add.factName = "f";
        m.addRhsItem((IAction)add);
        m.name = "my rule";
        String drl = this.brlPersistence.marshal(m);
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testCompositeOrConstraints() {
        RuleModel m = new RuleModel();
        m.name = "or composite";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"or composite\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" || fooField != null || fooField.barField == \"barValue\" )\nthen\ninsert( new Whee() );\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testCompositeOrConstraintsComplex() {
        RuleModel m = new RuleModel();
        m.name = "or composite complex";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "||";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint();
        sfc4.setFactType("Goober");
        sfc4.setFieldName("zooField");
        sfc4.setFieldType("String");
        sfc4.setConstraintValueType(1);
        sfc4.setValue("zooValue");
        sfc4.setOperator("==");
        p.addConstraint((FieldConstraint)sfc4);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"or composite complex\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" || fooField != null || fooField.barField == \"barValue\", zooField == \"zooValue\" )\nthen\ninsert( new Whee() );\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testCompositeAndConstraints() {
        RuleModel m = new RuleModel();
        m.name = "and composite";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "&&";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc3.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"and composite\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" && fooField != null && fooField.barField == \"barValue\" )\nthen\ninsert( new Whee() );\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testCompositeAndConstraintsComplex() {
        RuleModel m = new RuleModel();
        m.name = "and composite complex";
        FactPattern p = new FactPattern("Goober");
        m.addLhsItem((IPattern)p);
        CompositeFieldConstraint comp = new CompositeFieldConstraint();
        comp.compositeJunctionType = "&&";
        p.addConstraint((FieldConstraint)comp);
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFactType("Goober");
        sfc1.setFieldName("gooField");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(1);
        sfc1.setValue("gooValue");
        sfc1.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc1);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFactType("Goober");
        sfc2.setFieldName("fooField");
        sfc2.setFieldType("Object");
        sfc2.setConstraintValueType(1);
        sfc2.setOperator("!= null");
        comp.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint();
        sfc1.setFactType("Bar");
        sfc3.setFieldName("barField");
        sfc3.setParent((FieldConstraint)sfc2);
        sfc3.setFieldType("String");
        sfc3.setConstraintValueType(1);
        sfc3.setValue("barValue");
        sfc3.setOperator("==");
        comp.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint();
        sfc4.setFactType("Goober");
        sfc4.setFieldName("zooField");
        sfc4.setFieldType("String");
        sfc4.setConstraintValueType(1);
        sfc4.setValue("zooValue");
        sfc4.setOperator("==");
        p.addConstraint((FieldConstraint)sfc4);
        ActionInsertFact ass = new ActionInsertFact("Whee");
        m.addRhsItem((IAction)ass);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"and composite complex\"dialect \"mvel\"\nwhen\nGoober( gooField == \"gooValue\" && fooField != null && fooField.barField == \"barValue\", zooField == \"zooValue\" )\nthen\ninsert( new Whee() );\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSSetMethodCallsMethodMVEL() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS SetMethodCallsMethod";
            m.addAttribute(new RuleAttribute("dialect", "mvel"));
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            m.addLhsItem((IPattern)p);
            ActionCallMethod acm = new ActionCallMethod();
            acm.methodName = "method";
            acm.variable = "$p";
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f1", "String", "String"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f2", "true", "Boolean"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f3", "31-Jan-2012", "Date"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f4", "100", "Integer"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f5", "100", "BigDecimal"));
            m.addRhsItem((IAction)acm);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.method( \"String\", true, sdf.parse(\"31-Jan-2012\"), 100, 100B );") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRHSSetMethodCallsMethodJava() {
        String oldValue = System.getProperty("drools.dateformat");
        try {
            System.setProperty("drools.dateformat", "dd-MMM-yyyy");
            RuleModel m = new RuleModel();
            m.name = "RHS SetMethodCallsMethod";
            m.addAttribute(new RuleAttribute("dialect", "java"));
            FactPattern p = new FactPattern("Person");
            p.setBoundName("$p");
            m.addLhsItem((IPattern)p);
            ActionCallMethod acm = new ActionCallMethod();
            acm.methodName = "method";
            acm.variable = "$p";
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f1", "String", "String"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f2", "true", "Boolean"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f3", "31-Jan-2012", "Date"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f4", "100", "Integer"));
            acm.addFieldValue((ActionFieldValue)new ActionFieldFunction("f5", "100", "BigDecimal"));
            m.addRhsItem((IAction)acm);
            String result = BRDRLPersistence.getInstance().marshal(m);
            Assert.assertTrue((result.indexOf("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"dd-MMM-yyyy\");") != -1 ? 1 : 0) != 0);
            Assert.assertTrue((result.indexOf("$p.method( \"String\", true, sdf.parse(\"31-Jan-2012\"), 100, new java.math.BigDecimal(\"100\") );") != -1 ? 1 : 0) != 0);
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("drools.dateformat");
            } else {
                System.setProperty("drools.dateformat", oldValue);
            }
        }
    }

    @Test
    public void testFromAccumulateWithEmbeddedFromEntryPoint() {
        RuleModel m = new RuleModel();
        m.name = "r1";
        SingleFieldConstraint sfc = new SingleFieldConstraint("bar");
        sfc.setFactType("Integer");
        sfc.setFieldBinding("$a");
        sfc.setOperator("==");
        sfc.setValue("777");
        FactPattern fp = new FactPattern("Foo");
        fp.addConstraint((FieldConstraint)sfc);
        FromEntryPointFactPattern fep = new FromEntryPointFactPattern();
        fep.setEntryPointName("ep");
        fep.setFactPattern(fp);
        FromAccumulateCompositeFactPattern fac = new FromAccumulateCompositeFactPattern();
        fac.setSourcePattern((IPattern)fep);
        fac.setFactPattern(new FactPattern("java.util.List"));
        fac.setFunction("max($a)");
        m.addLhsItem((IPattern)fac);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"r1\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from accumulate ( Foo( $a : bar == 777 ) from entry-point \"ep\", \nmax($a))\nthen\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }

    @Test
    public void testFromCollectWithEmbeddedFromEntryPoint() {
        RuleModel m = new RuleModel();
        m.name = "r1";
        SingleFieldConstraint sfc = new SingleFieldConstraint("bar");
        sfc.setFactType("Integer");
        sfc.setFieldBinding("$a");
        sfc.setOperator("==");
        sfc.setValue("777");
        FactPattern fp = new FactPattern("Foo");
        fp.addConstraint((FieldConstraint)sfc);
        FromEntryPointFactPattern fep = new FromEntryPointFactPattern();
        fep.setEntryPointName("ep");
        fep.setFactPattern(fp);
        FromCollectCompositeFactPattern fac = new FromCollectCompositeFactPattern();
        fac.setRightPattern((IPattern)fep);
        fac.setFactPattern(new FactPattern("java.util.List"));
        m.addLhsItem((IPattern)fac);
        String actual = BRDRLPersistence.getInstance().marshal(m);
        String expected = "rule \"r1\"\ndialect \"mvel\"\nwhen\njava.util.List( ) from collect ( Foo( $a : bar == 777 ) from entry-point \"ep\" ) \nthen\nend";
        this.assertEqualsIgnoreWhitespace(expected, actual);
    }
}

