/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionExecuteWorkItem;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldList;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.ActionWorkItemFieldValue;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.RuleModelVisitor;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionRetractFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionWorkItemSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.AttributeCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLActionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLConditionVariableColumn;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryBRLActionColumn;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryBRLConditionColumn;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.MetadataCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;
import org.drools.ide.common.server.util.GuidedDTBRDRLPersistence;
import org.drools.ide.common.server.util.GuidedDTDRLOtherwiseHelper;
import org.drools.ide.common.server.util.GuidedDTDRLUtilities;
import org.drools.ide.common.server.util.GuidedDTTemplateDataProvider;
import org.drools.ide.common.server.util.TemplateDataProvider;

public class GuidedDTDRLPersistence {
    public static GuidedDTDRLPersistence getInstance() {
        return new GuidedDTDRLPersistence();
    }

    public String marshal(GuidedDecisionTable52 dt) {
        StringBuilder sb = new StringBuilder();
        List<List<DTCellValue52>> data = dt.getData();
        List<BaseColumn> allColumns = dt.getExpandedColumns();
        for (int i = 0; i < data.size(); ++i) {
            List<DTCellValue52> row = data.get(i);
            GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, row);
            Integer num = (Integer)row.get(0).getNumericValue();
            String desc = row.get(1).getStringValue();
            BRLRuleModel rm = new BRLRuleModel(dt);
            rm.name = this.getName(dt.getTableName(), num);
            this.doMetadata(allColumns, dt.getMetadataCols(), row, rm);
            this.doAttribs(allColumns, dt.getAttributeCols(), row, rm);
            this.doConditions(allColumns, dt.getConditions(), rowDataProvider, row, data, rm);
            this.doActions(allColumns, dt.getActionCols(), rowDataProvider, row, rm);
            if (dt.getParentName() != null) {
                rm.parentName = dt.getParentName();
            }
            sb.append("//from row number: " + (i + 1) + "\n");
            if (desc != null && desc.length() > 0) {
                sb.append("//" + desc + "\n");
            }
            GuidedDTBRDRLPersistence drlMarshaller = new GuidedDTBRDRLPersistence(rowDataProvider);
            String rule = drlMarshaller.marshal(rm);
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    void doActions(List<BaseColumn> allColumns, List<ActionCol52> actionCols, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, RuleModel rm) {
        ArrayList<LabelledAction> actions = new ArrayList<LabelledAction>();
        for (ActionCol52 c : actionCols) {
            if (c instanceof LimitedEntryBRLActionColumn) {
                this.doAction(allColumns, (LimitedEntryBRLActionColumn)c, actions, rowDataProvider, row, rm);
                continue;
            }
            if (c instanceof BRLActionColumn) {
                this.doAction(allColumns, (BRLActionColumn)c, actions, rowDataProvider, row, rm);
                continue;
            }
            int index = allColumns.indexOf(c);
            DTCellValue52 dcv = row.get(index);
            String cell = "";
            if (c instanceof LimitedEntryCol) {
                if (dcv.getBooleanValue().booleanValue()) {
                    LimitedEntryCol lec = (LimitedEntryCol)((Object)c);
                    cell = GuidedDTDRLUtilities.convertDTCellValueToString(lec.getValue());
                }
            } else {
                cell = GuidedDTDRLUtilities.convertDTCellValueToString(dcv);
            }
            if (!this.validCell(cell)) continue;
            if (c instanceof ActionWorkItemInsertFactCol52) {
                this.doAction(actions, (ActionWorkItemInsertFactCol52)c, cell);
                continue;
            }
            if (c instanceof ActionInsertFactCol52) {
                this.doAction(actions, (ActionInsertFactCol52)c, cell);
                continue;
            }
            if (c instanceof ActionWorkItemSetFieldCol52) {
                this.doAction(actions, (ActionWorkItemSetFieldCol52)c, cell);
                continue;
            }
            if (c instanceof ActionSetFieldCol52) {
                this.doAction(actions, (ActionSetFieldCol52)c, cell);
                continue;
            }
            if (c instanceof ActionRetractFactCol52) {
                this.doAction(actions, (ActionRetractFactCol52)c, cell);
                continue;
            }
            if (!(c instanceof ActionWorkItemCol52)) continue;
            this.doAction(actions, (ActionWorkItemCol52)c, cell);
        }
        rm.rhs = new IAction[actions.size()];
        for (int i = 0; i < rm.rhs.length; ++i) {
            rm.rhs[i] = ((LabelledAction)actions.get((int)i)).action;
        }
    }

    private void doAction(List<BaseColumn> allColumns, LimitedEntryBRLActionColumn column, List<LabelledAction> actions, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, RuleModel rm) {
        int index = allColumns.indexOf(column);
        DTCellValue52 dcv = row.get(index);
        if (dcv.getBooleanValue().booleanValue()) {
            for (IAction action : column.getDefinition()) {
                this.addAction(action, actions);
            }
        }
    }

    private void doAction(List<BaseColumn> allColumns, BRLActionColumn column, List<LabelledAction> actions, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, RuleModel rm) {
        block5: {
            block4: {
                if (this.hasVariables(column)) break block4;
                BRLActionVariableColumn variableColumn = column.getChildColumns().get(0);
                int index = allColumns.indexOf(variableColumn);
                DTCellValue52 dcv = row.get(index);
                if (!dcv.getBooleanValue().booleanValue()) break block5;
                for (IAction action : column.getDefinition()) {
                    this.addAction(action, actions);
                }
                break block5;
            }
            for (IAction action : column.getDefinition()) {
                boolean addAction = true;
                HashMap<InterpolationVariable, Integer> ivs = new HashMap<InterpolationVariable, Integer>();
                RuleModelVisitor rmv = new RuleModelVisitor(action, ivs);
                rmv.visit(action);
                if (ivs.size() > 0) {
                    for (InterpolationVariable variable : ivs.keySet()) {
                        String value = rowDataProvider.getTemplateKeyValue(variable.getVarName());
                        if (!"".equals(value)) continue;
                        addAction = false;
                        break;
                    }
                }
                if (!addAction) continue;
                this.addAction(action, actions);
            }
        }
    }

    private boolean hasVariables(BRLActionColumn column) {
        HashMap<InterpolationVariable, Integer> ivs = new HashMap<InterpolationVariable, Integer>();
        RuleModel rm = new RuleModel();
        for (IAction action : column.getDefinition()) {
            rm.addRhsItem(action);
        }
        RuleModelVisitor rmv = new RuleModelVisitor(ivs);
        rmv.visit(rm);
        return ivs.size() > 0;
    }

    private void addAction(IAction action, List<LabelledAction> actions) {
        String binding = null;
        LabelledAction a = null;
        if (action instanceof ActionInsertFact) {
            ActionInsertFact af = (ActionInsertFact)action;
            binding = af.getBoundName();
            a = this.findByLabelledAction(actions, binding);
        } else if (action instanceof ActionSetField) {
            ActionSetField af = (ActionSetField)action;
            binding = af.variable;
            a = this.findByLabelledAction(actions, binding);
        }
        if (binding == null) {
            binding = action.toString();
        }
        if (a == null) {
            a = new LabelledAction();
            a.boundName = binding;
            a.action = action;
            actions.add(a);
        }
    }

    private void doAction(List<LabelledAction> actions, ActionWorkItemInsertFactCol52 ac, String cell) {
        if (Boolean.TRUE.equals(Boolean.parseBoolean(cell))) {
            ActionInsertFact ins;
            LabelledAction a = this.findByLabelledAction(actions, ac.getBoundName());
            if (a == null) {
                a = new LabelledAction();
                a.boundName = ac.getBoundName();
                if (!ac.isInsertLogical()) {
                    ins = new ActionInsertFact(ac.getFactType());
                    ins.setBoundName(ac.getBoundName());
                    a.action = ins;
                } else {
                    ins = new ActionInsertLogicalFact(ac.getFactType());
                    ins.setBoundName(ac.getBoundName());
                    a.action = ins;
                }
                actions.add(a);
            }
            ins = (ActionInsertFact)a.action;
            ActionWorkItemFieldValue val = new ActionWorkItemFieldValue(ac.getFactField(), ac.getType(), ac.getWorkItemName(), ac.getWorkItemResultParameterName(), ac.getParameterClassName());
            ins.addFieldValue(val);
        }
    }

    private void doAction(List<LabelledAction> actions, ActionInsertFactCol52 ac, String cell) {
        ActionInsertFact ins;
        LabelledAction a = this.findByLabelledAction(actions, ac.getBoundName());
        if (a == null) {
            a = new LabelledAction();
            a.boundName = ac.getBoundName();
            if (!ac.isInsertLogical()) {
                ins = new ActionInsertFact(ac.getFactType());
                ins.setBoundName(ac.getBoundName());
                a.action = ins;
            } else {
                ins = new ActionInsertLogicalFact(ac.getFactType());
                ins.setBoundName(ac.getBoundName());
                a.action = ins;
            }
            actions.add(a);
        }
        ins = (ActionInsertFact)a.action;
        ActionFieldValue val = new ActionFieldValue(ac.getFactField(), cell, ac.getType());
        ins.addFieldValue(val);
    }

    private void doAction(List<LabelledAction> actions, ActionWorkItemSetFieldCol52 sf, String cell) {
        if (Boolean.TRUE.equals(Boolean.parseBoolean(cell))) {
            LabelledAction a = this.findByLabelledAction(actions, sf.getBoundName());
            if (a == null) {
                a = new LabelledAction();
                a.boundName = sf.getBoundName();
                a.action = !sf.isUpdate() ? new ActionSetField(sf.getBoundName()) : new ActionUpdateField(sf.getBoundName());
                actions.add(a);
            } else if (sf.isUpdate() && !(a.action instanceof ActionUpdateField)) {
                ActionSetField old = (ActionSetField)a.action;
                ActionUpdateField update = new ActionUpdateField(sf.getBoundName());
                update.fieldValues = old.fieldValues;
                a.action = update;
            }
            ActionSetField asf = (ActionSetField)a.action;
            ActionWorkItemFieldValue val = new ActionWorkItemFieldValue(sf.getFactField(), sf.getType(), sf.getWorkItemName(), sf.getWorkItemResultParameterName(), sf.getParameterClassName());
            asf.addFieldValue(val);
        }
    }

    private void doAction(List<LabelledAction> actions, ActionSetFieldCol52 sf, String cell) {
        LabelledAction a = this.findByLabelledAction(actions, sf.getBoundName());
        if (a == null) {
            a = new LabelledAction();
            a.boundName = sf.getBoundName();
            a.action = !sf.isUpdate() ? new ActionSetField(sf.getBoundName()) : new ActionUpdateField(sf.getBoundName());
            actions.add(a);
        } else if (sf.isUpdate() && !(a.action instanceof ActionUpdateField)) {
            ActionSetField old = (ActionSetField)a.action;
            ActionUpdateField update = new ActionUpdateField(sf.getBoundName());
            update.fieldValues = old.fieldValues;
            a.action = update;
        }
        ActionSetField asf = (ActionSetField)a.action;
        ActionFieldValue val = new ActionFieldValue(sf.getFactField(), cell, sf.getType());
        asf.addFieldValue(val);
    }

    private void doAction(List<LabelledAction> actions, ActionRetractFactCol52 rf, String cell) {
        LabelledAction a = new LabelledAction();
        a.action = new ActionRetractFact(cell);
        a.boundName = cell;
        actions.add(a);
    }

    private void doAction(List<LabelledAction> actions, ActionWorkItemCol52 wi, String cell) {
        if (Boolean.TRUE.equals(Boolean.parseBoolean(cell))) {
            ActionExecuteWorkItem aewi = new ActionExecuteWorkItem();
            aewi.setWorkDefinition(wi.getWorkItemDefinition());
            LabelledAction a = new LabelledAction();
            a.action = aewi;
            a.boundName = wi.getWorkItemDefinition().getName();
            actions.add(a);
        }
    }

    private LabelledAction findByLabelledAction(List<LabelledAction> actions, String boundName) {
        for (LabelledAction labelledAction : actions) {
            IAction action = labelledAction.action;
            if (!(action instanceof ActionFieldList) || !labelledAction.boundName.equals(boundName)) continue;
            return labelledAction;
        }
        return null;
    }

    void doConditions(List<BaseColumn> allColumns, List<CompositeColumn<?>> conditionPatterns, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, List<List<DTCellValue52>> data, RuleModel rm) {
        ArrayList<IPattern> patterns = new ArrayList<IPattern>();
        for (CompositeColumn<?> cc : conditionPatterns) {
            if (cc instanceof LimitedEntryBRLConditionColumn) {
                this.doCondition(allColumns, (LimitedEntryBRLConditionColumn)cc, patterns, rowDataProvider, row, rm);
                continue;
            }
            if (cc instanceof BRLConditionColumn) {
                this.doCondition(allColumns, (BRLConditionColumn)cc, patterns, rowDataProvider, row, rm);
                continue;
            }
            if (!(cc instanceof Pattern52)) continue;
            this.doCondition(allColumns, (Pattern52)cc, patterns, row, data, rm);
        }
        rm.lhs = patterns.toArray(new IPattern[patterns.size()]);
    }

    private void doCondition(List<BaseColumn> allColumns, LimitedEntryBRLConditionColumn column, List<IPattern> patterns, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, RuleModel rm) {
        int index = allColumns.indexOf(column);
        DTCellValue52 dcv = row.get(index);
        if (dcv.getBooleanValue().booleanValue()) {
            for (IPattern pattern : column.getDefinition()) {
                patterns.add(pattern);
            }
        }
    }

    private void doCondition(List<BaseColumn> allColumns, BRLConditionColumn column, List<IPattern> patterns, TemplateDataProvider rowDataProvider, List<DTCellValue52> row, RuleModel rm) {
        block5: {
            block4: {
                if (this.hasVariables(column)) break block4;
                BRLConditionVariableColumn variableColumn = column.getChildColumns().get(0);
                int index = allColumns.indexOf(variableColumn);
                DTCellValue52 dcv = row.get(index);
                if (dcv == null || !dcv.getBooleanValue().booleanValue()) break block5;
                for (IPattern pattern : column.getDefinition()) {
                    patterns.add(pattern);
                }
                break block5;
            }
            for (IPattern pattern : column.getDefinition()) {
                boolean addPattern = true;
                HashMap<InterpolationVariable, Integer> ivs = new HashMap<InterpolationVariable, Integer>();
                RuleModelVisitor rmv = new RuleModelVisitor(pattern, ivs);
                rmv.visit(pattern);
                if (ivs.size() > 0) {
                    for (InterpolationVariable variable : ivs.keySet()) {
                        String value = rowDataProvider.getTemplateKeyValue(variable.getVarName());
                        if (!"".equals(value)) continue;
                        addPattern = false;
                        break;
                    }
                }
                if (!addPattern) continue;
                patterns.add(pattern);
            }
        }
    }

    private boolean hasVariables(BRLConditionColumn column) {
        HashMap<InterpolationVariable, Integer> ivs = new HashMap<InterpolationVariable, Integer>();
        RuleModel rm = new RuleModel();
        for (IPattern pattern : column.getDefinition()) {
            rm.addLhsItem(pattern);
        }
        RuleModelVisitor rmv = new RuleModelVisitor(ivs);
        rmv.visit(rm);
        return ivs.size() > 0;
    }

    private void doCondition(List<BaseColumn> allColumns, Pattern52 pattern, List<IPattern> patterns, List<DTCellValue52> row, List<List<DTCellValue52>> data, RuleModel rm) {
        List<ConditionCol52> cols = pattern.getChildColumns();
        block4: for (ConditionCol52 c : cols) {
            FromEntryPointFactPattern fep;
            FactPattern fp;
            boolean isOtherwise;
            int index = allColumns.indexOf(c);
            DTCellValue52 dcv = row.get(index);
            String cell = "";
            if (c instanceof LimitedEntryCol) {
                LimitedEntryCol lec;
                DTCellValue52 value;
                if (Boolean.TRUE.equals(dcv.getBooleanValue()) && (value = (lec = (LimitedEntryCol)((Object)c)).getValue()) != null) {
                    cell = GuidedDTDRLUtilities.convertDTCellValueToString(value);
                }
            } else {
                cell = GuidedDTDRLUtilities.convertDTCellValueToString(dcv);
            }
            boolean isValid = isOtherwise = dcv.isOtherwise();
            if (!isOtherwise) {
                isValid = this.validCell(cell);
            }
            if (c.getOperator() != null && (c.getOperator().equals("== null") || c.getOperator().equals("!= null"))) {
                isValid = Boolean.TRUE.equals(dcv.getBooleanValue());
            }
            if (!isValid) continue;
            IPattern ifp = this.findByFactPattern(patterns, pattern.getBoundName());
            if (ifp == null) {
                fp = new FactPattern(pattern.getFactType());
                fp.setBoundName(pattern.getBoundName());
                fp.setNegated(pattern.isNegated());
                fp.setWindow(pattern.getWindow());
                if (pattern.getEntryPointName() != null && pattern.getEntryPointName().length() > 0) {
                    fep = new FromEntryPointFactPattern();
                    fep.setEntryPointName(pattern.getEntryPointName());
                    fep.setFactPattern(fp);
                    patterns.add(fep);
                    ifp = fep;
                } else {
                    patterns.add(fp);
                    ifp = fp;
                }
            }
            if (ifp instanceof FactPattern) {
                fp = (FactPattern)ifp;
            } else if (ifp instanceof FromEntryPointFactPattern) {
                fep = (FromEntryPointFactPattern)ifp;
                fp = fep.getFactPattern();
            } else {
                throw new IllegalArgumentException("Inexpected IFactPattern implementation found.");
            }
            switch (c.getConstraintValueType()) {
                case 1: 
                case 3: {
                    FieldConstraint fc;
                    if (!isOtherwise) {
                        fc = this.makeSingleFieldConstraint(c, cell);
                        fp.addConstraint(fc);
                        continue block4;
                    }
                    fc = this.makeSingleFieldConstraint(c, allColumns, data);
                    fp.addConstraint(fc);
                    continue block4;
                }
                case 5: {
                    SingleFieldConstraint pred = new SingleFieldConstraint();
                    pred.setConstraintValueType(c.getConstraintValueType());
                    if (c.getFactField() != null && c.getFactField().indexOf("$param") > -1) {
                        pred.setValue(c.getFactField().replace("$param", cell));
                    } else {
                        pred.setValue(cell);
                    }
                    fp.addConstraint(pred);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown constraintValueType: " + c.getConstraintValueType());
        }
    }

    String makeInList(String cell) {
        if (cell.startsWith("(")) {
            return cell;
        }
        String res = "";
        StringTokenizer st = new StringTokenizer(cell, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            res = t.startsWith("\"") ? res + t : res + "\"" + t + "\"";
            if (!st.hasMoreTokens()) continue;
            res = res + ", ";
        }
        return "(" + res + ")";
    }

    private boolean no(String operator) {
        return operator == null || "".equals(operator);
    }

    private IPattern findByFactPattern(List<IPattern> patterns, String boundName) {
        if (boundName == null) {
            return null;
        }
        for (IPattern ifp : patterns) {
            FromEntryPointFactPattern fefp;
            FactPattern fp;
            if (ifp instanceof FactPattern) {
                FactPattern fp2 = (FactPattern)ifp;
                if (fp2.getBoundName() == null || !fp2.getBoundName().equals(boundName)) continue;
                return fp2;
            }
            if (!(ifp instanceof FromEntryPointFactPattern) || (fp = (fefp = (FromEntryPointFactPattern)ifp).getFactPattern()).getBoundName() == null || !fp.getBoundName().equals(boundName)) continue;
            return fp;
        }
        return null;
    }

    void doAttribs(List<BaseColumn> allColumns, List<AttributeCol52> attributeCols, List<DTCellValue52> row, RuleModel rm) {
        ArrayList<RuleAttribute> attribs = new ArrayList<RuleAttribute>();
        for (int j = 0; j < attributeCols.size(); ++j) {
            AttributeCol52 at = attributeCols.get(j);
            int index = allColumns.indexOf(at);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) continue;
            if (at.getAttribute().equals("negate")) {
                rm.setNegated(Boolean.valueOf(cell));
                continue;
            }
            attribs.add(new RuleAttribute(at.getAttribute(), cell));
        }
        if (attribs.size() > 0) {
            rm.attributes = attribs.toArray(new RuleAttribute[attribs.size()]);
        }
    }

    void doMetadata(List<BaseColumn> allColumns, List<MetadataCol52> metadataCols, List<DTCellValue52> row, RuleModel rm) {
        ArrayList<RuleMetadata> metadataList = new ArrayList<RuleMetadata>();
        for (int j = 0; j < metadataCols.size(); ++j) {
            MetadataCol52 meta = metadataCols.get(j);
            int index = allColumns.indexOf(meta);
            String cell = GuidedDTDRLUtilities.convertDTCellValueToString(row.get(index));
            if (!this.validCell(cell)) continue;
            metadataList.add(new RuleMetadata(meta.getMetadata(), cell));
        }
        if (metadataList.size() > 0) {
            rm.metadataList = metadataList.toArray(new RuleMetadata[metadataList.size()]);
        }
    }

    String getName(String tableName, Number num) {
        return "Row " + num.longValue() + " " + tableName;
    }

    boolean validCell(String c) {
        return c != null && !c.trim().equals("");
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol52 c, String cell) {
        SingleFieldConstraint sfc = new SingleFieldConstraint(c.getFactField());
        if (this.no(c.getOperator())) {
            String[] a = cell.split("\\s");
            if (a.length > 1) {
                StringBuilder operator = new StringBuilder(a[0]);
                for (int i = 1; i < a.length - 1; ++i) {
                    operator.append(a[i]);
                }
                sfc.setOperator(operator.toString());
                sfc.setValue(a[a.length - 1]);
            } else {
                sfc.setValue(cell);
            }
        } else {
            sfc.setOperator(c.getOperator());
            if (SuggestionCompletionEngine.operatorRequiresList(c.getOperator())) {
                sfc.setValue(this.makeInList(cell));
            } else if (!c.getOperator().equals("== null") && !c.getOperator().equals("!= null")) {
                sfc.setValue(cell);
            }
        }
        if (c.getConstraintValueType() == 1 && c.isBound()) {
            sfc.setFieldBinding(c.getBinding());
        }
        sfc.setParameters(c.getParameters());
        sfc.setConstraintValueType(c.getConstraintValueType());
        sfc.setFieldType(c.getFieldType());
        return sfc;
    }

    private FieldConstraint makeSingleFieldConstraint(ConditionCol52 c, List<BaseColumn> allColumns, List<List<DTCellValue52>> data) {
        GuidedDTDRLOtherwiseHelper.OtherwiseBuilder builder = GuidedDTDRLOtherwiseHelper.getBuilder(c);
        return builder.makeFieldConstraint(c, allColumns, data);
    }

    private class LabelledAction {
        String boundName;
        IAction action;

        private LabelledAction() {
        }
    }
}

