/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder;

import java.io.File;
import java.util.Arrays;
import java.util.EventObject;
import org.apache.commons.finder.Finder;

public class FindEvent
extends EventObject {
    private File directory;
    private Finder finder;
    private File file;
    private File[] files;
    private String type;

    public FindEvent(Finder finder, String type, File directory) {
        super(directory);
        this.finder = finder;
        this.directory = directory;
        this.type = type;
    }

    public FindEvent(Finder finder, String type, File directory, File file) {
        super(file);
        this.finder = finder;
        this.directory = directory;
        this.file = file;
        this.type = type;
    }

    public FindEvent(Finder finder, String type, File directory, File[] files) {
        super(files);
        this.finder = finder;
        this.directory = directory;
        this.files = files;
        this.type = type;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Finder getFinder() {
        return this.finder;
    }

    public File getFile() {
        return this.file;
    }

    public File[] getFiles() {
        return this.files;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        String str = "FindEvent - " + this.type + "; dir=" + this.directory + ", file=" + this.file;
        if (this.files != null) {
            str = str + ", files=" + Arrays.asList(this.files);
        }
        return str;
    }
}

