/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.activemq.openwire.tool.CppMarshallingHeadersGenerator;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JAnnotationValue;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;

public class CppMarshallingClassesGenerator
extends CppMarshallingHeadersGenerator {
    protected String getFilePostFix() {
        return ".cpp";
    }

    protected void generateUnmarshalBodyForProperty(PrintWriter out, JProperty property, JAnnotationValue size) {
        out.print("    ");
        String setter = property.getSetter().getSimpleName();
        String type = property.getType().getSimpleName();
        if (type.equals("boolean")) {
            out.println("info." + setter + "( bs.readBoolean() );");
        } else if (type.equals("byte")) {
            out.println("info." + setter + "( DataStreamMarshaller.readByte(dataIn) );");
        } else if (type.equals("char")) {
            out.println("info." + setter + "( DataStreamMarshaller.readChar(dataIn) );");
        } else if (type.equals("short")) {
            out.println("info." + setter + "( DataStreamMarshaller.readShort(dataIn) );");
        } else if (type.equals("int")) {
            out.println("info." + setter + "( DataStreamMarshaller.readInt(dataIn) );");
        } else if (type.equals("long")) {
            out.println("info." + setter + "( UnmarshalLong(wireFormat, dataIn, bs) );");
        } else if (type.equals("String")) {
            out.println("info." + setter + "( readString(dataIn, bs) );");
        } else if (type.equals("byte[]") || type.equals("ByteSequence")) {
            if (size != null) {
                out.println("info." + setter + "( readBytes(dataIn, " + size.asInt() + ") );");
            } else {
                out.println("info." + setter + "( readBytes(dataIn, bs.readBoolean()) );");
            }
        } else if (this.isThrowable(property.getType())) {
            out.println("info." + setter + "( unmarshalBrokerError(wireFormat, dataIn, bs) );");
        } else if (this.isCachedProperty(property)) {
            out.println("info." + setter + "( (" + type + ") unmarshalCachedObject(wireFormat, dataIn, bs) );");
        } else {
            out.println("info." + setter + "( (" + type + ") unmarshalNestedObject(wireFormat, dataIn, bs) );");
        }
    }

    protected void generateUnmarshalBodyForArrayProperty(PrintWriter out, JProperty property, JAnnotationValue size) {
        JClass propertyType = property.getType();
        String arrayType = propertyType.getArrayComponentType().getSimpleName();
        String setter = property.getGetter().getSimpleName();
        out.println();
        if (size != null) {
            out.println("    {");
            out.println("        " + arrayType + "[] value = new " + arrayType + "[" + size.asInt() + "];");
            out.println("        for( int i=0; i < " + size.asInt() + "; i++ ) {");
            out.println("            value[i] = (" + arrayType + ") unmarshalNestedObject(wireFormat,dataIn, bs);");
            out.println("        }");
            out.println("        info." + setter + "( value );");
            out.println("    }");
        } else {
            out.println("    if (bs.readBoolean()) {");
            out.println("        short size = DataStreamMarshaller.readShort(dataIn);");
            out.println("        " + arrayType + "[] value = new " + arrayType + "[size];");
            out.println("        for( int i=0; i < size; i++ ) {");
            out.println("            value[i] = (" + arrayType + ") unmarshalNestedObject(wireFormat,dataIn, bs);");
            out.println("        }");
            out.println("        info." + setter + "( value );");
            out.println("    }");
            out.println("    else {");
            out.println("        info." + setter + "( null );");
            out.println("    }");
        }
    }

    protected int generateMarshal1Body(PrintWriter out) {
        List<JProperty> properties = this.getProperties();
        int baseSize = 0;
        for (JProperty property : properties) {
            JAnnotation annotation = property.getAnnotation("openwire:property");
            JAnnotationValue size = annotation.getValue("size");
            JClass propertyType = property.getType();
            String type = propertyType.getSimpleName();
            String getter = "info." + property.getGetter().getSimpleName() + "()";
            out.print(this.indent);
            if (type.equals("boolean")) {
                out.println("bs.writeBoolean(" + getter + ");");
                continue;
            }
            if (type.equals("byte")) {
                ++baseSize;
                continue;
            }
            if (type.equals("char")) {
                ++baseSize;
                continue;
            }
            if (type.equals("short")) {
                ++baseSize;
                continue;
            }
            if (type.equals("int")) {
                ++baseSize;
                continue;
            }
            if (type.equals("long")) {
                out.println("rc += marshal1Long(wireFormat, " + getter + ", bs);");
                continue;
            }
            if (type.equals("String")) {
                out.println("rc += writeString(" + getter + ", bs);");
                continue;
            }
            if (type.equals("byte[]") || type.equals("ByteSequence")) {
                if (size == null) {
                    out.println("bs.writeBoolean(" + getter + "!=null);");
                    out.println("    rc += " + getter + "==null ? 0 : " + getter + ".Length+4;");
                    continue;
                }
                baseSize += size.asInt();
                continue;
            }
            if (propertyType.isArrayType()) {
                if (size != null) {
                    out.println("rc += marshalObjectArrayConstSize(wireFormat, " + getter + ", bs, " + size.asInt() + ");");
                    continue;
                }
                out.println("rc += marshalObjectArray(wireFormat, " + getter + ", bs);");
                continue;
            }
            if (this.isThrowable(propertyType)) {
                out.println("rc += marshalBrokerError(wireFormat, " + getter + ", bs);");
                continue;
            }
            if (this.isCachedProperty(property)) {
                out.println("rc += marshal1CachedObject(wireFormat, " + getter + ", bs);");
                continue;
            }
            out.println("rc += marshal1NestedObject(wireFormat, " + getter + ", bs);");
        }
        return baseSize;
    }

    protected void generateMarshal2Body(PrintWriter out) {
        List<JProperty> properties = this.getProperties();
        for (JProperty property : properties) {
            JAnnotation annotation = property.getAnnotation("openwire:property");
            JAnnotationValue size = annotation.getValue("size");
            JClass propertyType = property.getType();
            String type = propertyType.getSimpleName();
            String getter = "info." + property.getGetter().getSimpleName() + "()";
            out.print(this.indent);
            if (type.equals("boolean")) {
                out.println("bs.readBoolean();");
                continue;
            }
            if (type.equals("byte")) {
                out.println("DataStreamMarshaller.writeByte(" + getter + ", dataOut);");
                continue;
            }
            if (type.equals("char")) {
                out.println("DataStreamMarshaller.writeChar(" + getter + ", dataOut);");
                continue;
            }
            if (type.equals("short")) {
                out.println("DataStreamMarshaller.writeShort(" + getter + ", dataOut);");
                continue;
            }
            if (type.equals("int")) {
                out.println("DataStreamMarshaller.writeInt(" + getter + ", dataOut);");
                continue;
            }
            if (type.equals("long")) {
                out.println("marshal2Long(wireFormat, " + getter + ", dataOut, bs);");
                continue;
            }
            if (type.equals("String")) {
                out.println("writeString(" + getter + ", dataOut, bs);");
                continue;
            }
            if (type.equals("byte[]") || type.equals("ByteSequence")) {
                if (size != null) {
                    out.println("dataOut.write(" + getter + ", 0, " + size.asInt() + ");");
                    continue;
                }
                out.println("if(bs.readBoolean()) {");
                out.println("       DataStreamMarshaller.writeInt(" + getter + ".Length, dataOut);");
                out.println("       dataOut.write(" + getter + ");");
                out.println("    }");
                continue;
            }
            if (propertyType.isArrayType()) {
                if (size != null) {
                    out.println("marshalObjectArrayConstSize(wireFormat, " + getter + ", dataOut, bs, " + size.asInt() + ");");
                    continue;
                }
                out.println("marshalObjectArray(wireFormat, " + getter + ", dataOut, bs);");
                continue;
            }
            if (this.isThrowable(propertyType)) {
                out.println("marshalBrokerError(wireFormat, " + getter + ", dataOut, bs);");
                continue;
            }
            if (this.isCachedProperty(property)) {
                out.println("marshal2CachedObject(wireFormat, " + getter + ", dataOut, bs);");
                continue;
            }
            out.println("marshal2NestedObject(wireFormat, " + getter + ", dataOut, bs);");
        }
    }

    protected void generateFile(PrintWriter out) throws Exception {
        this.generateLicence(out);
        out.println("#include \"marshal/" + this.className + ".hpp\"");
        out.println("");
        out.println("using namespace apache::activemq::client::marshal;");
        out.println("");
        out.println("/*");
        out.println(" *  Marshalling code for Open Wire Format for " + this.jclass.getSimpleName() + "");
        out.println(" *");
        out.println(" * NOTE!: This file is autogenerated - do not modify!");
        out.println(" *        if you need to make a change, please see the Groovy scripts in the");
        out.println(" *        activemq-core module");
        out.println(" */");
        out.println("");
        out.println("" + this.className + "::" + this.className + "()");
        out.println("{");
        out.println("    // no-op");
        out.println("}");
        out.println("");
        out.println("" + this.className + "::~" + this.className + "()");
        out.println("{");
        out.println("    // no-op");
        out.println("}");
        out.println("");
        if (!this.isAbstractClass()) {
            out.println("");
            out.println("");
            out.println("IDataStructure* " + this.className + "::createObject() ");
            out.println("{");
            out.println("    return new " + this.jclass.getSimpleName() + "();");
            out.println("}");
            out.println("");
            out.println("char " + this.className + "::getDataStructureType() ");
            out.println("{");
            out.println("    return " + this.jclass.getSimpleName() + ".ID_" + this.jclass.getSimpleName() + ";");
            out.println("}");
        }
        out.println("");
        out.println("    /* ");
        out.println("     * Un-marshal an object instance from the data input stream");
        out.println("     */ ");
        out.println("void " + this.className + "::unmarshal(ProtocolFormat& wireFormat, Object o, BinaryReader& dataIn, BooleanStream& bs) ");
        out.println("{");
        out.println("    base.unmarshal(wireFormat, o, dataIn, bs);");
        List<JProperty> properties = this.getProperties();
        boolean marshallerAware = this.isMarshallerAware();
        if (!properties.isEmpty() || marshallerAware) {
            out.println("");
            out.println("    " + this.jclass.getSimpleName() + "& info = (" + this.jclass.getSimpleName() + "&) o;");
        }
        if (marshallerAware) {
            out.println("");
            out.println("    info.beforeUnmarshall(wireFormat);");
            out.println("        ");
        }
        this.generateTightUnmarshalBody(out);
        if (marshallerAware) {
            out.println("");
            out.println("    info.afterUnmarshall(wireFormat);");
        }
        out.println("");
        out.println("}");
        out.println("");
        out.println("");
        out.println("/*");
        out.println(" * Write the booleans that this object uses to a BooleanStream");
        out.println(" */");
        out.println("int " + this.className + "::marshal1(ProtocolFormat& wireFormat, Object& o, BooleanStream& bs) {");
        out.println("    " + this.jclass.getSimpleName() + "& info = (" + this.jclass.getSimpleName() + "&) o;");
        if (marshallerAware) {
            out.println("");
            out.println("    info.beforeMarshall(wireFormat);");
        }
        out.println("");
        out.println("    int rc = base.marshal1(wireFormat, info, bs);");
        int baseSize = this.generateMarshal1Body(out);
        out.println("");
        out.println("    return rc + " + baseSize + ";");
        out.println("}");
        out.println("");
        out.println("/* ");
        out.println(" * Write a object instance to data output stream");
        out.println(" */");
        out.println("void " + this.className + "::marshal2(ProtocolFormat& wireFormat, Object& o, BinaryWriter& dataOut, BooleanStream& bs) {");
        out.println("    base.marshal2(wireFormat, o, dataOut, bs);");
        if (!properties.isEmpty() || marshallerAware) {
            out.println("");
            out.println("    " + this.jclass.getSimpleName() + "& info = (" + this.jclass.getSimpleName() + "&) o;");
        }
        this.generateMarshal2Body(out);
        if (marshallerAware) {
            out.println("");
            out.println("    info.afterMarshall(wireFormat);");
        }
        out.println("");
        out.println("}");
    }

    public void generateFactory(PrintWriter out) {
        this.generateLicence(out);
        out.println("");
        out.println("// Marshalling code for Open Wire Format");
        out.println("//");
        out.println("//");
        out.println("// NOTE!: This file is autogenerated - do not modify!");
        out.println("//        if you need to make a change, please see the Groovy scripts in the");
        out.println("//        activemq-openwire module");
        out.println("//");
        out.println("");
        out.println("#include \"marshal/" + this.className + ".hpp\"");
        out.println("");
        ArrayList<JClass> list = new ArrayList<JClass>(this.getConcreteClasses());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                JClass c1 = (JClass)o1;
                JClass c2 = (JClass)o2;
                return c1.getSimpleName().compareTo(c2.getSimpleName());
            }
        });
        for (JClass jclass : list) {
            out.println("#include \"marshal/" + jclass.getSimpleName() + "Marshaller.hpp\"");
        }
        out.println("");
        out.println("");
        out.println("using namespace apache::activemq::client::marshal;");
        out.println("");
        out.println("");
        out.println("void MarshallerFactory::configure(ProtocolFormat& format) ");
        out.println("{");
        for (JClass jclass : list) {
            out.println("    format.addMarshaller(new " + jclass.getSimpleName() + "Marshaller());");
        }
        out.println("");
        out.println("}");
    }
}

