/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;

public class ConcurrentHashTable {
    private static final long serialVersionUID = 510L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    private AbstractHashTable.Index index;
    private int startResult = 31;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.startResult = 31 * this.startResult + index[i].getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(this.index, cap, loadFactor);
        }
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity, float loadFactor) {
        this(index, initialCapacity, loadFactor, 16);
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index, int initialCapacity) {
        this(index, initialCapacity, 0.75f, 16);
    }

    public ConcurrentHashTable(AbstractHashTable.FieldIndex[] index) {
        this(index, 16, 0.75f, 16);
    }

    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].tupleCount != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].tupleCount == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].tupleCount;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].tupleCount;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].tupleCount;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public void add(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        this.segmentFor(hashCode).add(rightTuple, hashCode, object);
    }

    public void remove(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        this.segmentFor(hashCode).remove(rightTuple, hashCode, object);
    }

    public RightTupleList get(LeftTuple tuple, InternalFactHandle factHandle) {
        int hashCode = this.index.hashCodeOf(tuple);
        return this.segmentFor(hashCode).get(hashCode, tuple, factHandle);
    }

    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].clear();
        }
    }

    static final class Segment
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 510L;
        volatile transient int tupleCount;
        volatile transient int keyCount;
        transient int modCount;
        transient int threshold;
        volatile transient RightTupleList[] table;
        final float loadFactor;
        private AbstractHashTable.Index index;

        Segment(AbstractHashTable.Index index, int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new RightTupleList[initialCapacity]);
            this.index = index;
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(RightTupleList[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        RightTupleList getFirst(int hash) {
            RightTupleList[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(RightTuple rightTuple, int hashCode, Object object) {
            this.lock();
            try {
                RightTupleList entry = this.getOrCreate(hashCode, object);
                entry.add(rightTuple);
                ++this.tupleCount;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(RightTuple rightTuple, int hashCode, Object object) {
            this.lock();
            try {
                RightTupleList first;
                int c = this.keyCount - 1;
                RightTupleList[] tab = this.table;
                int index = hashCode & tab.length - 1;
                RightTupleList e = first = tab[index];
                while (e != null && !e.matches(object, hashCode)) {
                    e = (RightTupleList)e.next;
                }
                e.remove(rightTuple);
                --this.tupleCount;
                if (e.getFirst() == null) {
                    RightTupleList newFirst = (RightTupleList)e.getNext();
                    for (RightTupleList p = first; p != e; p = (RightTupleList)p.getNext()) {
                        newFirst = new RightTupleList(p.getIndex(), hashCode, newFirst);
                    }
                    this.keyCount = c;
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RightTupleList get(int hashCode, LeftTuple tuple, InternalFactHandle factHandle) {
            this.lock();
            try {
                RightTupleList first;
                RightTupleList entry;
                RightTupleList[] tab = this.table;
                int index = hashCode & tab.length - 1;
                for (entry = first = tab[index]; entry != null; entry = (RightTupleList)entry.getNext()) {
                    if (!entry.matches(tuple, hashCode, factHandle)) continue;
                    RightTupleList rightTupleList = entry;
                    return rightTupleList;
                }
                RightTupleList rightTupleList = entry;
                return rightTupleList;
            }
            finally {
                this.unlock();
            }
        }

        private RightTupleList getOrCreate(int hashCode, Object object) {
            RightTupleList first;
            int c = this.keyCount;
            RightTupleList[] tab = this.table;
            int index = hashCode & tab.length - 1;
            RightTupleList e = first = tab[index];
            while (e != null) {
                if (e.matches(object, hashCode)) {
                    return e;
                }
                e = (RightTupleList)e.next;
            }
            if (e == null) {
                if (c++ > this.threshold) {
                    this.rehash();
                }
                ++this.modCount;
                tab[index] = e = new RightTupleList(this.index, hashCode, first);
                this.keyCount = c;
            }
            return e;
        }

        void rehash() {
            RightTupleList[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            RightTupleList[] newTable = new RightTupleList[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                RightTupleList e = oldTable[i];
                if (e == null) continue;
                RightTupleList next = (RightTupleList)e.getNext();
                int idx = e.hashCode() & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                RightTupleList lastRun = e;
                int lastIdx = idx;
                for (RightTupleList last = next; last != null; last = (RightTupleList)last.getNext()) {
                    k = last.hashCode() & sizeMask;
                    if (k == lastIdx) continue;
                    lastIdx = k;
                    lastRun = last;
                }
                newTable[lastIdx] = lastRun;
                for (RightTupleList p = e; p != lastRun; p = (RightTupleList)p.getNext()) {
                    k = p.hashCode() & sizeMask;
                    RightTupleList n = newTable[k];
                    newTable[k] = new RightTupleList(p, n);
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.tupleCount != 0) {
                this.lock();
                try {
                    RightTupleList[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.tupleCount = 0;
                    this.keyCount = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }
}

