/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Stack;
import javax.activation.MimeType;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.util.EntityTag;

public class JSONStream {
    private final Writer writer;
    private int depth = 0;
    private Stack<Boolean> sepstack = new Stack();

    private void pushStack() {
        this.sepstack.push(true);
    }

    private boolean isStart() {
        boolean b = this.sepstack.peek();
        if (b) {
            this.sepstack.set(this.sepstack.size() - 1, false);
        }
        return b;
    }

    private void popStack() {
        this.sepstack.pop();
    }

    public JSONStream(Writer writer) {
        this.writer = writer;
    }

    private void inc() {
        ++this.depth;
    }

    private void dec() {
        --this.depth;
    }

    private void writeIndent() throws IOException {
        for (int n = 0; n < this.depth; ++n) {
            this.writer.write(32);
        }
        this.writer.flush();
    }

    private void writeNewLine() throws IOException {
        this.writer.write(10);
        this.writer.flush();
    }

    public void startObject() throws IOException {
        this.writer.write(123);
        this.inc();
        this.pushStack();
        this.writer.flush();
    }

    public void endObject() throws IOException {
        this.popStack();
        this.dec();
        this.writeNewLine();
        this.writeIndent();
        this.writer.write(125);
        this.writer.flush();
    }

    public void startArray() throws IOException {
        this.writer.write(91);
        this.inc();
        this.writer.flush();
    }

    public void endArray() throws IOException {
        this.dec();
        this.writeNewLine();
        this.writeIndent();
        this.writer.write(93);
        this.writer.flush();
    }

    public void writeSeparator() throws IOException {
        this.writer.write(44);
        this.writer.flush();
    }

    private void writeColon() throws IOException {
        this.writer.write(58);
        this.writer.flush();
    }

    public void writeQuoted(String value) throws IOException {
        if (value != null) {
            this.writer.write(34);
            this.writer.write(JSONStream.escape(value));
            this.writer.write(34);
            this.writer.flush();
        }
    }

    public void writeField(String name) throws IOException {
        if (!this.isStart()) {
            this.writeSeparator();
        }
        this.writeNewLine();
        this.writeIndent();
        this.writeQuoted(name);
        this.writeColon();
    }

    public void writeField(String name, Date value) throws IOException {
        if (value != null) {
            this.writeField(name, AtomDate.format((Date)value));
        }
    }

    public void writeField(String name, IRI value) throws IOException {
        if (value != null) {
            this.writeField(name, value.toASCIIString());
        }
    }

    public void writeField(String name, MimeType value) throws IOException {
        if (value != null) {
            this.writeField(name, value.toString());
        }
    }

    public void writeField(String name, EntityTag value) throws IOException {
        if (value != null) {
            this.writeField(name, value.toString());
        }
    }

    public void writeField(String name, String value) throws IOException {
        if (value != null) {
            this.writeField(name);
            this.writeQuoted(value);
        }
    }

    public void writeField(String name, Number value) throws IOException {
        if (value != null) {
            this.writeField(name);
            this.writer.write(value.toString());
        }
        this.writer.flush();
    }

    public void writeField(String name, Boolean value) throws IOException {
        if (value != null) {
            this.writeField(name);
            this.writer.write(value.toString());
        }
        this.writer.flush();
    }

    private static String escape(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        char[] chars = value.toCharArray();
        char b = '\u0000';
        String t = null;
        for (char c : chars) {
            switch (c) {
                case '\"': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        buf.append('\\');
                    }
                    buf.append(c);
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\f': {
                    buf.append("\\f");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        t = "000" + Integer.toHexString(c);
                        buf.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    buf.append(c);
                }
            }
            b = c;
        }
        return buf.toString();
    }
}

