/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.drools.container.spring.beans.GridBeanFactory;
import org.drools.grid.remote.mina.MinaAcceptorFactoryService;
import org.drools.grid.service.directory.impl.JpaWhitePages;
import org.drools.grid.service.directory.impl.WhitePagesImpl;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GridDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String EMF_ATTRIBUTE = "entity-manager-factory";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(GridBeanFactory.class);
        String id = element.getAttribute("id");
        factory.addPropertyValue("id", (Object)id);
        int length = element.getChildNodes().getLength();
        for (int i = 0; i < length; ++i) {
            Node n = element.getChildNodes().item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if ("core-services".equals(e.getLocalName())) {
                String ref = e.getAttribute("ref");
                Element nestedElm = this.getFirstElement(e.getChildNodes());
                if (StringUtils.hasText((String)ref)) {
                    factory.addPropertyReference("coreServices", ref);
                    continue;
                }
                if (nestedElm != null) {
                    factory.addPropertyValue("coreServices", parserContext.getDelegate().parsePropertySubElement(nestedElm, null, null));
                    continue;
                }
                throw new IllegalArgumentException("set-global must either specify a 'ref' attribute or have a nested bean");
            }
            if ("whitepages".equals(e.getLocalName())) {
                Element persistenceElm = DomUtils.getChildElementByTagName((Element)e, (String)"jpa-persistence");
                if (persistenceElm != null) {
                    BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(JpaWhitePages.class);
                    Element emf = DomUtils.getChildElementByTagName((Element)persistenceElm, (String)EMF_ATTRIBUTE);
                    String ref = emf.getAttribute("ref");
                    beanBuilder.addConstructorArgReference(ref);
                    factory.addPropertyValue("whitePages", (Object)beanBuilder.getBeanDefinition());
                    continue;
                }
                String ref = e.getAttribute("ref");
                Element nestedElm = this.getFirstElement(e.getChildNodes());
                if (StringUtils.hasText((String)ref)) {
                    factory.addPropertyReference("whitePages", ref);
                    continue;
                }
                if (nestedElm != null) {
                    factory.addPropertyValue("whitePages", parserContext.getDelegate().parsePropertySubElement(nestedElm, null, null));
                    continue;
                }
                factory.addPropertyValue("whitePages", (Object)new WhitePagesImpl());
                continue;
            }
            if (!"socket-service".equals(e.getLocalName())) continue;
            String acceptor = e.getAttribute("acceptor");
            String ip = e.getAttribute("ip");
            MinaAcceptorFactoryService acc = null;
            if (StringUtils.hasText((String)acceptor) && "mina".equals(acceptor)) {
                acc = new MinaAcceptorFactoryService();
            }
            if (acc == null) {
                acc = new MinaAcceptorFactoryService();
            }
            if (!StringUtils.hasText((String)ip)) {
                try {
                    ip = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e1) {
                    throw new RuntimeException("socket-service did not specify an ip address and one could not be determined", e1);
                }
            }
            if (!StringUtils.hasText((String)ip)) {
                throw new RuntimeException("socket-service did not specify an ip address and one could not be determined");
            }
            BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.genericBeanDefinition(GridBeanFactory.SocketServiceConfiguration.class);
            beanBuilder.addPropertyValue("ip", (Object)ip);
            beanBuilder.addPropertyValue("acceptor", (Object)acceptor);
            ArrayList<String[]> services = new ArrayList<String[]>();
            int serviceLength = e.getChildNodes().getLength();
            for (int j = 0; j < serviceLength; ++j) {
                Node e2 = e.getChildNodes().item(j);
                if (!(e2 instanceof Element) || !"service".equals(((Element)e2).getLocalName())) continue;
                Element se = (Element)e2;
                String name = se.getAttribute("name");
                String port = se.getAttribute("port");
                services.add(new String[]{name, port});
            }
            beanBuilder.addPropertyValue("services", services);
            factory.addPropertyValue("socketServiceConfiguration", (Object)beanBuilder.getBeanDefinition());
        }
        return factory.getBeanDefinition();
    }

    public void emptyAttributeCheck(String element, String attributeName, String attribute) {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new IllegalArgumentException("<" + element + "> requires a '" + attributeName + "' attribute");
        }
    }

    private Element getFirstElement(NodeList list) {
        int lengthj = list.getLength();
        for (int j = 0; j < lengthj; ++j) {
            if (!(list.item(j) instanceof Element)) continue;
            return (Element)list.item(j);
        }
        return null;
    }
}

