/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.converter.jaxb.NonXmlCharFilterer;

public class FilteringXmlStreamWriter
implements XMLStreamWriter {
    NonXmlCharFilterer nonXmlCharFilterer = new NonXmlCharFilterer();
    private XMLStreamWriter writer;

    public FilteringXmlStreamWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        String filteredValue = this.nonXmlCharFilterer.filter(value);
        this.writer.writeAttribute(prefix, namespaceURI, localName, filteredValue);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        String filteredValue = this.nonXmlCharFilterer.filter(value);
        this.writer.writeAttribute(namespaceURI, localName, filteredValue);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        String filteredValue = this.nonXmlCharFilterer.filter(value);
        this.writer.writeAttribute(localName, filteredValue);
    }

    public void writeCData(String data) throws XMLStreamException {
        String filteredData = this.nonXmlCharFilterer.filter(data);
        this.writer.writeCData(filteredData);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.nonXmlCharFilterer.filter(text, start, len);
        this.writer.writeCharacters(text, start, len);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        String filteredText = this.nonXmlCharFilterer.filter(text);
        this.writer.writeCharacters(filteredText);
    }

    public void writeComment(String data) throws XMLStreamException {
        String filteredData = this.nonXmlCharFilterer.filter(data);
        this.writer.writeComment(filteredData);
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(localName);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writer.writeStartElement(localName);
    }
}

