/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class JaxbDataFormat
implements DataFormat {
    private JAXBContext context;
    private String contextPath;
    private boolean prettyPrint = true;
    private boolean ignoreJAXBElement = true;
    private boolean filterNonXmlChars;
    private String encoding;
    private QName partNamespace;
    private String partClass;
    private Class partialClass;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        try {
            String charset;
            Marshaller marshaller = this.getContext().createMarshaller();
            if (this.isPrettyPrint()) {
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            if ((charset = (String)exchange.getProperty("CamelCharsetName", String.class)) == null) {
                charset = this.encoding;
            }
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", (Object)charset);
            }
            this.marshal(exchange, graph, stream, marshaller);
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    void marshal(Exchange exchange, Object graph, OutputStream stream, Marshaller marshaller) throws XMLStreamException, JAXBException {
        Object e = graph;
        if (this.getPartClass() != null && this.getPartNamespace() != null) {
            e = new JAXBElement(this.getPartNamespace(), this.getPartialClass(exchange), graph);
        }
        if (this.needFiltering(exchange)) {
            marshaller.marshal(e, (XMLStreamWriter)this.createFilteringWriter(stream));
        } else {
            marshaller.marshal(e, stream);
        }
    }

    private FilteringXmlStreamWriter createFilteringWriter(OutputStream stream) throws XMLStreamException, FactoryConfigurationError {
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream);
        FilteringXmlStreamWriter filteringWriter = new FilteringXmlStreamWriter(writer);
        return filteringWriter;
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        try {
            Object answer;
            Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
            if (this.getPartClass() != null) {
                StreamSource source = this.needFiltering(exchange) ? new StreamSource(this.createNonXmlFilterReader(exchange, stream)) : new StreamSource(stream);
                answer = unmarshaller.unmarshal((Source)source, this.getPartialClass(exchange));
            } else if (this.needFiltering(exchange)) {
                NonXmlFilterReader reader = this.createNonXmlFilterReader(exchange, stream);
                answer = unmarshaller.unmarshal((Reader)reader);
            } else {
                answer = unmarshaller.unmarshal(stream);
            }
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = ((JAXBElement)answer).getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw IOHelper.createIOException((Throwable)e);
        }
    }

    private NonXmlFilterReader createNonXmlFilterReader(Exchange exchange, InputStream stream) throws UnsupportedEncodingException {
        return new NonXmlFilterReader(new InputStreamReader(stream, IOConverter.getCharsetName((Exchange)exchange)));
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange == null ? this.filterNonXmlChars : (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)this.filterNonXmlChars, Boolean.class);
    }

    private synchronized Class getPartialClass(Exchange exchange) {
        if (this.partialClass == null) {
            this.partialClass = exchange.getContext().getClassResolver().resolveClass(this.getPartClass());
        }
        return this.partialClass;
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public synchronized JAXBContext getContext() throws JAXBException {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(boolean filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final QName getPartNamespace() {
        return this.partNamespace;
    }

    public final void setPartNamespace(QName partNamespace) {
        this.partNamespace = partNamespace;
    }

    public final String getPartClass() {
        return this.partClass;
    }

    public final void setPartClass(String partClass) {
        this.partClass = partClass;
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.contextPath != null) {
            return JAXBContext.newInstance((String)this.contextPath);
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }
}

