/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AbstractAegisIoImpl;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisXMLStreamDataWriter
extends AbstractAegisIoImpl
implements AegisWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(AegisXMLStreamDataWriter.class);

    AegisXMLStreamDataWriter(AegisContext globalContext) {
        super(globalContext);
    }

    @Override
    public void write(Object obj, QName elementName, boolean optional, XMLStreamWriter output, Type aegisType) throws Exception {
        if (obj == null && aegisType == null && !optional) {
            Message message = new Message("WRITE_NEEDS_TYPE", LOG, new Object[0]);
            throw new DatabindingException(message);
        }
        if (obj != null && aegisType == null) {
            aegisType = TypeUtil.getWriteType(this.aegisContext, obj, aegisType);
        }
        if (obj == null) {
            if (optional) {
                return;
            }
            if (aegisType.isNillable() && aegisType.isWriteOuter()) {
                ElementWriter writer = new ElementWriter(output);
                MessageWriter w2 = writer.getElementWriter(elementName);
                w2.writeXsiNil();
                w2.close();
                return;
            }
        }
        ElementWriter writer = new ElementWriter(output);
        MessageWriter w2 = writer.getElementWriter(elementName);
        if (this.getContext().isWriteXsiTypes() && aegisType != null && aegisType.getSchemaType() != null) {
            w2.writeXsiType(aegisType.getSchemaType());
        }
        aegisType.writeObject(obj, w2, this.context);
        w2.close();
    }
}

