/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientDistributedTask;
import com.hazelcast.impl.ClientRequestHandler;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.query.Predicate;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ClientService {
    private final Node node;
    private final Map<Connection, ClientEndpoint> mapClientEndpoints = new HashMap<Connection, ClientEndpoint>();
    private final ClientOperationHandler[] clientOperationHandlers = new ClientOperationHandler[300];

    public ClientService(Node node) {
        this.node = node;
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT.getValue()] = new MapPutHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_MULTI.getValue()] = new MapPutMultiHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT.getValue()] = new MapPutIfAbsentHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_GET.getValue()] = new MapGetHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE.getValue()] = new MapRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME.getValue()] = new MapRemoveIfSameHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI.getValue()] = new MapRemoveMultiHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_EVICT.getValue()] = new MapEvictHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL.getValue()] = new MapReplaceIfNotNullHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME.getValue()] = new MapReplaceIfSameHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_SIZE.getValue()] = new MapSizeHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY.getValue()] = new GetMapEntryHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_LOCK.getValue()] = new MapLockHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_UNLOCK.getValue()] = new MapUnlockHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_CONTAINS.getValue()] = new MapContainsHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE.getValue()] = new MapContainsValueHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST.getValue()] = new ListAddHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ADD_TO_SET.getValue()] = new SetAddHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM.getValue()] = new MapItemRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS.getValue()] = new MapIterateKeysHandler();
        this.clientOperationHandlers[ClusterOperation.CONCURRENT_MAP_VALUE_COUNT.getValue()] = new MapValueCountHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_OFFER.getValue()] = new QueueOfferHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_POLL.getValue()] = new QueuePollHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_REMOVE.getValue()] = new QueueRemoveHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_PEEK.getValue()] = new QueuePeekHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_SIZE.getValue()] = new QueueSizeHandler();
        this.clientOperationHandlers[ClusterOperation.BLOCKING_QUEUE_PUBLISH.getValue()] = new QueuePublishHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_BEGIN.getValue()] = new TransactionBeginHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_COMMIT.getValue()] = new TransactionCommitHandler();
        this.clientOperationHandlers[ClusterOperation.TRANSACTION_ROLLBACK.getValue()] = new TransactionRollbackHandler();
        this.clientOperationHandlers[ClusterOperation.ADD_LISTENER.getValue()] = new AddListenerHandler();
        this.clientOperationHandlers[ClusterOperation.REMOVE_LISTENER.getValue()] = new RemoveListenerHandler();
        this.clientOperationHandlers[ClusterOperation.REMOTELY_PROCESS.getValue()] = new RemotelyProcessHandler();
        this.clientOperationHandlers[ClusterOperation.DESTROY.getValue()] = new DestroyHandler();
        this.clientOperationHandlers[ClusterOperation.GET_ID.getValue()] = new GetIdHandler();
        this.clientOperationHandlers[ClusterOperation.ADD_INDEX.getValue()] = new AddIndexHandler();
        this.clientOperationHandlers[ClusterOperation.NEW_ID.getValue()] = new NewIdHandler();
        this.clientOperationHandlers[ClusterOperation.EXECUTE.getValue()] = new ExecutorServiceHandler();
        this.clientOperationHandlers[ClusterOperation.GET_INSTANCES.getValue()] = new GetInstancesHandler();
        this.clientOperationHandlers[ClusterOperation.GET_MEMBERS.getValue()] = new GetMembersHandler();
        this.clientOperationHandlers[ClusterOperation.GET_CLUSTER_TIME.getValue()] = new GetClusterTimeHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_AUTHENTICATE.getValue()] = new ClientAuthenticateHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_ADD_INSTANCE_LISTENER.getValue()] = new ClientAddInstanceListenerHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_ADD_MEMBERSHIP_LISTENER.getValue()] = new ClientAddMembershipListenerHandler();
        this.clientOperationHandlers[ClusterOperation.CLIENT_GET_PARTITIONS.getValue()] = new GetPartitionsHandler();
    }

    public void handle(Packet packet) {
        ClientEndpoint clientEndpoint = this.getClientEndpoint(packet.conn);
        CallContext callContext = clientEndpoint.getCallContext(packet.threadId);
        ClientRequestHandler clientRequestHandler = new ClientRequestHandler(this.node, packet, callContext, this.clientOperationHandlers);
        if (!packet.operation.equals((Object)ClusterOperation.CONCURRENT_MAP_UNLOCK)) {
            this.node.executorManager.getClientExecutorService().executeOrderedRunnable(callContext.getThreadId(), clientRequestHandler);
        } else {
            this.node.executorManager.executeNow(clientRequestHandler);
        }
    }

    public ClientEndpoint getClientEndpoint(Connection conn) {
        ClientEndpoint clientEndpoint = this.mapClientEndpoints.get(conn);
        if (clientEndpoint == null) {
            clientEndpoint = new ClientEndpoint(conn);
            this.mapClientEndpoints.put(conn, clientEndpoint);
        }
        return clientEndpoint;
    }

    public void reset() {
        this.mapClientEndpoints.clear();
    }

    private abstract class ClientTransactionOperationHandler
    extends ClientOperationHandler {
        private ClientTransactionOperationHandler() {
        }

        public abstract void processTransactionOp(Transaction var1);

        public void processCall(Node node, Packet packet) {
            Transaction transaction = node.factory.getTransaction();
            this.processTransactionOp(transaction);
        }
    }

    private abstract class ClientCollectionOperationHandler
    extends ClientOperationHandler {
        private ClientCollectionOperationHandler() {
        }

        public abstract void doMapOp(Node var1, Packet var2);

        public abstract void doListOp(Node var1, Packet var2);

        public abstract void doSetOp(Node var1, Packet var2);

        public abstract void doMultiMapOp(Node var1, Packet var2);

        public abstract void doQueueOp(Node var1, Packet var2);

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.LIST)) {
                this.doListOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.SET)) {
                this.doSetOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                this.doMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                this.doMultiMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.QUEUE)) {
                this.doQueueOp(node, packet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientQueueOperationHandler
    extends ClientOperationHandler {
        private ClientQueueOperationHandler() {
        }

        public abstract Data processQueueOp(IQueue<Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processQueueOp(queue, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientMapOperationHandler
    extends ClientOperationHandler {
        private ClientMapOperationHandler() {
        }

        public abstract Data processMapOp(IMap<Object, Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    public abstract class ClientOperationHandler {
        public abstract void processCall(Node var1, Packet var2);

        public void handle(Node node, Packet packet) {
            this.processCall(node, packet);
            this.sendResponse(packet);
        }

        protected void sendResponse(Packet request) {
            request.lockAddress = null;
            request.operation = ClusterOperation.RESPONSE;
            request.responseType = (byte)3;
            if (request.conn != null && request.conn.live()) {
                request.conn.getWriteHandler().enqueueSocketWritable(request);
            }
        }
    }

    private class MapItemRemoveHandler
    extends ClientOperationHandler {
        private MapItemRemoveHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection collection = (Collection)node.factory.getOrCreateProxyByName(packet.name);
            Data value = IOUtil.toData(collection.remove(packet.getKeyData()));
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    private class SetAddHandler
    extends ClientOperationHandler {
        private SetAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ISet list = (ISet)node.factory.getOrCreateProxyByName(packet.name);
            Boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class ListAddHandler
    extends ClientOperationHandler {
        private ListAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IList list = (IList)node.factory.getOrCreateProxyByName(packet.name);
            Boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class RemoveListenerHandler
    extends ClientOperationHandler {
        private RemoveListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                if (packet.getKeyData() == null) {
                    map.removeEntryListener(clientEndpoint);
                } else {
                    map.removeEntryListener(clientEndpoint, packet.getKeyData());
                }
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
                topic.removeMessageListener(clientEndpoint.messageListeners.remove(packet.name));
            }
        }
    }

    private class AddListenerHandler
    extends ClientOperationHandler {
        private AddListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            boolean includeValue;
            final ClientEndpoint clientEndpoint = node.clientService.getClientEndpoint(packet.conn);
            boolean bl = includeValue = (int)packet.longValue == 1;
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.addThisAsListener(map, packet.getKeyData(), includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.LIST) || BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.SET)) {
                FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
                MProxy map = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
                clientEndpoint.addThisAsListener(map, null, includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
                final String packetName = packet.name;
                MessageListener<Object> messageListener = new MessageListener<Object>(){

                    @Override
                    public void onMessage(Object msg) {
                        Packet p = new Packet();
                        p.set(packetName, ClusterOperation.EVENT, msg, null);
                        clientEndpoint.sendPacket(p);
                    }
                };
                topic.addMessageListener(messageListener);
                clientEndpoint.messageListeners.put(packet.name, messageListener);
            }
            packet.clearForResponse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterateKeysHandler
    extends ClientCollectionOperationHandler {
        private MapIterateKeysHandler() {
        }

        public Data getMapKeys(IMap<Object, Object> map, Data key, Data value, Collection<Data> collection) {
            ConcurrentMapManager.Entries entries = null;
            if (value == null) {
                entries = (ConcurrentMapManager.Entries)map.keySet();
            } else {
                Predicate p = (Predicate)IOUtil.toObject(value);
                entries = (ConcurrentMapManager.Entries)map.keySet(p);
            }
            List<Map.Entry> list = entries.getKeyValues();
            Keys keys = new Keys(collection);
            for (Map.Entry obj : list) {
                KeyValue entry = (KeyValue)obj;
                keys.addKey(entry.getKeyData());
            }
            return IOUtil.toData(keys);
        }

        @Override
        public void doListOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new ArrayList<Data>()));
        }

        @Override
        public void doMapOp(Node node, Packet packet) {
            packet.setValue(this.getMapKeys((IMap)node.factory.getOrCreateProxyByName(packet.name), packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doSetOp(Node node, Packet packet) {
            FactoryImpl.CollectionProxyImpl collectionProxy = (FactoryImpl.CollectionProxyImpl)node.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = ((FactoryImpl.CollectionProxyImpl.CollectionProxyReal)collectionProxy.getBase()).mapProxy;
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doMultiMapOp(Node node, Packet packet) {
            FactoryImpl.MultiMapProxy multiMap = (FactoryImpl.MultiMapProxy)node.factory.getOrCreateProxyByName(packet.name);
            FactoryImpl.MultiMapProxy.MultiMapBase base = multiMap.getBase();
            MProxy mapProxy = base.mapProxy;
            Data value = this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>());
            packet.clearForResponse();
            packet.setValue(value);
        }

        @Override
        public void doQueueOp(Node node, Packet packet) {
            IQueue queue = (IQueue)node.factory.getOrCreateProxyByName(packet.name);
        }
    }

    private class TransactionRollbackHandler
    extends ClientTransactionOperationHandler {
        private TransactionRollbackHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.rollback();
        }
    }

    private class TransactionCommitHandler
    extends ClientTransactionOperationHandler {
        private TransactionCommitHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.commit();
        }
    }

    private class TransactionBeginHandler
    extends ClientTransactionOperationHandler {
        private TransactionBeginHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.begin();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapUnlockHandler
    extends ClientMapOperationHandler {
        private MapUnlockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.unlock(key);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapLockHandler
    extends ClientMapOperationHandler {
        private MapLockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            throw new RuntimeException("Shouldn't invoke this method");
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            long timeout = packet.timeout;
            Data value = null;
            if (timeout == -1L) {
                map.lock(packet.getKeyData());
                value = null;
            } else {
                value = timeout == 0L ? IOUtil.toData(map.tryLock(packet.getKeyData())) : IOUtil.toData(map.tryLock(packet.getKeyData(), timeout, (TimeUnit)((Object)IOUtil.toObject(packet.getValueData()))));
            }
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetMapEntryHandler
    extends ClientMapOperationHandler {
        private GetMapEntryHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getMapEntry(key));
        }
    }

    private class MapSizeHandler
    extends ClientCollectionOperationHandler {
        private MapSizeHandler() {
        }

        public void doListOp(Node node, Packet packet) {
            IList list = (IList)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(list.size()));
        }

        public void doMapOp(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(map.size()));
        }

        public void doSetOp(Node node, Packet packet) {
            ISet set = (ISet)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(set.size()));
        }

        public void doMultiMapOp(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.size()));
        }

        public void doQueueOp(Node node, Packet packet) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapContainsValueHandler
    extends ClientOperationHandler {
        private MapContainsValueHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.containsValue(value));
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsValue(packet.getValueData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
                if (packet.getKeyData() != null && packet.getKeyData().size() > 0) {
                    packet.setValue(IOUtil.toData(multiMap.containsEntry(packet.getKeyData(), packet.getValueData())));
                } else {
                    packet.setValue(IOUtil.toData(multiMap.containsValue(packet.getValueData())));
                }
            }
        }
    }

    private class MapContainsHandler
    extends ClientOperationHandler {
        private MapContainsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsKey(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.LIST) || instanceType.equals((Object)Instance.InstanceType.SET)) {
                Collection collection = (Collection)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(collection.contains(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(multiMap.containsKey(packet.getKeyData())));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfSameHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            Object[] arr = (Object[])IOUtil.toObject(value);
            return IOUtil.toData(map.replace(key, arr[0], arr[1]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfNotNullHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfNotNullHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.replace(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEvictHandler
    extends ClientMapOperationHandler {
        private MapEvictHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.evict(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveIfSameHandler
    extends ClientMapOperationHandler {
        private MapRemoveIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.remove(key, value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveHandler
    extends ClientMapOperationHandler {
        private MapRemoveHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.remove(key);
        }
    }

    private class MapGetHandler
    extends ClientOperationHandler {
        private MapGetHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
                packet.setValue((Data)map.get(packet.getKeyData()));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                FactoryImpl.MultiMapProxy multiMap = (FactoryImpl.MultiMapProxy)node.factory.getOrCreateProxyByName(packet.name);
                FactoryImpl.MultiMapProxy.MultiMapBase base = multiMap.getBase();
                MProxy mapProxy = base.mapProxy;
                packet.setValue((Data)mapProxy.get(packet.getKeyData()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutIfAbsentHandler
    extends ClientOperationHandler {
        private MapPutIfAbsentHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            if (ttl < 0L) {
                return (Data)map.putIfAbsent(key, v);
            }
            return (Data)map.putIfAbsent(key, v, ttl, TimeUnit.MILLISECONDS);
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)node.factory.getOrCreateProxyByName(packet.name);
            long ttl = packet.timeout;
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData(), ttl);
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutHandler
    extends ClientMapOperationHandler {
        private MapPutHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            MProxy mproxy = (MProxy)map;
            if (((ClientService)ClientService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                return (Data)map.put(key, IOUtil.toObject(value));
            }
            return (Data)map.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddIndexHandler
    extends ClientMapOperationHandler {
        private AddIndexHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.addIndex((String)IOUtil.toObject(key), (Boolean)IOUtil.toObject(value));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetIdHandler
    extends ClientMapOperationHandler {
        private GetIdHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getId());
        }
    }

    private class ClientAddMembershipListenerHandler
    extends ClientOperationHandler {
        private ClientAddMembershipListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint endPoint = ClientService.this.getClientEndpoint(packet.conn);
            node.factory.getCluster().addMembershipListener(endPoint);
        }
    }

    private class ClientAddInstanceListenerHandler
    extends ClientOperationHandler {
        private ClientAddInstanceListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint endPoint = ClientService.this.getClientEndpoint(packet.conn);
            node.factory.addInstanceListener(endPoint);
        }
    }

    private class ClientAuthenticateHandler
    extends ClientOperationHandler {
        private ClientAuthenticateHandler() {
        }

        public void processCall(Node node, Packet packet) {
            String groupName = node.factory.getConfig().getGroupConfig().getName();
            String pass = node.factory.getConfig().getGroupConfig().getPassword();
            Boolean value = groupName.equals(IOUtil.toObject(packet.getKeyData())) && pass.equals(IOUtil.toObject(packet.getValueData()));
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class GetClusterTimeHandler
    extends ClientOperationHandler {
        private GetClusterTimeHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = node.factory.getCluster();
            long clusterTime = cluster.getClusterTime();
            packet.setValue(IOUtil.toData(clusterTime));
        }
    }

    public static class PartitionImpl
    implements Partition,
    HazelcastInstanceAware,
    DataSerializable,
    Comparable {
        int partitionId;
        MemberImpl owner;

        PartitionImpl(int partitionId, MemberImpl owner) {
            this.partitionId = partitionId;
            this.owner = owner;
        }

        public PartitionImpl() {
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            return this.owner;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            if (this.owner != null) {
                this.owner.setHazelcastInstance(hazelcastInstance);
            }
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            boolean hasOwner = this.owner != null;
            out.writeBoolean(hasOwner);
            if (hasOwner) {
                this.owner.writeData(out);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.partitionId = in.readInt();
            boolean hasOwner = in.readBoolean();
            if (hasOwner) {
                this.owner = new MemberImpl();
                this.owner.readData(in);
            }
        }

        public int compareTo(Object o) {
            PartitionImpl partition = (PartitionImpl)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionImpl partition = (PartitionImpl)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.owner;
        }
    }

    private class GetPartitionsHandler
    extends ClientOperationHandler {
        private GetPartitionsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            PartitionService partitionService = node.factory.getPartitionService();
            Set<Partition> partitions = partitionService.getPartitions();
            LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
            for (Partition partition : partitions) {
                setData.add(IOUtil.toData(new PartitionImpl(partition.getPartitionId(), (MemberImpl)partition.getOwner())));
            }
            Keys keys = new Keys(setData);
            packet.setValue(IOUtil.toData(keys));
        }
    }

    private class GetMembersHandler
    extends ClientOperationHandler {
        private GetMembersHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = node.factory.getCluster();
            Set<Member> members = cluster.getMembers();
            LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
            if (members != null) {
                for (Member member : members) {
                    setData.add(IOUtil.toData(member));
                }
                Keys keys = new Keys(setData);
                packet.setValue(IOUtil.toData(keys));
            }
        }
    }

    private class GetInstancesHandler
    extends ClientOperationHandler {
        private GetInstancesHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection<Instance> instances = node.factory.getInstances();
            Object[] instanceIds = new Object[instances.size()];
            int counter = 0;
            for (Instance instance : instances) {
                Object key;
                Object id = instance.getId();
                if (id instanceof FactoryImpl.ProxyKey && (key = ((FactoryImpl.ProxyKey)id).getKey()) instanceof Instance) {
                    id = key.toString();
                }
                instanceIds[counter] = id;
                ++counter;
            }
            packet.setValue(IOUtil.toData(instanceIds));
        }
    }

    private class ExecutorServiceHandler
    extends ClientOperationHandler {
        private ExecutorServiceHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ExecutorService executorService = node.factory.getExecutorService();
            try {
                ClientDistributedTask cdt = (ClientDistributedTask)IOUtil.toObject(packet.getKeyData());
                DistributedTask task = cdt.getKey() != null ? new DistributedTask(cdt.getCallable(), cdt.getKey()) : (cdt.getMember() != null ? new DistributedTask(cdt.getCallable(), cdt.getMember()) : (cdt.getMembers() != null ? new MultiTask(cdt.getCallable(), cdt.getMembers()) : new DistributedTask(cdt.getCallable())));
                executorService.execute(task);
                Object result = task.get();
                packet.setValue(IOUtil.toData(result));
            }
            catch (InterruptedException e) {
                return;
            }
            catch (ExecutionException e) {
                packet.setValue(IOUtil.toData(e));
            }
        }
    }

    private class MapRemoveMultiHandler
    extends ClientOperationHandler {
        private MapRemoveMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            if (packet.getValueData() == null || packet.getValueData().size() == 0) {
                FactoryImpl.MultiMapProxy mmProxy = (FactoryImpl.MultiMapProxy)multiMap;
                FactoryImpl.MultiMapProxy.MultiMapBase base = mmProxy.getBase();
                MProxy mapProxy = base.mapProxy;
                packet.setValue((Data)mapProxy.remove(packet.getKeyData()));
            } else {
                packet.setValue(IOUtil.toData(multiMap.remove(packet.getKeyData(), packet.getValueData())));
            }
        }
    }

    private class MapValueCountHandler
    extends ClientOperationHandler {
        private MapValueCountHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.valueCount(packet.getKeyData())));
        }
    }

    private class MapPutMultiHandler
    extends ClientOperationHandler {
        private MapPutMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.put(packet.getKeyData(), packet.getValueData())));
        }
    }

    private class NewIdHandler
    extends ClientOperationHandler {
        private NewIdHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IdGenerator idGen = (IdGenerator)node.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(idGen.newId()));
        }
    }

    private class DestroyHandler
    extends ClientOperationHandler {
        private DestroyHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance instance = (Instance)node.factory.getOrCreateProxyByName(packet.name);
            instance.destroy();
        }
    }

    private class RemotelyProcessHandler
    extends ClientOperationHandler {
        private RemotelyProcessHandler() {
        }

        public void processCall(Node node, Packet packet) {
            node.clusterService.enqueuePacket(packet);
        }

        protected void sendResponse(Packet request) {
        }
    }

    private class QueuePublishHandler
    extends ClientOperationHandler {
        private QueuePublishHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ITopic topic = (ITopic)node.factory.getOrCreateProxyByName(packet.name);
            topic.publish(packet.getKeyData());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueSizeHandler
    extends ClientQueueOperationHandler {
        private QueueSizeHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return IOUtil.toData(queue.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePeekHandler
    extends ClientQueueOperationHandler {
        private QueuePeekHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return (Data)queue.peek();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueRemoveHandler
    extends ClientQueueOperationHandler {
        private QueueRemoveHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return (Data)queue.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePollHandler
    extends ClientQueueOperationHandler {
        private QueuePollHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            try {
                long millis = (Long)IOUtil.toObject(value);
                if (millis == -1L) {
                    return (Data)queue.take();
                }
                if (millis == 0L) {
                    return (Data)queue.poll();
                }
                return (Data)queue.poll(millis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueOfferHandler
    extends ClientQueueOperationHandler {
        private QueueOfferHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            long millis = (Long)IOUtil.toObject(value);
            try {
                if (millis == -1L) {
                    queue.put(key);
                    return IOUtil.toData(true);
                }
                if (millis == 0L) {
                    return IOUtil.toData(queue.offer(key));
                }
                return IOUtil.toData(queue.offer(key, (Long)IOUtil.toObject(value), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClientEndpoint
    implements EntryListener,
    InstanceListener,
    MembershipListener {
        final Connection conn;
        private final Map<Integer, CallContext> callContexts = new HashMap<Integer, CallContext>();
        final ConcurrentMap<String, ConcurrentMap<Object, EntryEvent>> listeneds = new ConcurrentHashMap<String, ConcurrentMap<Object, EntryEvent>>();
        final Map<String, MessageListener<Object>> messageListeners = new HashMap<String, MessageListener<Object>>();

        ClientEndpoint(Connection conn) {
            this.conn = conn;
        }

        public CallContext getCallContext(int threadId) {
            CallContext context = this.callContexts.get(threadId);
            if (context == null) {
                int locallyMappedThreadId = ThreadContext.get().createNewThreadId();
                context = new CallContext(locallyMappedThreadId, true);
                this.callContexts.put(threadId, context);
            }
            return context;
        }

        public void addThisAsListener(IMap map, Data key, boolean includeValue) {
            if (key == null) {
                map.addEntryListener(this, includeValue);
            } else {
                map.addEntryListener(this, key, includeValue);
            }
        }

        private ConcurrentMap<Object, EntryEvent> getEventProcessedLog(String name) {
            ConcurrentHashMap eventProcessedLog = (ConcurrentHashMap)this.listeneds.get(name);
            if (eventProcessedLog == null) {
                eventProcessedLog = new ConcurrentHashMap();
                this.listeneds.putIfAbsent(name, eventProcessedLog);
            }
            return eventProcessedLog;
        }

        public int hashCode() {
            return this.conn.hashCode();
        }

        public void entryAdded(EntryEvent event) {
            this.processEvent(event);
        }

        public void entryEvicted(EntryEvent event) {
            this.processEvent(event);
        }

        public void entryRemoved(EntryEvent event) {
            this.processEvent(event);
        }

        public void entryUpdated(EntryEvent event) {
            this.processEvent(event);
        }

        @Override
        public void instanceCreated(InstanceEvent event) {
            this.processEvent(event);
        }

        @Override
        public void instanceDestroyed(InstanceEvent event) {
            this.processEvent(event);
        }

        @Override
        public void memberAdded(MembershipEvent membershipEvent) {
            this.processEvent(membershipEvent);
        }

        @Override
        public void memberRemoved(MembershipEvent membershipEvent) {
            this.processEvent(membershipEvent);
        }

        private void processEvent(MembershipEvent membershipEvent) {
            Packet packet = this.createMembershipEventPacket(membershipEvent);
            this.sendPacket(packet);
        }

        private void processEvent(InstanceEvent event) {
            Packet packet = this.createInstanceEventPacket(event);
            this.sendPacket(packet);
        }

        private void processEvent(EntryEvent event) {
            Object key = event.getKey();
            ConcurrentMap<Object, EntryEvent> eventProcessedLog = this.getEventProcessedLog(event.getName());
            if (eventProcessedLog.get(key) != null && eventProcessedLog.get(key) == event) {
                return;
            }
            eventProcessedLog.put(key, event);
            Packet packet = this.createEntryEventPacket(event);
            this.sendPacket(packet);
        }

        private void sendPacket(Packet packet) {
            if (this.conn != null && this.conn.live()) {
                this.conn.getWriteHandler().enqueueSocketWritable(packet);
            }
        }

        private Packet createEntryEventPacket(EntryEvent event) {
            Packet packet = new Packet();
            BaseManager.EventTask eventTask = (BaseManager.EventTask)event;
            packet.set(event.getName(), ClusterOperation.EVENT, eventTask.getDataKey(), eventTask.getDataValue());
            packet.longValue = event.getEventType().getType();
            return packet;
        }

        private Packet createInstanceEventPacket(InstanceEvent event) {
            Packet packet = new Packet();
            packet.set(null, ClusterOperation.EVENT, IOUtil.toData(event.getInstance().getId()), IOUtil.toData((Object)event.getEventType()));
            return packet;
        }

        private Packet createMembershipEventPacket(MembershipEvent membershipEvent) {
            Packet packet = new Packet();
            packet.set(null, ClusterOperation.EVENT, IOUtil.toData(membershipEvent.getMember()), IOUtil.toData(membershipEvent.getEventType()));
            return packet;
        }
    }
}

