/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.config.Config;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.ExecutorManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.GroupProperties;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MulticastService;
import com.hazelcast.impl.NodeBaseVariables;
import com.hazelcast.impl.NodeType;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.TopicManager;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.TextCommandServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.InSelector;
import com.hazelcast.nio.OutSelector;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.NoneStrictObjectPool;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private final ILogger logger;
    private volatile boolean joined = false;
    private volatile boolean active = false;
    private volatile boolean completelyShutdown = false;
    private final ClusterImpl clusterImpl;
    private final Set<Address> failedConnections = new CopyOnWriteArraySet<Address>();
    private final NodeShutdownHookThread shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
    private final boolean superClient;
    private final NodeType localNodeType;
    final NodeBaseVariables baseVariables;
    public final ConcurrentMapManager concurrentMapManager;
    public final BlockingQueueManager blockingQueueManager;
    public final ClusterManager clusterManager;
    public final TopicManager topicManager;
    public final ListenerManager listenerManager;
    public final ClusterService clusterService;
    public final ExecutorManager executorManager;
    public final InSelector inSelector;
    public final OutSelector outSelector;
    public final MulticastService multicastService;
    public final ConnectionManager connectionManager;
    public final ClientService clientService;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final ThreadGroup threadGroup;
    final Address address;
    final MemberImpl localMember;
    volatile Address masterAddress = null;
    volatile Thread serviceThread = null;
    public final FactoryImpl factory;
    private final int buildNumber;
    public final LoggingServiceImpl loggingService;
    private final NoneStrictObjectPool<Packet> packetPool;

    public Node(FactoryImpl factory, Config config) {
        ServerSocketChannel serverSocketChannel;
        this.threadGroup = new ThreadGroup(factory.getName());
        this.factory = factory;
        this.config = config;
        this.groupProperties = new GroupProperties(config);
        this.superClient = config.isSuperClient();
        this.localNodeType = this.superClient ? NodeType.SUPER_CLIENT : NodeType.MEMBER;
        String version = "unknown";
        String build = "unknown";
        try {
            InputStream inRuntimeProperties = Node.class.getClassLoader().getResourceAsStream("hazelcast-runtime.properties");
            if (inRuntimeProperties != null) {
                Properties runtimeProperties = new Properties();
                runtimeProperties.load(inRuntimeProperties);
                version = runtimeProperties.getProperty("hazelcast.version");
                build = runtimeProperties.getProperty("hazelcast.build");
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        int tmpBuildNumber = 0;
        try {
            tmpBuildNumber = Integer.getInteger("hazelcast.build", -1);
            if (tmpBuildNumber == -1) {
                tmpBuildNumber = Integer.parseInt(build);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.buildNumber = tmpBuildNumber;
        Address localAddress = null;
        try {
            String preferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
            String preferIPv6Address = System.getProperty("java.net.preferIPv6Addresses");
            if (preferIPv6Address == null && preferIPv4Stack == null) {
                System.setProperty("java.net.preferIPv4Stack", "true");
            }
            serverSocketChannel = ServerSocketChannel.open();
            AddressPicker addressPicker = new AddressPicker(this, serverSocketChannel);
            localAddress = addressPicker.pickAddress();
            localAddress.setThisAddress(true);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.address = localAddress;
        this.localMember = new MemberImpl(this.address, true, this.localNodeType);
        this.packetPool = new NoneStrictObjectPool<Packet>(2000){

            @Override
            public void onRelease(Packet packet) {
                if (packet.released) {
                    throw new RuntimeException("Packet is already released!");
                }
                packet.released = true;
            }

            @Override
            public void onObtain(Packet packet) {
                packet.reset();
                packet.released = false;
            }

            @Override
            public Packet createNew() {
                return new Packet();
            }
        };
        this.clusterImpl = new ClusterImpl(this, this.localMember);
        this.baseVariables = new NodeBaseVariables(this.address, this.localMember);
        this.loggingService = new LoggingServiceImpl(config.getGroupConfig().getName(), this.localMember);
        this.logger = this.loggingService.getLogger(Node.class.getName());
        this.clusterService = new ClusterService(this);
        this.clusterService.start();
        this.inSelector = new InSelector(this, serverSocketChannel);
        this.outSelector = new OutSelector(this);
        this.connectionManager = new ConnectionManager(this);
        this.clientService = new ClientService(this);
        this.clusterManager = new ClusterManager(this);
        this.executorManager = new ExecutorManager(this);
        this.concurrentMapManager = new ConcurrentMapManager(this);
        this.blockingQueueManager = new BlockingQueueManager(this);
        this.listenerManager = new ListenerManager(this);
        this.topicManager = new TopicManager(this);
        this.clusterService.enqueueAndReturn(new Processable(){

            public void process() {
                Node.this.clusterManager.addMember(Node.this.getThisAddress(), NodeType.MEMBER);
            }
        });
        this.textCommandService = new TextCommandServiceImpl(this);
        ILogger systemLogger = this.getLogger("com.hazelcast.system");
        systemLogger.log(Level.INFO, "Hazelcast " + version + " (" + build + ") starting at " + this.address);
        systemLogger.log(Level.INFO, "Copyright (C) 2008-2010 Hazelcast.com");
        Join join = config.getNetworkConfig().getJoin();
        MulticastService mcService = null;
        try {
            if (join.getMulticastConfig().isEnabled()) {
                MulticastSocket multicastSocket = new MulticastSocket(null);
                multicastSocket.setReuseAddress(true);
                multicastSocket.bind(new InetSocketAddress(join.getMulticastConfig().getMulticastPort()));
                multicastSocket.setTimeToLive(32);
                multicastSocket.setInterface(this.address.getInetAddress());
                multicastSocket.setReceiveBufferSize(1024);
                multicastSocket.setSendBufferSize(1024);
                multicastSocket.joinGroup(InetAddress.getByName(join.getMulticastConfig().getMulticastGroup()));
                multicastSocket.setSoTimeout(1000);
                mcService = new MulticastService(this, multicastSocket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.multicastService = mcService;
    }

    public void failedConnection(Address address) {
        this.failedConnections.add(address);
    }

    public ClusterImpl getClusterImpl() {
        return this.clusterImpl;
    }

    public final NodeType getLocalNodeType() {
        return this.localNodeType;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public String getName() {
        return this.factory.getName();
    }

    public void handleInterruptedException(Thread thread, Exception e) {
        this.logger.log(Level.FINEST, thread.getName() + " is interrupted ", e);
    }

    void checkNodeState() {
        if (this.factory.restarted) {
            throw new IllegalStateException("Hazelcast Instance is restarted!");
        }
        if (!this.isActive()) {
            throw new IllegalStateException("Hazelcast Instance is not active!");
        }
    }

    public static boolean isIP(String address) {
        if (address.indexOf(46) == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(address, ".");
        int tokenCount = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            ++tokenCount;
            try {
                Integer.parseInt(token);
            }
            catch (Exception e) {
                return false;
            }
        }
        return tokenCount == 4;
    }

    public final boolean isSuperClient() {
        return this.superClient;
    }

    public boolean joined() {
        return this.joined;
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null) {
            this.logger.log(Level.FINE, "** setting isMaster lockAddress to " + master.toString());
        }
        this.masterAddress = master;
    }

    public void shutdown() {
        this.logger.log(Level.FINE, "** we are being asked to shutdown when active = " + String.valueOf(this.active));
        if (this.isActive()) {
            long start = System.currentTimeMillis();
            this.joined = false;
            this.setActive(false);
            this.logger.log(Level.FINEST, "Shutting down the NIO socket selector for input");
            this.inSelector.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the NIO socket selector for output");
            this.outSelector.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the cluster service");
            this.clusterService.stop();
            this.logger.log(Level.FINEST, "Shutting down the query service");
            if (this.multicastService != null) {
                this.multicastService.stop();
            }
            this.logger.log(Level.FINEST, "Shutting down the connection manager");
            this.connectionManager.shutdown();
            this.logger.log(Level.FINEST, "Shutting down the concurrentMapManager");
            this.concurrentMapManager.reset();
            this.logger.log(Level.FINEST, "Shutting down the clientService");
            this.clientService.reset();
            this.logger.log(Level.FINEST, "Shutting down the executorManager");
            this.executorManager.stop();
            this.textCommandService.stop();
            this.masterAddress = null;
            this.logger.log(Level.FINEST, "Shutting down the cluster manager");
            this.clusterManager.stop();
            int numThreads = this.threadGroup.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            numThreads = this.threadGroup.enumerate(threads, false);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                this.logger.log(Level.FINEST, "Shutting down thread " + thread.getName());
                thread.interrupt();
            }
            this.logger.log(Level.INFO, "Hazelcast Shutdown is completed in " + (System.currentTimeMillis() - start) + " ms.");
            this.packetPool.clear();
        }
    }

    public void start() {
        this.logger.log(Level.FINEST, "We are asked to start and completelyShutdown is " + String.valueOf(this.completelyShutdown));
        if (this.completelyShutdown) {
            return;
        }
        Thread inThread = new Thread(this.threadGroup, this.inSelector, "hz.InThread");
        inThread.setPriority(7);
        this.logger.log(Level.FINEST, "Starting thread " + inThread.getName());
        inThread.start();
        Thread outThread = new Thread(this.threadGroup, this.outSelector, "hz.OutThread");
        outThread.setPriority(7);
        this.logger.log(Level.FINEST, "Starting thread " + outThread.getName());
        outThread.start();
        this.serviceThread = new Thread(this.threadGroup, this.clusterService, "hz.ServiceThread");
        this.serviceThread.setPriority(8);
        this.logger.log(Level.FINEST, "Starting thread " + this.serviceThread.getName());
        this.serviceThread.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.threadGroup, this.multicastService, "hz.MulticastThread");
            multicastServiceThread.start();
            multicastServiceThread.setPriority(6);
        }
        this.setActive(true);
        if (!this.completelyShutdown) {
            this.logger.log(Level.FINEST, "Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.log(Level.FINEST, "finished starting threads, calling join");
        this.join();
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public NoneStrictObjectPool<Packet> getPacketPool() {
        return this.packetPool;
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void unlock() {
        this.joined = true;
    }

    private Address findMaster() {
        block5: {
            try {
                String ip = System.getProperty("join.ip");
                if (ip == null) {
                    JoinInfo joinInfo = new JoinInfo(true, this.address, this.config.getGroupConfig().getName(), this.config.getGroupConfig().getPassword(), this.getLocalNodeType(), Packet.PACKET_VERSION, this.buildNumber);
                    int tryCount = this.config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastTimeoutSeconds() * 100;
                    for (int i = 0; i < tryCount; ++i) {
                        this.multicastService.send(joinInfo);
                        if (this.masterAddress != null) {
                            return this.masterAddress;
                        }
                        Thread.sleep(10L);
                    }
                    break block5;
                }
                this.logger.log(Level.FINEST, "RETURNING join.ip");
                return new Address(ip, this.config.getPort());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean validateJoinRequest(JoinRequest joinRequest) {
        return this.config.getGroupConfig().getName().equals(joinRequest.groupName) && this.config.getGroupConfig().getPassword().equals(joinRequest.groupPassword) && Packet.PACKET_VERSION == joinRequest.packetVersion && this.buildNumber == joinRequest.buildNumber;
    }

    private Address getAddressFor(String host) {
        int port = this.config.getPort();
        int indexColon = host.indexOf(58);
        if (indexColon != -1) {
            port = Integer.parseInt(host.substring(indexColon + 1));
            host = host.substring(0, indexColon);
        }
        boolean ip = Node.isIP(host);
        try {
            InetAddress[] allAddresses;
            if (ip) {
                return new Address(host, port, true);
            }
            for (InetAddress inetAddress : allAddresses = InetAddress.getAllByName(host)) {
                boolean shouldCheck = true;
                Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
                if (interfaces.isEnabled()) {
                    Address address = new Address(inetAddress.getAddress(), port);
                    shouldCheck = AddressPicker.matchAddress(address.getHost(), interfaces.getInterfaces());
                }
                if (!shouldCheck) continue;
                return new Address(inetAddress.getAddress(), port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<Address> getPossibleIpAddresses(String host, int port, boolean portSet) throws UnknownHostException {
        ArrayList<Address> list;
        if (portSet) {
            list = Collections.singletonList(new Address(host, port, true));
        } else {
            list = new ArrayList(6);
            for (int i = -2; i < 3; ++i) {
                list.add(new Address(host, port + i, true));
            }
        }
        return list;
    }

    private List<Address> getPossibleMembers() {
        Join join = this.config.getNetworkConfig().getJoin();
        List<String> lsJoinMembers = join.getTcpIpConfig().getMembers();
        ArrayList<Address> lsPossibleAddresses = new ArrayList<Address>();
        Iterator<String> i$ = lsJoinMembers.iterator();
        while (i$.hasNext()) {
            String lsJoinMember;
            String host = lsJoinMember = i$.next();
            int port = this.config.getPort();
            int indexColon = host.indexOf(58);
            if (indexColon >= 0) {
                port = Integer.parseInt(host.substring(indexColon + 1));
                host = host.substring(0, indexColon);
            }
            boolean ip = Node.isIP(host);
            try {
                InetAddress[] allAddresses;
                if (ip) {
                    for (Address addrs : this.getPossibleIpAddresses(host, port, indexColon >= 0)) {
                        if (addrs.equals(this.getThisAddress())) continue;
                        this.logger.log(Level.FINEST, "adding possible member " + addrs);
                        lsPossibleAddresses.add(addrs);
                    }
                    continue;
                }
                for (InetAddress inetAddress : allAddresses = InetAddress.getAllByName(host)) {
                    boolean shouldCheck = true;
                    Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
                    if (interfaces.isEnabled()) {
                        Address addrs = new Address(inetAddress.getAddress(), port);
                        shouldCheck = AddressPicker.matchAddress(addrs.getHost(), interfaces.getInterfaces());
                    }
                    if (!shouldCheck) continue;
                    for (int i = -2; i < 3; ++i) {
                        Address addressProper = new Address(inetAddress.getAddress(), port + i);
                        if (addressProper.equals(this.getThisAddress())) continue;
                        this.logger.log(Level.FINEST, "adding possible member " + addressProper);
                        lsPossibleAddresses.add(addressProper);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        lsPossibleAddresses.addAll(this.config.getNetworkConfig().getJoin().getTcpIpConfig().getAddresses());
        return lsPossibleAddresses;
    }

    private void join() {
        if (!this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            this.joinWithTCP();
        } else {
            this.joinWithMulticast();
        }
        this.clusterManager.finalizeJoin();
        if (this.baseVariables.lsMembers.size() == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(this.clusterManager);
            this.logger.log(Level.INFO, sb.toString());
        }
    }

    void setAsMaster() {
        this.logger.log(Level.FINE, "This node is being set as the isMaster");
        this.masterAddress = this.address;
        this.logger.log(Level.FINEST, "adding member myself");
        this.clusterManager.addMember(this.address, this.getLocalNodeType());
        this.clusterImpl.setMembers(this.baseVariables.lsMembers);
        this.unlock();
    }

    private void joinWithMulticast() {
        int tryCount = 0;
        while (!this.joined) {
            try {
                this.logger.log(Level.FINEST, "joining... " + this.masterAddress);
                if (this.masterAddress == null) {
                    this.masterAddress = this.findMaster();
                    if (this.masterAddress == null || this.masterAddress.equals(this.address)) {
                        TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
                        if (tcpIpConfig != null && tcpIpConfig.isEnabled()) {
                            this.masterAddress = null;
                            this.logger.log(Level.FINEST, "Multicast couldn't find cluster. Trying TCP/IP");
                            this.joinWithTCP();
                        } else {
                            this.setAsMaster();
                        }
                        return;
                    }
                }
                if (tryCount++ > 20) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n");
                    sb.append("===========================");
                    sb.append("\n");
                    sb.append("Couldn't connect to discovered isMaster! tryCount: " + tryCount);
                    sb.append("\n");
                    sb.append("thisAddress: " + this.address);
                    sb.append("\n");
                    sb.append("masterAddress: " + this.masterAddress);
                    sb.append("\n");
                    sb.append("connection: " + this.connectionManager.getConnection(this.masterAddress));
                    sb.append("===========================");
                    sb.append("\n");
                    this.logger.log(Level.WARNING, sb.toString());
                    tryCount = 0;
                }
                if (!this.masterAddress.equals(this.address)) {
                    this.connectAndSendJoinRequest(this.masterAddress);
                } else {
                    this.masterAddress = null;
                    tryCount = 0;
                }
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.log(Level.FINEST, "multicast join", e);
            }
        }
    }

    private void connectAndSendJoinRequest(Address masterAddress) throws Exception {
        if (masterAddress == null || masterAddress.equals(this.address)) {
            throw new IllegalArgumentException();
        }
        Connection conn = this.connectionManager.getOrConnect(masterAddress);
        this.logger.log(Level.FINEST, "Master connection " + conn);
        if (conn != null) {
            this.clusterManager.sendJoinRequest(masterAddress);
        }
    }

    private void joinViaPossibleMembers() {
        try {
            Connection conn;
            int numberOfJoinReq;
            this.failedConnections.clear();
            List<Address> lsPossibleAddresses = this.getPossibleMembers();
            lsPossibleAddresses.remove(this.address);
            for (Address possibleAddress : lsPossibleAddresses) {
                this.logger.log(Level.FINEST, "connecting to " + possibleAddress);
                this.connectionManager.getOrConnect(possibleAddress);
            }
            boolean found = false;
            int numberOfSeconds = 0;
            int connectionTimeoutSeconds = this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
            while (!found && numberOfSeconds < connectionTimeoutSeconds) {
                lsPossibleAddresses.removeAll(this.failedConnections);
                if (lsPossibleAddresses.size() == 0) break;
                Thread.sleep(1000L);
                ++numberOfSeconds;
                numberOfJoinReq = 0;
                this.logger.log(Level.FINE, "we are going to try to connect to each lockAddress, but no more than five times");
                for (Address possibleAddress : lsPossibleAddresses) {
                    this.logger.log(Level.FINEST, "connection attempt " + numberOfJoinReq + " to " + possibleAddress);
                    conn = this.connectionManager.getOrConnect(possibleAddress);
                    if (conn != null && numberOfJoinReq < 5) {
                        found = true;
                        this.logger.log(Level.FINEST, "found and sending join request for " + possibleAddress);
                        this.clusterManager.sendJoinRequest(possibleAddress);
                        ++numberOfJoinReq;
                        continue;
                    }
                    this.logger.log(Level.FINEST, "number of join requests is greater than 5, no join request will be sent for " + possibleAddress);
                }
            }
            this.logger.log(Level.FINEST, "FOUND " + found);
            if (!found) {
                this.logger.log(Level.FINEST, "This node will assume isMaster role since no possible member where connected to");
                this.setAsMaster();
            } else {
                while (!this.joined) {
                    numberOfJoinReq = 0;
                    lsPossibleAddresses.removeAll(this.failedConnections);
                    for (Address possibleAddress : lsPossibleAddresses) {
                        conn = this.connectionManager.getOrConnect(possibleAddress);
                        if (conn != null && numberOfJoinReq < 5) {
                            this.logger.log(Level.FINEST, "sending join request for " + possibleAddress);
                            this.clusterManager.sendJoinRequest(possibleAddress);
                            ++numberOfJoinReq;
                            continue;
                        }
                        this.logger.log(Level.FINEST, "number of join request is greater than 5, no join request will be sent for " + possibleAddress + " the second time");
                    }
                    Thread.sleep(2000L);
                    if (this.masterAddress != null) continue;
                    boolean masterCandidate = true;
                    for (Address address : lsPossibleAddresses) {
                        if (this.address.hashCode() <= address.hashCode()) continue;
                        masterCandidate = false;
                    }
                    if (!masterCandidate) continue;
                    this.logger.log(Level.FINEST, "I am the isMaster candidate, setting as isMaster");
                    this.setAsMaster();
                }
            }
            lsPossibleAddresses.clear();
            this.failedConnections.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void joinViaRequiredMember() {
        try {
            Address requiredAddress = this.getAddressFor(this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            this.logger.log(Level.FINEST, "Joining over required member " + requiredAddress);
            if (requiredAddress == null) {
                throw new RuntimeException("Invalid required member " + this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            }
            if (requiredAddress.equals(this.address)) {
                this.setAsMaster();
                return;
            }
            this.connectionManager.getOrConnect(requiredAddress);
            Connection conn = null;
            while (conn == null) {
                conn = this.connectionManager.getOrConnect(requiredAddress);
                Thread.sleep(1000L);
            }
            while (!this.joined) {
                Connection connection = this.connectionManager.getOrConnect(requiredAddress);
                if (connection == null) {
                    this.joinViaRequiredMember();
                }
                this.logger.log(Level.FINEST, "Sending joinRequest " + requiredAddress);
                this.clusterManager.sendJoinRequest(requiredAddress);
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void joinWithTCP() {
        if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            this.joinViaRequiredMember();
        } else {
            this.joinViaPossibleMembers();
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return "Node[" + this.getName() + "]";
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        public void run() {
            try {
                if (Node.this.isActive() && !Node.this.completelyShutdown) {
                    Node.this.completelyShutdown = true;
                    if (Node.this.groupProperties.SHUTDOWNHOOK_ENABLED.getBoolean()) {
                        Node.this.shutdown();
                    }
                } else {
                    Node.this.logger.log(Level.FINEST, "shutdown hook - we are not --> active and not completely down so we are not calling shutdown");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

