/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.GetCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommandProcessor
extends AbstractTextCommandProcessor<GetCommand> {
    final boolean single;

    public GetCommandProcessor(TextCommandService textCommandService, boolean single) {
        super(textCommandService);
        this.single = single;
    }

    @Override
    public void handle(GetCommand getCommand) {
        String key = getCommand.getKey();
        String mapName = "default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = key.substring(0, index);
            key = key.substring(index + 1);
        }
        byte[] valueBytes = this.textCommandService.getByteArray(mapName, key);
        this.textCommandService.incrementGetCount();
        if (valueBytes != null) {
            this.textCommandService.incrementHitCount();
        }
        getCommand.setValue(valueBytes, this.single);
        this.textCommandService.sendResponse(getCommand);
    }

    @Override
    public void handleRejection(GetCommand getCommand) {
        getCommand.setValue(null, this.single);
        this.textCommandService.sendResponse(getCommand);
    }
}

