/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import java.nio.ByteBuffer;

public abstract class HttpCommand
extends AbstractTextCommand {
    public static final String HEADER_CONTENT_TYPE = "Content-TextCommandType: ";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length: ";
    public static final String HEADER_CHUNKED = "Transfer-Encoding: chunked";
    protected final String uri;
    protected ByteBuffer response;
    public static final byte[] RES_200 = "HTTP/1.1 200 OK\r\n".getBytes();
    public static final byte[] RES_400 = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] RES_404 = "HTTP/1.1 404 Not Found\r\n\r\n".getBytes();
    public static final byte[] RES_100 = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    public static final byte[] RES_204 = "HTTP/1.1 204 No Content\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] CONTENT_TYPE = "Content-TextCommandType: ".getBytes();
    public static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes();

    public HttpCommand(TextCommandConstants.TextCommandType type, String uri) {
        super(type);
        this.uri = uri;
    }

    public boolean shouldReply() {
        return true;
    }

    public String getURI() {
        return this.uri;
    }

    public void send204() {
        this.response = ByteBuffer.wrap(RES_204);
    }

    public void send400() {
        this.response = ByteBuffer.wrap(RES_400);
    }

    public void setResponse(byte[] value) {
        this.response = ByteBuffer.wrap(value);
    }

    public boolean writeTo(ByteBuffer bb) {
        while (bb.hasRemaining() && this.response.hasRemaining()) {
            bb.put(this.response.get());
        }
        return !this.response.hasRemaining();
    }

    public String toString() {
        return "HttpCommand [" + (Object)((Object)this.type) + "]{" + "uri='" + this.uri + '\'' + '}' + super.toString();
    }
}

