/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.impl.ExecutorThreadFactory;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.jmx.ClusterMBean;
import com.hazelcast.jmx.DataMBean;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.StatisticsCollector;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagementService {
    private static final Logger logger = Logger.getLogger(ManagementService.class.getName());
    public static final String ENABLE_JMX = "hazelcast.jmx";
    public static final String HAZELCAST_JMX_DETAILED = "hazelcast.jmx.detailed";
    private static volatile ScheduledThreadPoolExecutor statCollectors;
    private static boolean started;
    private static boolean showDetail;

    private static synchronized void start() {
        String jmxProperty = System.getProperty(ENABLE_JMX);
        if ("FALSE".equalsIgnoreCase(jmxProperty)) {
            return;
        }
        if (!"TRUE".equalsIgnoreCase(jmxProperty) && !System.getProperties().containsKey("com.sun.management.jmxremote")) {
            return;
        }
        if ("TRUE".equalsIgnoreCase(System.getProperty(HAZELCAST_JMX_DETAILED))) {
            showDetail = true;
        }
        logger.log(Level.INFO, "Hazelcast JMX agent enabled");
        if (ManagementService.showDetails() && statCollectors == null) {
            statCollectors = new ScheduledThreadPoolExecutor(2, new ExecutorThreadFactory(null, "jmx", null));
        }
        started = true;
    }

    public static synchronized void register(FactoryImpl instance, Config config) {
        if (!started) {
            ManagementService.start();
        }
        if (!started) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ClusterMBean clusterMBean = new ClusterMBean(instance, config);
            mbs.registerMBean(clusterMBean, clusterMBean.getObjectName());
            DataMBean dataMBean = new DataMBean(instance);
            dataMBean.setParentName(clusterMBean.getRootName());
            mbs.registerMBean(dataMBean, dataMBean.getObjectName());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to start JMX service", e);
            return;
        }
    }

    public static synchronized void unregister(FactoryImpl instance) {
        if (!started) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(ObjectNameSpec.getClusterNameFilter(instance.getName()), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error unregistering MBeans", e);
        }
    }

    public static synchronized void shutdown() {
        if (!started) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> entries = mbs.queryNames(new ObjectName(ObjectNameSpec.NAME_DOMAIN + "*"), null);
            for (ObjectName name : entries) {
                if (!mbs.isRegistered(name)) continue;
                mbs.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error unregistering MBeans", e);
        }
        if (statCollectors != null) {
            System.out.println("shutting down!!!!!!!!");
            statCollectors.shutdownNow();
            statCollectors = null;
        }
    }

    protected static boolean showDetails() {
        return showDetail;
    }

    public static StatisticsCollector newStatisticsCollector() {
        if (statCollectors != null) {
            long interval = 1L;
            ScheduledCollector collector = new ScheduledCollector(interval);
            ScheduledFuture<?> future = statCollectors.scheduleWithFixedDelay(collector, interval, interval, TimeUnit.SECONDS);
            collector.setScheduledFuture(future);
            return collector;
        }
        return null;
    }

    static {
        started = false;
        showDetail = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ScheduledCollector
    implements Runnable,
    StatisticsCollector {
        private long interval = 1L;
        private volatile long events = 0L;
        private volatile long total = 0L;
        private volatile double min = 9.223372036854776E18;
        private volatile double max = 0.0;
        private volatile double average = 0.0;
        private ScheduledFuture<StatisticsCollector> future;

        public ScheduledCollector(long interval) {
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScheduledCollector scheduledCollector = this;
            synchronized (scheduledCollector) {
                this.average = this.events / this.interval;
                this.events = 0L;
                this.min = this.average < this.min ? this.average : this.min;
                this.max = this.average > this.max ? this.average : this.max;
            }
        }

        private void setScheduledFuture(ScheduledFuture<StatisticsCollector> future) {
            this.future = future;
        }

        @Override
        public void destroy() {
            this.future.cancel(true);
        }

        @Override
        public synchronized void addEvent() {
            ++this.events;
            ++this.total;
        }

        @Override
        public synchronized void reset() {
            this.events = 0L;
            this.min = 9.223372036854776E18;
            this.max = 0.0;
            this.average = 0.0;
        }

        @Override
        public long getEvents() {
            return this.events;
        }

        @Override
        public long getTotal() {
            return this.total;
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }

        @Override
        public double getAverage() {
            return this.average;
        }

        @Override
        public long getInterval() {
            return this.interval;
        }
    }
}

