/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Parser;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.QueryContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlPredicate
extends Predicates.AbstractPredicate
implements IndexAwarePredicate {
    private transient Predicate predicate;
    private String sql;

    public SqlPredicate(String sql) {
        this.sql = sql;
        this.predicate = this.createPredicate(sql);
    }

    public SqlPredicate() {
    }

    @Override
    public boolean apply(MapEntry mapEntry) {
        return this.predicate.apply(mapEntry);
    }

    @Override
    public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
        if (this.predicate instanceof IndexAwarePredicate) {
            return ((IndexAwarePredicate)this.predicate).collectIndexAwarePredicates(lsIndexPredicates, mapIndexes);
        }
        return false;
    }

    @Override
    public Set<MapEntry> filter(QueryContext queryContext) {
        return ((IndexAwarePredicate)this.predicate).filter(queryContext);
    }

    @Override
    public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
        if (this.predicate instanceof IndexAwarePredicate) {
            ((IndexAwarePredicate)this.predicate).collectAppliedIndexes(setAppliedIndexes, mapIndexes);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.sql);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.sql = in.readUTF();
        this.predicate = this.createPredicate(this.sql);
    }

    private int getApostropheIndex(String str, int start) {
        return str.indexOf("'", start);
    }

    private Predicate createPredicate(String sql) {
        HashMap<String, String> mapPhrases = new HashMap<String, String>(1);
        int apoIndex = this.getApostropheIndex(sql, 0);
        if (apoIndex != -1) {
            int phraseId = 0;
            StringBuilder newSql = new StringBuilder();
            while (apoIndex != -1) {
                ++phraseId;
                int start = apoIndex + 1;
                int end = this.getApostropheIndex(sql, apoIndex + 1);
                if (end == -1) {
                    throw new RuntimeException("Missing ' in sql");
                }
                String phrase = sql.substring(start, end);
                String key = "$" + phraseId;
                mapPhrases.put(key, phrase);
                String before = sql.substring(0, apoIndex);
                sql = sql.substring(end + 1);
                newSql.append(before);
                newSql.append(key);
                apoIndex = this.getApostropheIndex(sql, 0);
            }
            newSql.append(sql);
            sql = newSql.toString();
        }
        Parser parser = new Parser();
        List<String> sqlTokens = parser.toPrefix(sql);
        ArrayList<String> tokens = new ArrayList<String>(sqlTokens.size());
        Iterator<String> i$ = sqlTokens.iterator();
        while (i$.hasNext()) {
            String token;
            String finalToken = token = i$.next();
            String value = (String)mapPhrases.get(token);
            if (value != null) {
                finalToken = value;
            }
            tokens.add(finalToken);
        }
        if (tokens.size() == 0) {
            throw new RuntimeException("Invalid SQL :" + sql);
        }
        if (tokens.size() == 1) {
            return this.eval(tokens.get(0));
        }
        block2: while (tokens.size() > 1) {
            for (int i = 0; i < tokens.size(); ++i) {
                Object exp;
                Object second;
                Object first;
                int position;
                Object tokenObj = tokens.get(i);
                if (!(tokenObj instanceof String) || !parser.isOperand((String)tokenObj)) continue;
                String token = (String)tokenObj;
                if ("=".equals(token) || "==".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.equal(Predicates.get((String)first), second));
                    continue block2;
                }
                if ("!=".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.notEqual(Predicates.get((String)first), second));
                    continue block2;
                }
                if (">".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.greaterThan(Predicates.get((String)first), (Comparable)second));
                    continue block2;
                }
                if (">=".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.greaterEqual(Predicates.get((String)first), (Comparable)second));
                    continue block2;
                }
                if ("<=".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.lessEqual(Predicates.get((String)first), (Comparable)second));
                    continue block2;
                }
                if ("<".equals(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.lessThan(Predicates.get((String)first), (Comparable)second));
                    continue block2;
                }
                if ("LIKE".equalsIgnoreCase(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.like(Predicates.get((String)first), (String)second));
                    continue block2;
                }
                if ("IN".equalsIgnoreCase(token)) {
                    position = i - 2;
                    exp = tokens.remove(position);
                    String[] values = ((String)tokens.remove(position)).split(",");
                    this.setOrAdd(tokens, position, Predicates.in((Expression)Predicates.get((String)exp), (Comparable[])values));
                    continue block2;
                }
                if ("NOT".equalsIgnoreCase(token)) {
                    position = i - 1;
                    exp = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.not(this.eval(exp)));
                    continue block2;
                }
                if ("BETWEEN".equalsIgnoreCase(token)) {
                    position = i - 3;
                    Object expression = tokens.remove(position);
                    Object from = tokens.remove(position);
                    Object to = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.between(Predicates.get((String)expression), (Comparable)from, (Comparable)to));
                    continue block2;
                }
                if ("AND".equalsIgnoreCase(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.and(this.eval(first), this.eval(second)));
                    continue block2;
                }
                if ("OR".equalsIgnoreCase(token)) {
                    position = i - 2;
                    first = tokens.remove(position);
                    second = tokens.remove(position);
                    this.setOrAdd(tokens, position, Predicates.or(this.eval(first), this.eval(second)));
                    continue block2;
                }
                throw new RuntimeException("Unknown token " + token);
            }
        }
        return (Predicate)tokens.get(0);
    }

    private void setOrAdd(List tokens, int position, Predicate predicate) {
        if (tokens.size() == 0) {
            tokens.add(predicate);
        } else {
            tokens.set(position, predicate);
        }
    }

    private Predicate eval(Object statement) {
        if (statement instanceof String) {
            return Predicates.equal(Predicates.get((String)statement), "true");
        }
        return (Predicate)statement;
    }

    public String toString() {
        return this.predicate.toString();
    }
}

