/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.processor.DefaultErrorHandler;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    protected Logger logger;
    protected ExceptionPolicyStrategy exceptionPolicyStrategy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();
    protected RedeliveryPolicy redeliveryPolicy;
    protected Processor onRedelivery;
    protected Predicate handledPolicy;
    protected Processor failureProcessor;
    protected Endpoint deadLetter;
    protected String deadLetterUri;
    protected boolean useOriginalMessage;
    protected boolean asyncDelayedRedelivery;

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        DefaultErrorHandler answer = new DefaultErrorHandler(routeContext.getCamelContext(), processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getHandledPolicy(), this.getExceptionPolicyStrategy());
        this.configure(answer);
        return answer;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    public DefaultErrorHandlerBuilder backOffMultiplier(double backOffMultiplier) {
        this.getRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public DefaultErrorHandlerBuilder collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    @Deprecated
    public DefaultErrorHandlerBuilder redeliverDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public DefaultErrorHandlerBuilder redeliveryDelay(long delay) {
        this.getRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public DefaultErrorHandlerBuilder delayPattern(String delayPattern) {
        this.getRedeliveryPolicy().delayPattern(delayPattern);
        return this;
    }

    public DefaultErrorHandlerBuilder maximumRedeliveries(int maximumRedeliveries) {
        this.getRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public DefaultErrorHandlerBuilder disableRedelivery() {
        this.getRedeliveryPolicy().maximumRedeliveries(0);
        return this;
    }

    public DefaultErrorHandlerBuilder maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public DefaultErrorHandlerBuilder useCollisionAvoidance() {
        this.getRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public DefaultErrorHandlerBuilder useExponentialBackOff() {
        this.getRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public DefaultErrorHandlerBuilder retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getRedeliveryPolicy().setRetriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public DefaultErrorHandlerBuilder retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getRedeliveryPolicy().setRetryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public DefaultErrorHandlerBuilder logStackTrace(boolean logStackTrace) {
        this.getRedeliveryPolicy().setLogStackTrace(logStackTrace);
        return this;
    }

    public DefaultErrorHandlerBuilder logRetryStackTrace(boolean logRetryStackTrace) {
        this.getRedeliveryPolicy().setLogRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public DefaultErrorHandlerBuilder logHandled(boolean logHandled) {
        this.getRedeliveryPolicy().setLogHandled(logHandled);
        return this;
    }

    public DefaultErrorHandlerBuilder logExhausted(boolean logExhausted) {
        this.getRedeliveryPolicy().setLogExhausted(logExhausted);
        return this;
    }

    public DefaultErrorHandlerBuilder asyncDelayedRedelivery() {
        this.getRedeliveryPolicy().setAsyncDelayedRedelivery(true);
        return this;
    }

    @Deprecated
    public DefaultErrorHandlerBuilder handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    @Deprecated
    public DefaultErrorHandlerBuilder handled(Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    @Deprecated
    public DefaultErrorHandlerBuilder handled(Expression handled) {
        this.setHandledPolicy(PredicateBuilder.toPredicate(handled));
        return this;
    }

    public DefaultErrorHandlerBuilder logger(Logger logger) {
        this.setLogger(logger);
        return this;
    }

    public DefaultErrorHandlerBuilder loggingLevel(LoggingLevel level) {
        this.getLogger().setLevel(level);
        return this;
    }

    public DefaultErrorHandlerBuilder log(Log log) {
        this.getLogger().setLog(log);
        return this;
    }

    public DefaultErrorHandlerBuilder log(String log) {
        return this.log(LogFactory.getLog((String)log));
    }

    public DefaultErrorHandlerBuilder log(Class<?> log) {
        return this.log(LogFactory.getLog(log));
    }

    @Override
    public DefaultErrorHandlerBuilder exceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.setExceptionPolicyStrategy(exceptionPolicyStrategy);
        return this;
    }

    public DefaultErrorHandlerBuilder onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public DefaultErrorHandlerBuilder useOriginalMessage() {
        this.setUseOriginalMessage(true);
        return this;
    }

    public Processor getFailureProcessor() {
        return this.failureProcessor;
    }

    public void setFailureProcessor(Processor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = this.createRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ExceptionPolicyStrategy getExceptionPolicyStrategy() {
        return this.exceptionPolicyStrategy;
    }

    @Override
    public void setExceptionPolicyStrategy(ExceptionPolicyStrategy exceptionPolicyStrategy) {
        this.exceptionPolicyStrategy = exceptionPolicyStrategy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    @Deprecated
    public Predicate getHandledPolicy() {
        if (this.handledPolicy == null) {
            this.handledPolicy = this.createHandledPolicy();
        }
        return this.handledPolicy;
    }

    @Deprecated
    public void setHandledPolicy(Predicate handled) {
        this.handledPolicy = handled;
    }

    @Deprecated
    public void setHandled(boolean handled) {
        this.handled(handled);
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetter = null;
        this.deadLetterUri = deadLetterUri;
    }

    public Endpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void setDeadLetter(Endpoint deadLetter) {
        this.deadLetter = deadLetter;
        this.deadLetterUri = deadLetter.getEndpointUri();
    }

    public boolean isUseOriginalMessage() {
        return this.useOriginalMessage;
    }

    public void setUseOriginalMessage(boolean useOriginalMessage) {
        this.useOriginalMessage = useOriginalMessage;
    }

    public boolean isAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(boolean asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    protected Predicate createHandledPolicy() {
        return PredicateBuilder.toPredicate(ExpressionBuilder.constantExpression(false));
    }

    protected RedeliveryPolicy createRedeliveryPolicy() {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.disableRedelivery();
        policy.setRedeliveryDelay(0L);
        return policy;
    }

    protected Logger createLogger() {
        return new Logger(LogFactory.getLog(DefaultErrorHandler.class), LoggingLevel.ERROR);
    }

    public String toString() {
        return "DefaultErrorHandlerBuilder";
    }
}

