/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.ArrayList;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.management.JmxNotificationBroadcasterAware;
import org.apache.camel.management.mbean.ManagedEventNotifierMBean;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;

public class ManagedEventNotifier
extends NotificationBroadcasterSupport
implements ManagedEventNotifierMBean {
    private CamelContext context;
    private EventNotifier eventNotifier;

    public ManagedEventNotifier(CamelContext context, EventNotifier eventNotifier) {
        this.context = context;
        this.eventNotifier = eventNotifier;
        if (eventNotifier instanceof JmxNotificationBroadcasterAware) {
            ((JmxNotificationBroadcasterAware)((Object)eventNotifier)).setNotificationBroadcaster(this);
        }
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    public EventNotifier getEventNotifier() {
        return this.eventNotifier;
    }

    public boolean isIgnoreCamelContextEvents() {
        return this.getEventNotifier().isIgnoreCamelContextEvents();
    }

    public void setIgnoreCamelContextEvents(boolean ignoreCamelContextEvents) {
        this.getEventNotifier().setIgnoreCamelContextEvents(ignoreCamelContextEvents);
    }

    public boolean isIgnoreRouteEvents() {
        return this.getEventNotifier().isIgnoreRouteEvents();
    }

    public void setIgnoreRouteEvents(boolean ignoreRouteEvents) {
        this.getEventNotifier().setIgnoreRouteEvents(ignoreRouteEvents);
    }

    public boolean isIgnoreServiceEvents() {
        return this.getEventNotifier().isIgnoreServiceEvents();
    }

    public void setIgnoreServiceEvents(boolean ignoreServiceEvents) {
        this.getEventNotifier().setIgnoreServiceEvents(ignoreServiceEvents);
    }

    public boolean isIgnoreExchangeEvents() {
        return this.getEventNotifier().isIgnoreExchangeEvents();
    }

    public void setIgnoreExchangeEvents(boolean ignoreExchangeEvents) {
        this.getEventNotifier().setIgnoreExchangeEvents(ignoreExchangeEvents);
    }

    public boolean isIgnoreExchangeCreatedEvent() {
        return this.getEventNotifier().isIgnoreExchangeCreatedEvent();
    }

    public void setIgnoreExchangeCreatedEvent(boolean ignoreExchangeCreatedEvent) {
        this.getEventNotifier().setIgnoreExchangeCreatedEvent(ignoreExchangeCreatedEvent);
    }

    public boolean isIgnoreExchangeCompletedEvent() {
        return this.getEventNotifier().isIgnoreExchangeCompletedEvent();
    }

    public void setIgnoreExchangeCompletedEvent(boolean ignoreExchangeCompletedEvent) {
        this.getEventNotifier().setIgnoreExchangeCompletedEvent(ignoreExchangeCompletedEvent);
    }

    public boolean isIgnoreExchangeFailedEvents() {
        return this.getEventNotifier().isIgnoreExchangeFailedEvents();
    }

    public void setIgnoreExchangeFailedEvents(boolean ignoreExchangeFailedEvents) {
        this.getEventNotifier().setIgnoreExchangeFailedEvents(ignoreExchangeFailedEvents);
    }

    public boolean isIgnoreExchangeRedeliveryEvents() {
        return this.getEventNotifier().isIgnoreExchangeRedeliveryEvents();
    }

    public void setIgnoreExchangeRedeliveryEvents(boolean ignoreExchangeRedeliveryEvents) {
        this.getEventNotifier().setIgnoreExchangeRedeliveryEvents(ignoreExchangeRedeliveryEvents);
    }

    public boolean isIgnoreExchangeSentEvents() {
        return this.getEventNotifier().isIgnoreExchangeSentEvents();
    }

    public void setIgnoreExchangeSentEvents(boolean ignoreExchangeSentEvents) {
        this.getEventNotifier().setIgnoreExchangeSentEvents(ignoreExchangeSentEvents);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] names = new String[]{"CamelContextStartedEvent", "CamelContextStartingEvent", "CamelContextStartupFailureEvent", "CamelContextStopFailureEvent", "CamelContextStoppedEvent", "CamelContextStoppingEvent", "ExchangeCompletedEvent", "ExchangeCreatedEvent", "ExchangeFailedEvent", "ExchangeFailureHandledEvent", "ExchangeRedeliveryEvents", "ExchangeSentEvent", "RouteStartedEvent", "RouteStoppedEvent", "ServiceStartupFailureEvent", "ServiceStopFailureEvent"};
        ArrayList<MBeanNotificationInfo> infos = new ArrayList<MBeanNotificationInfo>();
        for (String name : names) {
            MBeanNotificationInfo info = new MBeanNotificationInfo(new String[]{"org.apache.camel.management.event"}, "org.apache.camel.management.event." + name, "The event " + name + " occurred");
            infos.add(info);
        }
        return infos.toArray(new MBeanNotificationInfo[infos.size()]);
    }
}

