/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.config.Configurable;

public abstract class LocaleAwareDateDecoder
implements Configurable {
    public static final String FORMAT = "format";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String LOCALE_LANGUAGE_CODE = "locale-language";
    public static final String LOCALE_COUNTRY_CODE = "locale-country";
    public static final String VERIFY_LOCALE = "verify-locale";
    private boolean verifyLocale;
    protected String format;
    protected SimpleDateFormat decoder = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void setConfiguration(Properties resourceConfig) throws SmooksConfigurationException {
        this.format = resourceConfig.getProperty(FORMAT, DEFAULT_DATE_FORMAT);
        if (this.format == null) {
            throw new SmooksConfigurationException("Decoder must specify a 'format' parameter.");
        }
        String languageCode = resourceConfig.getProperty(LOCALE_LANGUAGE_CODE);
        String countryCode = resourceConfig.getProperty(LOCALE_COUNTRY_CODE);
        this.verifyLocale = Boolean.parseBoolean(resourceConfig.getProperty(VERIFY_LOCALE, "false"));
        this.decoder = new SimpleDateFormat(this.format.trim(), this.getLocale(languageCode, countryCode));
    }

    protected Locale getLocale(String languageCode, String countryCode) {
        Locale locale = null;
        locale = languageCode == null ? Locale.getDefault() : (countryCode == null ? new Locale(languageCode.trim()) : new Locale(languageCode.trim(), countryCode.trim()));
        if (this.verifyLocale && !this.isLocalInstalled(locale)) {
            throw new SmooksConfigurationException("Locale " + locale + " is not available on this system.");
        }
        return locale;
    }

    protected boolean isLocalInstalled(Locale locale) {
        return Arrays.asList(Locale.getAvailableLocales()).contains(locale);
    }
}

