/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.drools.SystemEventListener;
import org.drools.grid.io.Acceptor;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.remote.mina.MinaIoHandler;

public class MinaAcceptor
implements Acceptor {
    private IoAcceptor acceptor;
    private MessageReceiverHandler handler;

    public synchronized void setAcceptor(IoAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public synchronized void open(InetSocketAddress address, MessageReceiverHandler handler, SystemEventListener systemEventListener) {
        if (this.acceptor == null) {
            this.acceptor = new NioSocketAcceptor();
            this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new ObjectSerializationCodecFactory()));
            this.acceptor.getSessionConfig().setReadBufferSize(2048);
            this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 100);
        }
        this.handler = handler;
        this.acceptor.setHandler((IoHandler)new MinaIoHandler(systemEventListener, handler));
        try {
            this.acceptor.bind((SocketAddress)address);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to bind Mina Acceptor", e);
        }
    }

    public synchronized void close() {
        this.acceptor.unbind();
        this.acceptor.dispose();
        this.acceptor = null;
    }

    public synchronized boolean isOpen() {
        return this.acceptor != null && this.acceptor.isActive();
    }

    public synchronized IoAcceptor getIoAcceptor() {
        return this.acceptor;
    }

    public int getCurrentSessions() {
        return this.acceptor.getManagedSessionCount();
    }

    public MessageReceiverHandler getMessageReceiverHandler() {
        return this.handler;
    }
}

