/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.grid.Grid;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.WhitePages;
import org.drools.grid.service.directory.impl.GridServiceDescriptionImpl;
import org.drools.grid.service.directory.impl.GridServiceDescriptionJpa;
import org.drools.grid.service.directory.impl.WhitePagesImpl;
import org.drools.grid.service.directory.impl.WhitePagesServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaWhitePages
implements WhitePages,
MessageReceiverHandlerFactoryService {
    private EntityManagerFactory emf;

    public JpaWhitePages(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Override
    public GridServiceDescription create(String serviceDescriptionId) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        GridServiceDescriptionImpl gsd = new GridServiceDescriptionImpl(serviceDescriptionId);
        em.persist((Object)gsd);
        em.getTransaction().commit();
        em.close();
        return new GridServiceDescriptionJpa(gsd, this.emf);
    }

    @Override
    public GridServiceDescription lookup(String serviceDescriptionId) {
        GridServiceDescription gsd = (GridServiceDescription)this.emf.createEntityManager().find(GridServiceDescriptionImpl.class, (Object)serviceDescriptionId);
        return gsd == null ? null : new GridServiceDescriptionJpa(gsd, this.emf);
    }

    @Override
    public void remove(String serviceDescriptionId) {
        EntityManager em = this.emf.createEntityManager();
        em.getTransaction().begin();
        GridServiceDescription gsd = (GridServiceDescription)em.find(GridServiceDescriptionImpl.class, (Object)serviceDescriptionId);
        for (Address address : gsd.getAddresses().values()) {
            em.remove((Object)address);
        }
        em.remove((Object)gsd);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public MessageReceiverHandler getMessageReceiverHandler() {
        return new WhitePagesServer(this);
    }

    public List<GridServiceDescription> lookupServices(Class clazz) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void registerSocketService(Grid grid, String id, String ip, int port) {
        WhitePagesImpl.doRegisterSocketService(grid, id, ip, port);
    }
}

