/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.base.ClassObjectType;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.base.extractors.SelfReferenceClassFieldReader;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.DrlExprParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.QueryElement;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.Variable;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.mvel2.MVEL;

public class QueryElementBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        MVELDumper.MVELDumperContext mvelCtx;
        ConstraintConnectiveDescr result;
        DrlExprParser parser;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (!patternDescr.isQuery()) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Query's must ? as they are pull only:\n"));
            return null;
        }
        Query query = (Query)context.getPkg().getRule(patternDescr.getObjectType());
        if (query == null) {
            query = (Query)context.getRule();
        }
        Declaration[] params = query.getParameters();
        List<? extends BaseDescr> args = patternDescr.getDescrs();
        ArrayList<Integer> declrIndexes = new ArrayList<Integer>();
        ArrayList<Integer> varIndexes = new ArrayList<Integer>();
        ArrayList<Object> arguments = new ArrayList<Object>(params.length);
        for (int i = 0; i < params.length; ++i) {
            arguments.add(null);
        }
        ArrayList<Declaration> requiredDeclarations = new ArrayList<Declaration>();
        ClassObjectType argsObjectType = new ClassObjectType(Object[].class);
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class, "this");
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)argsObjectType, null);
        int length = args.size();
        for (int i = 0; i < length; ++i) {
            ExprConstraintDescr arg = (ExprConstraintDescr)args.get(i);
            if (arg.getType() != ExprConstraintDescr.Type.POSITIONAL || arg.getPosition() == -1) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Query's must use positional or bindings, not field constraints:\n" + arg.getExpression()));
                continue;
            }
            String expr = arg.getExpression().trim();
            if (QueryElementBuilder.isVariable(expr)) {
                Declaration declr = context.getDeclarationResolver().getDeclaration((Rule)query, expr);
                if (declr != null) {
                    arguments.set(arg.getPosition(), declr);
                    declrIndexes.add(arg.getPosition());
                    requiredDeclarations.add(declr);
                    continue;
                }
                declr = pattern.addDeclaration(expr);
                ArrayElementReader reader = new ArrayElementReader((InternalReadAccessor)arrayReader, varIndexes.size(), params[arg.getPosition()].getExtractor().getExtractToClass());
                declr.setReadAccessor((InternalReadAccessor)reader);
                varIndexes.add(arg.getPosition());
                arguments.set(arg.getPosition(), Variable.variable);
                continue;
            }
            parser = new DrlExprParser();
            result = parser.parse(expr);
            if (parser.hasErrors()) {
                for (DroolsParserException error : parser.getErrors()) {
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                }
                return null;
            }
            mvelCtx = new MVELDumper.MVELDumperContext();
            expr = new MVELDumper().dump((BaseDescr)result, mvelCtx);
            arguments.set(arg.getPosition(), MVEL.eval((String)expr));
        }
        for (BindingDescr binding : patternDescr.getBindings()) {
            int pos;
            Declaration declr = context.getDeclarationResolver().getDeclaration(context.getRule(), binding.getVariable());
            if (declr != null && (pos = QueryElementBuilder.getPos(binding.getExpression().trim(), params)) >= 0) {
                String slot = binding.getExpression().trim();
                String var = binding.getVariable().trim();
                binding.setVariable(slot);
                binding.setExpression(var);
            }
            if ((pos = QueryElementBuilder.getPos(binding.getVariable(), params)) >= 0) {
                declr = context.getDeclarationResolver().getDeclaration(context.getRule(), binding.getExpression());
                if (declr != null) {
                    arguments.set(pos, declr);
                    declrIndexes.add(pos);
                    requiredDeclarations.add(declr);
                    continue;
                }
                parser = new DrlExprParser();
                result = parser.parse(binding.getExpression());
                if (parser.hasErrors()) {
                    for (DroolsParserException error : parser.getErrors()) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                    }
                    return null;
                }
                mvelCtx = new MVELDumper.MVELDumperContext();
                String expr = new MVELDumper().dump((BaseDescr)result, mvelCtx);
                Object o = MVEL.eval((String)expr);
                arguments.set(pos, o);
                continue;
            }
            declr = pattern.addDeclaration(binding.getVariable());
            pos = QueryElementBuilder.getPos(binding.getExpression(), params);
            if (pos < 0) {
                throw new RuntimeException("named argument does not exist");
            }
            ArrayElementReader reader = new ArrayElementReader((InternalReadAccessor)arrayReader, varIndexes.size(), params[pos].getExtractor().getExtractToClass());
            declr.setReadAccessor((InternalReadAccessor)reader);
            varIndexes.add(pos);
            arguments.set(pos, Variable.variable);
        }
        Declaration[] declrsArray = requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]);
        int[] declrIndexArray = new int[declrIndexes.size()];
        for (int i = 0; i < declrsArray.length; ++i) {
            declrIndexArray[i] = (Integer)declrIndexes.get(i);
        }
        int[] varIndexesArray = new int[varIndexes.size()];
        for (int i = 0; i < varIndexesArray.length; ++i) {
            varIndexesArray[i] = (Integer)varIndexes.get(i);
        }
        return new QueryElement(pattern, query.getName(), arguments.toArray(new Object[arguments.size()]), declrsArray, declrIndexArray, varIndexesArray);
    }

    public static int getPos(String identifier, Declaration[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getIdentifier().trim().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAtomic(ConstraintConnectiveDescr result) {
        return result.getDescrs().size() == 1 && result.getDescrs().get(0) instanceof AtomicExprDescr;
    }

    public static boolean isVariable(String str) {
        str = str.trim();
        switch (str.charAt(0)) {
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        for (int i = 1; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }
}

