/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.common.DefaultFactHandle;
import org.drools.core.util.StringUtils;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.xml.jaxb.util.JaxbUnknownAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class InsertObjectCommand
implements GenericCommand<FactHandle> {
    private static final long serialVersionUID = 510L;
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object object;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(name="return-object")
    private boolean returnObject = true;
    @XmlAttribute(name="entry-point")
    private String entryPoint;
    @XmlAttribute(name="disconnected")
    private boolean disconnected = false;

    public InsertObjectCommand() {
    }

    public InsertObjectCommand(Object object) {
        this.object = object;
    }

    public InsertObjectCommand(Object object, boolean disconnected) {
        this.object = object;
        this.disconnected = disconnected;
    }

    public InsertObjectCommand(Object object, String outIdentifier) {
        this.object = object;
        this.outIdentifier = outIdentifier;
    }

    @Override
    public FactHandle execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        FactHandle factHandle = StringUtils.isEmpty(this.entryPoint) ? ksession.insert(this.object) : ksession.getWorkingMemoryEntryPoint(this.entryPoint).insert(this.object);
        ReteooWorkingMemory session = ((StatefulKnowledgeSessionImpl)ksession).session;
        if (this.outIdentifier != null) {
            if (this.returnObject) {
                session.getExecutionResult().getResults().put(this.outIdentifier, this.object);
            }
            session.getExecutionResult().getFactHandles().put(this.outIdentifier, factHandle);
        }
        if (this.disconnected) {
            ((DefaultFactHandle)factHandle).disconnect();
        }
        return factHandle;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String toString() {
        return "session.entryPoints(" + (this.entryPoint == null ? "DEFAULT" : this.entryPoint) + ").insert(" + this.object + ");";
    }
}

