/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.common.ActivationGroupNode;
import org.drools.common.ActivationNode;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.core.util.LinkedList;
import org.drools.core.util.Queue;
import org.drools.core.util.Queueable;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgendaItem
implements Activation,
Queueable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private LeftTuple tuple;
    private int salience;
    private int sequenence;
    private RuleTerminalNode rtn;
    private PropagationContext context;
    private long activationNumber;
    private Queue queue;
    private int index;
    private LinkedList justified;
    private boolean activated;
    private InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;

    public AgendaItem() {
    }

    public AgendaItem(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, RuleTerminalNode rtn) {
        this.tuple = tuple;
        this.context = context;
        this.salience = salience;
        this.rtn = rtn;
        this.activationNumber = activationNumber;
        this.index = -1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tuple = (LeftTuple)in.readObject();
        this.salience = in.readInt();
        this.sequenence = in.readInt();
        this.rtn = (RuleTerminalNode)in.readObject();
        this.context = (PropagationContext)in.readObject();
        this.activationNumber = in.readLong();
        this.queue = (Queue)in.readObject();
        this.index = in.readInt();
        this.justified = (LinkedList)in.readObject();
        this.activated = in.readBoolean();
        this.agendaGroup = (InternalAgendaGroup)in.readObject();
        this.activationGroupNode = (ActivationGroupNode)in.readObject();
        this.activationNode = (ActivationNode)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tuple);
        out.writeInt(this.salience);
        out.writeInt(this.sequenence);
        out.writeObject(this.rtn);
        out.writeObject(this.context);
        out.writeLong(this.activationNumber);
        out.writeObject(this.queue);
        out.writeInt(this.index);
        out.writeObject(this.justified);
        out.writeBoolean(this.activated);
        out.writeObject(this.agendaGroup);
        out.writeObject(this.activationGroupNode);
        out.writeObject(this.activationNode);
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.context;
    }

    public void setPropagationContext(PropagationContext context) {
        this.context = context;
    }

    @Override
    public Rule getRule() {
        return this.rtn.getRule();
    }

    @Override
    public LeftTuple getTuple() {
        return this.tuple;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public int getSequenence() {
        return this.sequenence;
    }

    public void setSequenence(int sequenence) {
        this.sequenence = sequenence;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public void addLogicalDependency(LogicalDependency node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList justified) {
        this.justified = justified;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String toString() {
        return "[Activation rule=" + this.rtn.getRule().getName() + ", act#=" + this.activationNumber + ", salience=" + this.salience + ", tuple=" + this.tuple + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof AgendaItem)) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rtn.getRule().equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    @Override
    public void enqueued(int index) {
        this.index = index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.activated = false;
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public AgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.rtn.getSubRule();
    }

    public RuleTerminalNode getRuleTerminalNode() {
        return this.rtn;
    }

    public List<FactHandle> getFactHandles() {
        InternalFactHandle[] factHandles = this.tuple.getFactHandles();
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            list.add(factHandle);
        }
        return Collections.unmodifiableList(list);
    }

    public String toExternalForm() {
        return "[ " + this.getRule().getName() + " active=" + this.activated + " ]";
    }

    public List<Object> getObjects() {
        InternalFactHandle[] factHandles = this.tuple.getFactHandles();
        ArrayList<Object> list = new ArrayList<Object>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            list.add(factHandle.getObject());
        }
        return Collections.unmodifiableList(list);
    }

    public Object getDeclarationValue(String variableName) {
        Declaration decl = this.getRule().getDeclaration(variableName);
        InternalFactHandle handle = this.tuple.get(decl);
        return decl.getValue(null, handle.getObject());
    }

    public List<String> getDeclarationIDs() {
        Declaration[] declArray = ((RuleTerminalNode)this.tuple.getLeftTupleSink()).getDeclarations();
        ArrayList<String> declarations = new ArrayList<String>();
        for (Declaration decl : declArray) {
            declarations.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(declarations);
    }
}

