/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.impl.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassPathResource
extends BaseResource {
    private UrlResource resource;

    public URLClassPathResource(String path) {
        ClassLoader classLoader = URLClassPathResource.class.getClassLoader();
        System.out.println("Converting '" + path + "' to URL.");
        System.out.println("Reource1: '" + classLoader.getResource(path));
        String url = classLoader.getResource(path).toString();
        this.resource = new UrlResource(url);
    }

    public String toString() {
        try {
            return "[URLClassPathResource url='" + (this.resource == null ? "null" : this.resource.getURL()) + "']";
        }
        catch (IOException ex) {
            Logger.getLogger(URLClassPathResource.class.getName()).log(Level.SEVERE, null, ex);
            return "[URLClassPathResource url='ERROR']";
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    @Override
    public boolean hasURL() {
        return this.resource.hasURL();
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        return this.resource.listResources();
    }

    @Override
    public long getLastModified() {
        return this.resource.getLastModified();
    }

    @Override
    public long getLastRead() {
        return this.resource.getLastRead();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public Reader getReader() throws IOException {
        return this.resource.getReader();
    }
}

