/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventFactHandle;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.time.impl.Timer;

public class RuleTerminalNode
extends BaseNode
implements LeftTupleSinkNode,
TerminalNode,
Externalizable {
    private int sequence = -1;
    private static final long serialVersionUID = 510L;
    private Rule rule;
    private GroupElement subrule;
    private LeftTupleSource tupleSource;
    private Declaration[] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.tupleSource = source;
        this.subrule = subrule;
        this.tupleMemoryEnabled = context.isTerminalNodeMemoryEnabled();
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.declarations = new Declaration[rule.getRequiredDeclarations().length];
        int i = 0;
        for (String str : rule.getRequiredDeclarations()) {
            this.declarations[i++] = decls.get(str);
        }
        Arrays.sort(this.declarations, SortDeclarations.instance);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.declarations = (Declaration[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.tupleSource);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.declarations);
    }

    public Rule getRule() {
        return this.rule;
    }

    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.rule.isEffective(tuple, workingMemory)) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        if (this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            agenda.increaseDormantActivations();
            return;
        }
        Timer timer = this.rule.getTimer();
        if (timer != null) {
            ScheduledAgendaItem item = agenda.createScheduledAgendaItem(tuple, context, this);
            agenda.scheduleItem(item, workingMemory);
            tuple.setObject(item);
            item.setActivated(true);
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
        } else {
            if (this.rule.getCalendars() != null) {
                long timestamp = workingMemory.getSessionClock().getCurrentTime();
                for (String cal : this.rule.getCalendars()) {
                    if (workingMemory.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                    return;
                }
            }
            AgendaItem item = agenda.createAgendaItem(tuple, this.rule.getSalience().getValue(tuple, this.rule, workingMemory), context, this);
            item.setSequenence(this.sequence);
            tuple.setObject(item);
            boolean added = agenda.addActivation(item);
            if (added) {
                item.setActivated(true);
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
            }
        }
        agenda.increaseActiveActivations();
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Activation activation = (Activation)leftTuple.getObject();
        if (activation == null) {
            return;
        }
        if (activation.isActivated()) {
            if (context.getType() == 5 && context.getFactHandleOrigin() != null) {
                EventFactHandle efh = (EventFactHandle)context.getFactHandleOrigin();
                efh.increaseActivationsCount();
            } else {
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                if (activation.getActivationNode() != null) {
                    InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)activation.getActivationNode().getParentContainer();
                    ruleFlowGroup.removeActivation(activation);
                }
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.WME_MODIFY);
                ((InternalAgenda)workingMemory.getAgenda()).decreaseActiveActivations();
            }
        } else {
            ((InternalAgenda)workingMemory.getAgenda()).decreaseDormantActivations();
        }
        workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, context, this.rule);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.rule.isEffective(leftTuple, workingMemory)) {
            return;
        }
        AgendaItem item = (AgendaItem)leftTuple.getObject();
        if (item != null && item.isActivated()) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        if (this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            agenda.increaseDormantActivations();
            return;
        }
        Timer timer = this.rule.getTimer();
        if (timer != null) {
            if (item == null) {
                item = agenda.createScheduledAgendaItem(leftTuple, context, this);
            }
            agenda.scheduleItem((ScheduledAgendaItem)item, workingMemory);
            item.setActivated(true);
            ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
        } else {
            if (this.rule.getCalendars() != null) {
                long timestamp = workingMemory.getSessionClock().getCurrentTime();
                for (String cal : this.rule.getCalendars()) {
                    if (workingMemory.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                    return;
                }
            }
            if (item == null) {
                item = agenda.createAgendaItem(leftTuple, this.rule.getSalience().getValue(leftTuple, this.rule, workingMemory), context, this);
                item.setSequenence(this.sequence);
            } else {
                item.setSalience(this.rule.getSalience().getValue(leftTuple, this.rule, workingMemory));
                item.setPropagationContext(context);
            }
            boolean added = agenda.addActivation(item);
            item.setActivated(added);
            if (added) {
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
            }
        }
        agenda.increaseActiveActivations();
    }

    public String toString() {
        return "[RuleTerminalNode(" + this.getId() + "): rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
        context.setCleanupAdapter(new RTNCleanupAdapter(this));
        this.tupleSource.remove(context, builder, this, workingMemories);
        for (InternalWorkingMemory workingMemory : workingMemories) {
            workingMemory.executeQueuedActions();
        }
        context.setCleanupAdapter(adapter);
    }

    public boolean isInUse() {
        return false;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule);
    }

    public short getType() {
        return 9;
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getLeftTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getObject();
            if (activation.isActivated()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.CLEAR);
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
            workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

