/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Accumulator;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.Tuple;
import org.drools.spi.Wireable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accumulate
extends ConditionalElement
implements Wireable,
PatternSource {
    private static final long serialVersionUID = 510L;
    private Accumulator[] accumulators;
    private RuleConditionElement source;
    private Declaration[] requiredDeclarations;
    private Declaration[] innerDeclarations;
    private List<Accumulate> cloned = Collections.emptyList();

    public Accumulate() {
    }

    public Accumulate(RuleConditionElement source) {
        this(source, new Declaration[0], new Declaration[0], null);
    }

    public Accumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Declaration[] innerDeclarations) {
        this(source, requiredDeclarations, innerDeclarations, null);
    }

    public Accumulate(RuleConditionElement source, Declaration[] requiredDeclarations, Declaration[] innerDeclarations, Accumulator[] accumulators) {
        this.source = source;
        this.requiredDeclarations = requiredDeclarations;
        this.innerDeclarations = innerDeclarations;
        this.accumulators = accumulators;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accumulators = new Accumulator[in.readInt()];
        for (int i = 0; i < this.accumulators.length; ++i) {
            this.accumulators[i] = (Accumulator)in.readObject();
        }
        this.source = (RuleConditionElement)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.innerDeclarations = (Declaration[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.accumulators.length);
        for (Accumulator acc : this.accumulators) {
            if (acc instanceof CompiledInvoker) {
                out.writeObject(null);
                continue;
            }
            out.writeObject(acc);
        }
        out.writeObject(this.source);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.innerDeclarations);
        out.writeObject(this.cloned);
    }

    public Accumulator[] getAccumulators() {
        return this.accumulators;
    }

    @Override
    public void wire(Object object) {
        this.setAccumulators(new Accumulator[]{(Accumulator)object});
        for (Accumulate clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setAccumulators(Accumulator[] accumulators) {
        this.accumulators = accumulators;
    }

    public Serializable[] createContext() {
        Serializable[] ctxs = new Serializable[this.accumulators.length];
        for (int i = 0; i < ctxs.length; ++i) {
            ctxs[i] = this.accumulators[i].createContext();
        }
        return ctxs;
    }

    public void init(Object[] workingMemoryContext, Object[] context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].init(workingMemoryContext[i], context[i], leftTuple, this.requiredDeclarations, workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public void accumulate(Object[] workingMemoryContext, Object[] context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].accumulate(workingMemoryContext[i], context[i], leftTuple, handle, this.requiredDeclarations, this.innerDeclarations, workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public void reverse(Object[] workingMemoryContext, Object[] context, Tuple leftTuple, InternalFactHandle handle, WorkingMemory workingMemory) {
        try {
            for (int i = 0; i < this.accumulators.length; ++i) {
                this.accumulators[i].reverse(workingMemoryContext[i], context[i], leftTuple, handle, this.requiredDeclarations, this.innerDeclarations, workingMemory);
            }
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public Object[] getResult(Object[] workingMemoryContext, Object[] context, Tuple leftTuple, WorkingMemory workingMemory) {
        try {
            Object[] results = new Object[this.accumulators.length];
            for (int i = 0; i < this.accumulators.length; ++i) {
                results[i] = this.accumulators[i].getResult(workingMemoryContext[i], context[i], leftTuple, this.requiredDeclarations, workingMemory);
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public boolean supportsReverse() {
        boolean supports = true;
        for (Accumulator acc : this.accumulators) {
            if (acc.supportsReverse()) continue;
            supports = false;
            break;
        }
        return supports;
    }

    @Override
    public Object clone() {
        Accumulate clone = new Accumulate(this.source, this.requiredDeclarations, this.innerDeclarations, this.accumulators);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<Accumulate>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public RuleConditionElement getSource() {
        return this.source;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.source.getInnerDeclarations();
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return Collections.emptyMap();
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.source.getInnerDeclarations().get(identifier);
    }

    public Object[] createWorkingMemoryContext() {
        Object[] ctx = new Object[this.accumulators.length];
        for (int i = 0; i < this.accumulators.length; ++i) {
            ctx[i] = this.accumulators[i].createWorkingMemoryContext();
        }
        return ctx;
    }

    @Override
    public List<RuleConditionElement> getNestedElements() {
        return Collections.singletonList(this.source);
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }
}

