/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.osjava.sj.loader.PoolSetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJDataSource
implements DataSource {
    private PrintWriter pw;
    private String username;
    private String password;
    private String url;
    private String driver;
    private Properties properties;
    private String poolUrl = null;

    public SJDataSource(String driver, String url, String username, String password, Properties properties) {
        SJDataSource.ensureLoaded(driver);
        this.driver = driver;
        this.url = url;
        this.pw = new PrintWriter(System.err);
        this.username = username;
        this.password = password;
        this.properties = properties;
    }

    private static boolean ensureLoaded(String name) {
        try {
            Class.forName(name).newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String tmpUrl = this.url;
        String pool = this.properties.getProperty("pool");
        if (pool != null) {
            String string = this.poolUrl;
            synchronized (string) {
                if (this.poolUrl == null) {
                    PoolSetup.setupConnection(pool, this.url, username, password, this.properties);
                    this.poolUrl = PoolSetup.getUrl(pool);
                }
            }
            tmpUrl = this.poolUrl;
        }
        if (username == null || password == null) {
            return DriverManager.getConnection(tmpUrl);
        }
        return DriverManager.getConnection(tmpUrl, username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pw;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.pw = pw;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
    }

    public String toString() {
        return this.driver + "::::" + this.url + "::::" + this.username;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SJDataSource other = (SJDataSource)obj;
        return other.url.equals(this.url) && other.driver.equals(this.driver) && other.username.equals(this.username);
    }

    public int hashCode() {
        return this.url.hashCode() & this.username.hashCode() & this.driver.hashCode();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("This object is not a wrapper");
    }
}

