/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.parser.ParserFactory;
import org.apache.abdera.util.Constants;
import org.apache.abdera.writer.StreamWriter;
import org.apache.abdera.writer.Writer;
import org.apache.abdera.writer.WriterFactory;
import org.apache.abdera.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceUtil
implements Constants {
    ServiceUtil() {
    }

    public static Object newInstance(String id, String _default, Abdera abdera) {
        return ServiceUtil.locate(id, _default, abdera);
    }

    public static Object newInstance(String id, String _default, Abdera abdera, Object ... args) {
        return ServiceUtil.locate(id, _default, abdera, args);
    }

    public static XPath newXPathInstance(Abdera abdera) {
        return (XPath)ServiceUtil.newInstance("org.apache.abdera.xpath.XPath", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.xpath.XPath", "org.apache.abdera.parser.stax.FOMXPath"), abdera);
    }

    public static Parser newParserInstance(Abdera abdera) {
        return (Parser)ServiceUtil.newInstance("org.apache.abdera.parser.Parser", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.parser.Parser", "org.apache.abdera.parser.stax.FOMParser"), abdera);
    }

    public static Factory newFactoryInstance(Abdera abdera) {
        return (Factory)ServiceUtil.newInstance("org.apache.abdera.factory.Factory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.factory.Factory", "org.apache.abdera.parser.stax.FOMFactory"), abdera);
    }

    public static ParserFactory newParserFactoryInstance(Abdera abdera) {
        return (ParserFactory)ServiceUtil.newInstance("org.apache.abdera.parser.ParserFactory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.parser.ParserFactory", "org.apache.abdera.parser.stax.FOMParserFactory"), abdera);
    }

    public static WriterFactory newWriterFactoryInstance(Abdera abdera) {
        return (WriterFactory)ServiceUtil.newInstance("org.apache.abdera.writer.WriterFactory", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.WriterFactory", "org.apache.abdera.parser.stax.FOMWriterFactory"), abdera);
    }

    public static Writer newWriterInstance(Abdera abdera) {
        return (Writer)ServiceUtil.newInstance("org.apache.abdera.writer.Writer", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.Writer", "org.apache.abdera.parser.stax.FOMWriter"), abdera);
    }

    public static StreamWriter newStreamWriterInstance(Abdera abdera) {
        return (StreamWriter)ServiceUtil.newInstance("org.apache.abdera.writer.StreamWriter", abdera.getConfiguration().getConfigurationOption("org.apache.abdera.writer.StreamWriter", "org.apache.abdera.parser.stax.StaxStreamWriter"), abdera);
    }

    public static Object locate(String id, String _default, Abdera abdera) {
        Object object = ServiceUtil.locate(id, abdera);
        if (object == null && _default != null) {
            object = ServiceUtil.locateInstance(_default, abdera);
        }
        return object;
    }

    public static Object locate(String id, String _default, Abdera abdera, Object ... args) {
        Object object = ServiceUtil.locate(id, abdera);
        if (object == null && _default != null) {
            object = ServiceUtil.locateInstance(_default, abdera, args);
        }
        return object;
    }

    public static Object locate(String id, Abdera abdera) {
        Object service = ServiceUtil.checkAbderaConfiguration(id, abdera);
        return service != null ? service : ServiceUtil.checkMetaInfServices(id, abdera);
    }

    private static Object _create(Class _class, Abdera abdera) {
        if (_class == null) {
            return null;
        }
        try {
            if (abdera != null) {
                Constructor c = _class.getConstructor(Abdera.class);
                return c.newInstance(abdera);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return _class.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object _create(Class _class, Abdera abdera, Object ... args) {
        Class[] types = null;
        Object[] values = null;
        if (_class == null) {
            return null;
        }
        try {
            if (abdera != null) {
                types = new Class[args.length + 1];
                values = new Object[args.length + 1];
                types[0] = Abdera.class;
                values[0] = abdera;
                for (int n = 0; n < args.length; ++n) {
                    types[n + 1] = args[n].getClass();
                    values[n + 1] = args[n];
                }
                Constructor c = _class.getConstructor(types);
                return c.newInstance(values);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            types = new Class[args.length];
            for (int n = 0; n < args.length; ++n) {
                types[n] = args[n].getClass();
            }
            return _class.getConstructor(types).newInstance(args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object locateInstance(String id, Abdera abdera) {
        return ServiceUtil.locateInstance(id, abdera, false);
    }

    public static Object locateInstance(String id, Abdera abdera, boolean classesonly) {
        try {
            Class<?> _class = ServiceUtil.loadClass(id, ServiceUtil.class);
            return classesonly ? _class : ServiceUtil._create(_class, abdera);
        }
        catch (Exception e) {
            try {
                Class<?> _class = ClassLoader.getSystemClassLoader().loadClass(id);
                return classesonly ? _class : ServiceUtil._create(_class, abdera);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static Object locateInstance(String id, Abdera abdera, Object ... args) {
        try {
            Class<?> _class = ServiceUtil.loadClass(id, ServiceUtil.class);
            return ServiceUtil._create(_class, abdera, args);
        }
        catch (Exception e) {
            try {
                Class<?> _class = ClassLoader.getSystemClassLoader().loadClass(id);
                return ServiceUtil._create(_class, abdera, args);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static InputStream locateStream(String id) {
        InputStream in = ServiceUtil.getResourceAsStream(id, ServiceUtil.class);
        return in != null ? in : ClassLoader.getSystemResourceAsStream(id);
    }

    public static Enumeration<URL> locateResources(String id) {
        try {
            return ServiceUtil.getResources(id, ServiceUtil.class);
        }
        catch (Exception e) {
            try {
                return ClassLoader.getSystemResources(id);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static Object checkAbderaConfiguration(String id, Abdera abdera) {
        String s = abdera.getConfiguration().getConfigurationOption(id);
        return s != null ? ServiceUtil.locateInstance(id, abdera) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object checkMetaInfServices(String id, Abdera abdera) {
        Object object = null;
        String sid = "META-INF/services/" + id;
        BufferedReader buf = null;
        try {
            String line;
            InputStream is = ServiceUtil.locateStream(sid);
            if (is != null && (line = (buf = new BufferedReader(new InputStreamReader(is))).readLine()) != null) {
                String s = line.split("#", 2)[0].trim();
                object = ServiceUtil.locateInstance(s, abdera);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (IOException ioe) {}
            }
        }
        return object;
    }

    protected static synchronized List<ExtensionFactory> loadExtensionFactories() {
        List<ExtensionFactory> factories = ServiceUtil._loadimpls("META-INF/services/org.apache.abdera.factory.ExtensionFactory");
        return factories;
    }

    public static synchronized <T> List<T> loadimpls(String sid) {
        return ServiceUtil.loadimpls(sid, false);
    }

    public static synchronized <T> List<T> loadimpls(String sid, boolean classesonly) {
        return ServiceUtil._loadimpls(sid, classesonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> List<T> _loadimpls(String sid, boolean classesonly) {
        List<Object> impls = Collections.synchronizedList(new ArrayList());
        try {
            Enumeration<URL> e = ServiceUtil.locateResources(sid);
            while (e.hasMoreElements()) {
                BufferedReader buf = null;
                try {
                    String line;
                    URL url = e.nextElement();
                    InputStream is = url.openStream();
                    if (is == null) continue;
                    buf = new BufferedReader(new InputStreamReader(is));
                    while ((line = buf.readLine()) != null) {
                        Object impl;
                        String s = line.split("#", 2)[0].trim();
                        if ("".equals(s) || (impl = ServiceUtil.locateInstance(s, null)) == null) continue;
                        impls.add(impl);
                    }
                }
                catch (Exception ex) {}
                continue;
                finally {
                    if (buf == null) continue;
                    try {
                        buf.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return impls;
    }

    protected static <T> List<T> _loadimpls(String sid) {
        return ServiceUtil._loadimpls(sid, false);
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && resourceName.startsWith("/")) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourceName.substring(1));
        }
        if (url == null) {
            url = ServiceUtil.class.getClassLoader().getResource(resourceName);
        }
        if (url == null && resourceName.startsWith("/")) {
            url = ServiceUtil.class.getClassLoader().getResource(resourceName.substring(1));
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ServiceUtil.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static Enumeration<URL> getResources(String resourceName, Class<?> callingClass) throws IOException {
        ClassLoader cl;
        Enumeration<URL> url = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        if (url == null && resourceName.startsWith("/")) {
            url = Thread.currentThread().getContextClassLoader().getResources(resourceName.substring(1));
        }
        if (url == null) {
            url = ServiceUtil.class.getClassLoader().getResources(resourceName);
        }
        if (url == null && resourceName.startsWith("/")) {
            url = ServiceUtil.class.getClassLoader().getResources(resourceName.substring(1));
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResources(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ServiceUtil.getResources('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ServiceUtil.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
            return ServiceUtil.loadClass2(className, callingClass);
        }
        catch (ClassNotFoundException e) {
            return ServiceUtil.loadClass2(className, callingClass);
        }
    }

    private static Class<?> loadClass2(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            try {
                return ServiceUtil.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException exc) {
                return callingClass.getClassLoader().loadClass(className);
            }
        }
    }
}

