/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.template.parser.DecisionTableParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionType {
    public static final EnumSet<Code> ATTRIBUTE_CODE_SET = EnumSet.range(Code.SALIENCE, Code.RULEFLOWGROUP);
    private static final Map<String, Code> tag2code = new HashMap<String, Code>();
    private Code code;
    private SourceBuilder sourceBuilder = null;

    ActionType(Code actionTypeCode) {
        this.code = actionTypeCode;
    }

    public static EnumSet<Code> getAttributeCodeSet() {
        return ATTRIBUTE_CODE_SET;
    }

    public static Map<String, Code> getTag2code() {
        return tag2code;
    }

    public Code getCode() {
        return this.code;
    }

    public void setSourceBuilder(SourceBuilder src) {
        this.sourceBuilder = src;
    }

    public SourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public static void addNewActionType(Map<Integer, ActionType> actionTypeMap, String value, int column, int row) {
        String ucValue = value.toUpperCase();
        Code code = tag2code.get(ucValue);
        if (code == null) {
            code = tag2code.get(ucValue.substring(0, 1));
        }
        if (code != null) {
            int count = 0;
            for (ActionType at : actionTypeMap.values()) {
                if (at.getCode() != code) continue;
                ++count;
            }
            if (count >= code.getMaxCount()) {
                throw new DecisionTableParseException("Maximum number of " + code.getColHeader() + "/" + code.getColShort() + " columns is " + code.getMaxCount() + ", in cell " + RuleSheetParserUtil.rc2name(row, column));
            }
        } else {
            throw new DecisionTableParseException("Invalid column header: " + value + ", should be CONDITION, ACTION or attribute, " + "in cell " + RuleSheetParserUtil.rc2name(row, column));
        }
        actionTypeMap.put(new Integer(column), new ActionType(code));
    }

    public void addTemplate(int row, int column, String content) {
        if (this.sourceBuilder == null) {
            throw new DecisionTableParseException("Unexpected content \"" + content + "\" in cell " + RuleSheetParserUtil.rc2name(row, column) + ", leave this cell blank");
        }
        this.sourceBuilder.addTemplate(row, column, content);
    }

    public void addCellValue(int row, int column, String content) {
        int idx = content.indexOf("\"");
        if (idx > 0 && content.indexOf("\"", idx) > -1) {
            content = content.replace("\"", "\\\"");
        }
        this.sourceBuilder.addCellValue(row, column, content);
    }

    static {
        for (Code code : EnumSet.allOf(Code.class)) {
            tag2code.put(code.colHeader, code);
            tag2code.put(code.colShort, code);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        CONDITION("CONDITION", "C"),
        ACTION("ACTION", "A"),
        NAME("NAME", "N", 1),
        DESCRIPTION("DESCRIPTION", "I"),
        SALIENCE("PRIORITY", "P", 1),
        DURATION("DURATION", "D", 1),
        NOLOOP("NO-LOOP", "U", 1),
        LOCKONACTIVE("LOCK-ON-ACTIVE", "L", 1),
        AUTOFOCUS("AUTO-FOCUS", "F", 1),
        ACTIVATIONGROUP("ACTIVATION-GROUP", "X", 1),
        AGENDAGROUP("AGENDA-GROUP", "G", 1),
        RULEFLOWGROUP("RULEFLOW-GROUP", "R", 1),
        METADATA("METADATA", "@");

        private String colHeader;
        private String colShort;
        private int maxCount;

        private Code(String colHeader, String colShort, int maxCount) {
            this.colHeader = colHeader;
            this.colShort = colShort;
            this.maxCount = maxCount;
        }

        private Code(String colHeader, String colShort) {
            this(colHeader, colShort, Integer.MAX_VALUE);
        }

        public String getColHeader() {
            return this.colHeader;
        }

        public String getColShort() {
            return this.colShort;
        }

        public int getMaxCount() {
            return this.maxCount;
        }
    }
}

