/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.runtime.process.WorkItem;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;

public class HumanTaskNodeInstance
extends WorkItemNodeInstance {
    private static final long serialVersionUID = 510L;
    private transient SwimlaneContextInstance swimlaneContextInstance;

    public HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        WorkItem workItem = super.createWorkItem(workItemNode);
        String actorId = this.assignWorkItem(workItem);
        if (actorId != null) {
            ((org.drools.process.instance.WorkItem)workItem).setParameter("ActorId", (Object)actorId);
        }
        return workItem;
    }

    protected String assignWorkItem(WorkItem workItem) {
        String actorId = null;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null) {
            actorId = swimlaneContextInstance.getActorId(swimlaneName);
        }
        if (actorId == null && (actorId = (String)workItem.getParameter("ActorId")) != null && swimlaneContextInstance != null) {
            swimlaneContextInstance.setActorId(swimlaneName, actorId);
        }
        return actorId;
    }

    private SwimlaneContextInstance getSwimlaneContextInstance(String swimlaneName) {
        if (this.swimlaneContextInstance == null) {
            if (swimlaneName == null) {
                return null;
            }
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName);
            if (swimlaneContextInstance == null) {
                throw new IllegalArgumentException("Could not find swimlane context instance");
            }
            this.swimlaneContextInstance = swimlaneContextInstance;
        }
        return this.swimlaneContextInstance;
    }

    public void triggerCompleted(WorkItem workItem) {
        String newActorId;
        String swimlaneName = this.getHumanTaskNode().getSwimlane();
        SwimlaneContextInstance swimlaneContextInstance = this.getSwimlaneContextInstance(swimlaneName);
        if (swimlaneContextInstance != null && (newActorId = (String)workItem.getResult("ActorId")) != null) {
            swimlaneContextInstance.setActorId(swimlaneName, newActorId);
        }
        super.triggerCompleted(workItem);
    }
}

