/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnitOfWorkProcessor
extends DelegateAsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(UnitOfWorkProcessor.class);
    private final RouteContext routeContext;
    private final String routeId;

    public UnitOfWorkProcessor(Processor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(AsyncProcessor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(RouteContext routeContext, Processor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    public UnitOfWorkProcessor(RouteContext routeContext, AsyncProcessor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    public String toString() {
        return "UnitOfWork(" + this.processor + ")";
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (this.routeId != null && exchange.getFromRouteId() == null) {
            exchange.setFromRouteId(this.routeId);
        }
        if (exchange.getUnitOfWork() == null) {
            final DefaultUnitOfWork uow = new DefaultUnitOfWork(exchange);
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            return this.processor.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(boolean doneSync) {
                    try {
                        callback.done(doneSync);
                    }
                    finally {
                        UnitOfWorkProcessor.this.doneUow(uow, exchange);
                    }
                }
            });
        }
        return this.processor.process(exchange, callback);
    }

    private void doneUow(DefaultUnitOfWork uow, Exchange exchange) {
        try {
            if (exchange.getUnitOfWork() != null) {
                exchange.getUnitOfWork().done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored."), e);
        }
        try {
            uow.stop();
        }
        catch (Throwable e) {
            LOG.warn((Object)("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored."), e);
        }
        exchange.setUnitOfWork(null);
    }
}

