/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import org.drools.examples.conway.Cell;
import org.drools.examples.conway.CellGrid;
import org.drools.examples.conway.CellState;

public class CellGridCanvas
extends Canvas {
    private static final long serialVersionUID = 510L;
    private static final Color BACKGROUND_COLOR = Color.gray;
    private static final Color GRID_COLOR = BACKGROUND_COLOR.brighter();
    private Image offScreenImage;
    private Image backgroundImage;
    private final int cellSize;
    private final CellGrid cellGrid;
    private final Image liveCellImage = new ImageIcon(CellGridCanvas.class.getResource("/org/drools/examples/conway/liveCellImage.gif")).getImage();

    public CellGridCanvas(final CellGrid cellGrid) {
        this.cellGrid = cellGrid;
        this.cellSize = this.liveCellImage.getWidth(this);
        this.setBackground(GRID_COLOR);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CellGridCanvas.this.toggleCellAt(e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Cell cell = CellGridCanvas.this.getCellAtPoint(e.getX(), e.getY());
                if (cell != null) {
                    cellGrid.updateCell(cell, CellState.LIVE);
                    CellGridCanvas.this.repaint();
                }
            }
        });
    }

    private void toggleCellAt(int x, int y) {
        Cell cell = this.getCellAtPoint(x, y);
        if (cell != null) {
            if (cell.getCellState() == CellState.LIVE) {
                this.cellGrid.updateCell(cell, CellState.DEAD);
            } else {
                this.cellGrid.updateCell(cell, CellState.LIVE);
            }
            this.repaint();
        }
    }

    private Cell getCellAtPoint(int x, int y) {
        Cell cell = null;
        int column = x / this.cellSize;
        int row = y / this.cellSize;
        int numberOfColumns = this.cellGrid.getNumberOfColumns();
        int numberOfRows = this.cellGrid.getNumberOfRows();
        if (column >= 0 && column < numberOfColumns && row >= 0 && row < numberOfRows) {
            cell = this.cellGrid.getCellAt(row, column);
        }
        return cell;
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null) {
            this.offScreenImage = this.createImage(d.width, d.height);
        }
        this.paint(this.offScreenImage.getGraphics());
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics g) {
        int numberOfColumns = this.cellGrid.getNumberOfColumns();
        int numberOfRows = this.cellGrid.getNumberOfRows();
        if (this.backgroundImage == null) {
            Dimension d = this.getSize();
            this.backgroundImage = this.createImage(d.width, d.height);
            Graphics backgroundImageGraphics = this.backgroundImage.getGraphics();
            backgroundImageGraphics.setColor(this.getBackground());
            backgroundImageGraphics.fillRect(0, 0, d.width, d.height);
            backgroundImageGraphics.setColor(BACKGROUND_COLOR);
            backgroundImageGraphics.fillRect(0, 0, this.cellSize * numberOfColumns - 1, this.cellSize * numberOfRows - 1);
            backgroundImageGraphics.setColor(GRID_COLOR);
            for (int x = 1; x < numberOfColumns; ++x) {
                backgroundImageGraphics.drawLine(x * this.cellSize - 1, 0, x * this.cellSize - 1, this.cellSize * numberOfRows - 1);
            }
            for (int y = 1; y < numberOfRows; ++y) {
                backgroundImageGraphics.drawLine(0, y * this.cellSize - 1, this.cellSize * numberOfColumns - 1, y * this.cellSize - 1);
            }
        }
        g.drawImage(this.backgroundImage, 0, 0, null);
        for (int row = 0; row < numberOfRows; ++row) {
            for (int column = 0; column < numberOfColumns; ++column) {
                Cell cell = this.cellGrid.getCellAt(row, column);
                if (cell.getCellState() != CellState.LIVE) continue;
                g.drawImage(this.liveCellImage, column * this.cellSize, row * this.cellSize, this);
            }
        }
    }

    public Dimension getPreferredSize() {
        int numberOfColumns = this.cellGrid.getNumberOfColumns();
        int numberOfRows = this.cellGrid.getNumberOfRows();
        return new Dimension(this.cellSize * numberOfColumns, this.cellSize * numberOfRows);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.cellSize, this.cellSize);
    }
}

