/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.finder.FindEvent;
import org.apache.commons.finder.FindListener;
import org.apache.commons.finder.Finder;
import org.apache.commons.finder.FindingFilter;

public class FileFinder
implements Finder {
    private List findListeners;

    public File[] find(File directory) {
        return this.find(directory, Collections.EMPTY_MAP);
    }

    public File[] find(File directory, Map options) {
        ArrayList retlist = new ArrayList();
        this.find(directory, options, retlist);
        File[] files = retlist.toArray(new File[retlist.size()]);
        return files;
    }

    public void find(File directory, Map options, List foundFiles) {
        if (foundFiles == null) {
            throw new IllegalArgumentException("foundFiles list cannot be null");
        }
        this.notifyDirectoryStarted(directory);
        boolean depthFirst = FileFinder.toBoolean(options.get("DEPTH"));
        int maxDepth = FileFinder.toInt(options.get("MAXDEPTH"));
        int minDepth = FileFinder.toInt(options.get("MINDEPTH"));
        boolean ignoreHiddenDirs = FileFinder.toBoolean(options.get("IGNORE_HIDDEN_DIRS"));
        FindingFilter filter = new FindingFilter(options);
        int startIdx = foundFiles.size();
        this.find(directory, filter, depthFirst, foundFiles);
        if (filter.accept(directory)) {
            if (depthFirst) {
                foundFiles.add(directory);
            } else {
                foundFiles.add(0, directory);
            }
        }
        int endIdx = foundFiles.size();
        this.notifyDirectoryFinished(directory, foundFiles, startIdx, endIdx);
    }

    private void find(File directory, FindingFilter filter, boolean depthFirst, List retlist) {
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        int sz = list.length;
        for (int i = 0; i < sz; ++i) {
            File tmp = list[i];
            if (!depthFirst && filter.accept(tmp)) {
                retlist.add(tmp);
                this.notifyFileFound(directory, tmp);
            }
            if (tmp.isDirectory()) {
                this.notifyDirectoryStarted(tmp);
                int startIdx = retlist.size();
                this.find(tmp, filter, depthFirst, retlist);
                int endIdx = retlist.size();
                this.notifyDirectoryFinished(tmp, retlist, startIdx, endIdx);
            }
            if (!depthFirst || !filter.accept(tmp)) continue;
            retlist.add(tmp);
            this.notifyFileFound(directory, tmp);
        }
    }

    public void addFindListener(FindListener listener) {
        if (this.findListeners == null) {
            this.findListeners = new ArrayList();
        }
        this.findListeners.add(listener);
    }

    public void removeFindListener(FindListener listener) {
        if (this.findListeners != null) {
            this.findListeners.remove(listener);
        }
    }

    protected void notifyDirectoryStarted(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        if (this.findListeners != null) {
            FindEvent fe = new FindEvent(this, "directoryStarted", directory);
            Iterator it = this.findListeners.iterator();
            while (it.hasNext()) {
                FindListener findListener = (FindListener)it.next();
                findListener.directoryStarted(fe);
            }
        }
    }

    protected void notifyDirectoryFinished(File directory, File[] files) {
        if (!directory.isDirectory()) {
            return;
        }
        if (this.findListeners != null) {
            FindEvent fe = new FindEvent((Finder)this, "directoryFinished", directory, files);
            Iterator it = this.findListeners.iterator();
            while (it.hasNext()) {
                FindListener findListener = (FindListener)it.next();
                findListener.directoryFinished(fe);
            }
        }
    }

    private void notifyDirectoryFinished(File directory, List files, int startIdx, int endIdx) {
        if (!directory.isDirectory() || this.findListeners == null || this.findListeners.size() == 0) {
            return;
        }
        File[] filesa = files.subList(startIdx, endIdx).toArray(new File[endIdx - startIdx]);
        this.notifyDirectoryFinished(directory, filesa);
    }

    protected void notifyFileFound(File directory, File file) {
        if (file.isDirectory()) {
            return;
        }
        if (this.findListeners != null) {
            FindEvent fe = new FindEvent((Finder)this, "fileFound", directory, file);
            Iterator it = this.findListeners.iterator();
            while (it.hasNext()) {
                FindListener findListener = (FindListener)it.next();
                findListener.fileFound(fe);
            }
        }
    }

    private static int toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String str = obj.toString();
        try {
            return Integer.parseInt(str.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("String argument " + str + " must be parseable as an integer");
        }
    }

    private static boolean toBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = obj.toString();
        return new Boolean(str);
    }
}

