/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder.filters;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class RegexFilter
extends AbstractFileFilter {
    private boolean ignoreCase;
    private String regex;
    private Pattern pattern;

    public RegexFilter(String regex, boolean ignoreCase) {
        this.regex = regex;
        this.ignoreCase = ignoreCase;
        this.pattern = ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean accept(File file) {
        return this.pattern.matcher(file.getPath()).matches();
    }

    public String toString() {
        return "RefexFilter{regex=[" + this.regex + "]" + ", ignoreCase=" + this.ignoreCase + "}";
    }
}

