/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger {
    private List<LogEvent> events = new ArrayList<LogEvent>();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;
    private boolean split = true;
    private boolean initialized = false;
    protected boolean terminate = false;

    public WorkingMemoryFileLogger() {
    }

    public WorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public WorkingMemoryFileLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.events = (List)in.readObject();
        this.fileName = (String)in.readObject();
        this.maxEventsInMemory = in.readInt();
        this.nbOfFile = in.readInt();
        this.split = in.readBoolean();
        this.initialized = in.readBoolean();
        this.terminate = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.events);
        out.writeObject(this.fileName);
        out.writeInt(this.maxEventsInMemory);
        out.writeInt(this.nbOfFile);
        out.writeBoolean(this.split);
        out.writeBoolean(this.initialized);
        out.writeBoolean(this.terminate);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeToDisk() {
        block15: {
            if (!this.initialized) {
                this.initializeLog();
            }
            fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
                    xstream = new XStream();
                    eventsToWrite = null;
                    var4_6 = this.events;
                    synchronized (var4_6) {
                        eventsToWrite = new ArrayList<LogEvent>(this.events);
                        this.clear();
                    }
                    for (LogEvent event : eventsToWrite) {
                        fileWriter.write(xstream.toXML((Object)event) + "\n");
                    }
                    var7_8 = null;
                    if (fileWriter == null) break block15;
                }
                catch (FileNotFoundException exc) {
                    throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    var7_9 = null;
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Exception e) {}
                    }
                    break block15;
                }
            }
            catch (Throwable var6_14) {
                var7_10 = null;
                if (fileWriter == null) throw var6_14;
                ** try [egrp 3[TRYBLOCK] [7 : 230->237)] { 
lbl36:
                // 1 sources

                fileWriter.close();
                throw var6_14;
lbl38:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                throw var6_14;
            }
            try {}
            catch (Exception e) {}
            fileWriter.close();
        }
        if (this.terminate) {
            this.closeLog();
            this.terminate = true;
            return;
        }
        if (this.split == false) return;
        this.closeLog();
        ++this.nbOfFile;
        this.initialized = false;
    }

    private void initializeLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false);
            writer.append("<object-stream>\n");
            writer.close();
            this.initialized = true;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private void closeLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
            writer.append("</object-stream>\n");
            writer.close();
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not close the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }

    public void setMaxEventsInMemory(int maxEventsInMemory) {
        this.maxEventsInMemory = maxEventsInMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEventCreated(LogEvent logEvent) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(logEvent);
            if (this.events.size() > this.maxEventsInMemory) {
                this.writeToDisk();
            }
        }
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public void stop() {
        if (this.terminate) {
            throw new IllegalStateException("Logger has already been closed.");
        }
        this.terminate = true;
        this.writeToDisk();
    }
}

