/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import org.drools.examples.conway.AgendaGroupDelegate;
import org.drools.examples.conway.Cell;
import org.drools.examples.conway.CellGrid;
import org.drools.examples.conway.CellState;
import org.drools.examples.conway.ConwayRuleDelegate;
import org.drools.examples.conway.RuleFlowDelegate;
import org.drools.examples.conway.patterns.ConwayPattern;
import org.drools.runtime.StatefulKnowledgeSession;

public class CellGridImpl
implements CellGrid {
    private final Cell[][] cells;
    private final StatefulKnowledgeSession session;
    private final ConwayRuleDelegate delegate;

    public CellGridImpl(int rows, int columns, int executionControl) {
        this.cells = new Cell[rows][columns];
        this.delegate = executionControl == 1 ? new RuleFlowDelegate() : new AgendaGroupDelegate();
        this.session = this.delegate.getSession();
        this.session.insert(this);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Cell newCell;
                this.cells[row][column] = newCell = new Cell(column, row);
                this.session.insert(newCell);
            }
        }
        this.delegate.init();
    }

    public Cell getCellAt(int row, int column) {
        return this.cells[row][column];
    }

    public int getNumberOfRows() {
        return this.cells.length;
    }

    public int getNumberOfColumns() {
        return this.cells[0].length;
    }

    public boolean nextGeneration() {
        return this.delegate.nextGeneration();
    }

    public void killAll() {
        this.delegate.killAll();
    }

    public void setPattern(ConwayPattern pattern) {
        boolean[][] gridData = pattern.getPattern();
        int gridWidth = gridData[0].length;
        int gridHeight = gridData.length;
        int columnOffset = 0;
        int rowOffset = 0;
        if (gridWidth > this.getNumberOfColumns()) {
            gridWidth = this.getNumberOfColumns();
        } else {
            columnOffset = (this.getNumberOfColumns() - gridWidth) / 2;
        }
        if (gridHeight > this.getNumberOfRows()) {
            gridHeight = this.getNumberOfRows();
        } else {
            rowOffset = (this.getNumberOfRows() - gridHeight) / 2;
        }
        this.delegate.killAll();
        for (int column = 0; column < gridWidth; ++column) {
            for (int row = 0; row < gridHeight; ++row) {
                if (!gridData[row][column]) continue;
                Cell cell = this.getCellAt(row + rowOffset, column + columnOffset);
                this.updateCell(cell, CellState.LIVE);
            }
        }
    }

    public void updateCell(Cell cell, CellState state) {
        cell.setCellState(state);
        this.session.update(this.session.getFactHandle(cell), cell);
    }

    public void dispose() {
        if (this.session != null) {
            this.session.dispose();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                Cell cell = this.cells[i][j];
                System.out.print(cell.getLiveNeighbors() + (cell.getCellState() == CellState.DEAD ? "D" : "L") + " ");
            }
            System.out.println("");
        }
        return buf.toString();
    }
}

