/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DelayProcessorSupport
extends DelegateAsyncProcessor {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private final ScheduledExecutorService executorService;
    private boolean asyncDelayed;
    private boolean callerRunsWhenRejected = true;

    public DelayProcessorSupport(Processor processor) {
        this(processor, null);
    }

    public DelayProcessorSupport(Processor processor, ScheduledExecutorService executorService) {
        super(processor);
        this.executorService = executorService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isRunAllowed()) {
            exchange.setException(new RejectedExecutionException("Run is not allowed"));
            callback.done(true);
            return true;
        }
        long delay = this.calculateDelay(exchange);
        if (delay <= 0L) {
            return super.process(exchange, callback);
        }
        if (!this.isAsyncDelayed() || exchange.isTransacted()) {
            try {
                this.delay(delay, exchange);
                return super.process(exchange, callback);
            }
            catch (Exception e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        ProcessCall call = new ProcessCall(exchange, callback);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Scheduling delayed task to run in " + delay + " millis for exchangeId: " + exchange.getExchangeId()));
            }
            this.executorService.schedule(call, delay, TimeUnit.MILLISECONDS);
            return false;
        }
        catch (RejectedExecutionException e) {
            if (this.isCallerRunsWhenRejected()) {
                if (this.isRunAllowed()) {
                    this.delay(delay, exchange);
                    return super.process(exchange, callback);
                }
                exchange.setException(new RejectedExecutionException());
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    public boolean isAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    protected abstract long calculateDelay(Exchange var1);

    protected void delay(long delay, Exchange exchange) {
        if (!this.isRunAllowed()) {
            return;
        }
        if (delay < 0L) {
            return;
        }
        try {
            this.sleep(delay);
        }
        catch (InterruptedException e) {
            this.handleSleepInterruptedException(e);
        }
    }

    protected void handleSleepInterruptedException(InterruptedException e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sleep interrupted, are we stopping? " + (this.isStopping() || this.isStopped())));
        }
    }

    protected long currentSystemTime() {
        return System.currentTimeMillis();
    }

    private void sleep(long delay) throws InterruptedException {
        if (delay <= 0L) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Sleeping for: " + delay + " millis"));
        }
        Thread.sleep(delay);
    }

    protected void doStart() throws Exception {
        if (this.isAsyncDelayed()) {
            ObjectHelper.notNull(this.executorService, "executorService", this);
        }
        super.doStart();
    }

    private final class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        public ProcessCall(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        public void run() {
            if (DelayProcessorSupport.this.log.isTraceEnabled()) {
                DelayProcessorSupport.this.log.trace((Object)("Delayed task woke up and continues routing for exchangeId: " + this.exchange.getExchangeId()));
            }
            if (!DelayProcessorSupport.this.isRunAllowed()) {
                this.exchange.setException(new RejectedExecutionException("Run is not allowed"));
            }
            DelayProcessorSupport.super.process(this.exchange, this.callback);
            this.callback.done(false);
        }
    }
}

