/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.RoutePolicy;

public class RoutePolicyProcessor
extends DelegateAsyncProcessor {
    private final RoutePolicy routePolicy;
    private Route route;

    public RoutePolicyProcessor(Processor processor, RoutePolicy routePolicy) {
        super(processor);
        this.routePolicy = routePolicy;
    }

    public String toString() {
        return "RoutePolicy[" + this.routePolicy + "]";
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.isRoutePolicyRunAllowed()) {
            this.routePolicy.onExchangeBegin(this.route, exchange);
            exchange.addOnCompletion(new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    if (RoutePolicyProcessor.isCamelStopping(exchange.getContext())) {
                        return;
                    }
                    RoutePolicyProcessor.this.routePolicy.onExchangeDone(RoutePolicyProcessor.this.route, exchange);
                }

                public String toString() {
                    return "RoutePolicy";
                }
            });
        }
        return super.process(exchange, callback);
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    private static boolean isCamelStopping(CamelContext context) {
        if (context instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)context);
            return ss.isStopping() || ss.isStopped();
        }
        return false;
    }

    private boolean isRoutePolicyRunAllowed() {
        if (this.routePolicy instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)this.routePolicy);
            return ss.isRunAllowed();
        }
        return true;
    }
}

