/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.model.DescriptionDefinition;

@Converter
public class CamelConverter {
    @Converter
    public Processor toProcessor(final Predicate predicate) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                boolean answer = predicate.matches(exchange);
                Message out = exchange.getOut();
                out.copyFrom(exchange.getIn());
                out.setBody(answer);
            }
        };
    }

    @Converter
    public Processor toProcessor(final Expression expresion) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                Object answer = expresion.evaluate(exchange, Object.class);
                Message out = exchange.getOut();
                out.copyFrom(exchange.getIn());
                out.setBody(answer);
            }
        };
    }

    @Converter
    public DescriptionDefinition toDefinition(String descriptionText) {
        DescriptionDefinition answer = new DescriptionDefinition();
        answer.setText(descriptionText);
        return answer;
    }
}

